/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.javadoc;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDocRenderer {
    private static final int MASK_NORMAL = 0;
    private static final int MASK_FLAVOR_SELECTED = 1;
    private static final int MASK_ITEM_HIDDEN = 2;

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceType type, @NotNull String name, boolean framework) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(1);
        }
        if (name == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(2);
        }
        return AndroidJavaDocRenderer.render(module, null, type, name, framework);
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration, @NotNull ResourceType type, @NotNull String name, boolean framework) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(3);
        }
        if (type == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(5);
        }
        return AndroidJavaDocRenderer.render(module, configuration, ResourceUrl.create((ResourceType)type, (String)name, (boolean)framework));
    }

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceUrl url) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(6);
        }
        if (url == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(7);
        }
        return AndroidJavaDocRenderer.render(module, null, url);
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration, @NotNull ResourceUrl url) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(8);
        }
        if (url == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(9);
        }
        ResourceValueRenderer renderer = ResourceValueRenderer.create(url.type, module, configuration);
        boolean framework = url.isFramework();
        if (renderer == null || framework && renderer.getFrameworkResources() == null || !framework && renderer.getAppResources() == null) {
            return null;
        }
        String valueDoc = renderer.render(url);
        if (url.isTheme()) {
            String attrDoc = AndroidJavaDocRenderer.renderAttributeDoc(module, configuration, (url.isFramework() ? "android:" : "") + url.name);
            if (valueDoc == null) {
                return attrDoc;
            }
            return AndroidJavaDocRenderer.injectExternalDocumentation(attrDoc, valueDoc);
        }
        return valueDoc;
    }

    @NotNull
    private static String renderAttributeDoc(@NotNull Module module, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinition def;
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(10);
        }
        if (name == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(11);
        }
        String doc = (def = ResolutionUtils.getAttributeDefinition(module, configuration, name)) == null ? null : def.getDocValue(null);
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        builder.beginBold();
        builder.add(name);
        builder.endBold();
        int api = ResolutionUtils.getOriginalApiLevel(name, module.getProject());
        if (api > 1) {
            builder.add(" (Added in API level ");
            builder.add(String.valueOf(api));
            builder.add(")");
        }
        builder.addHtml("<br/>");
        if (!StringUtil.isEmpty((String)doc)) {
            builder.addHtml(doc);
            builder.addHtml("<br/>");
        }
        builder.addHtml("<hr/>");
        builder.closeHtmlBody();
        String string = builder.getHtml();
        if (string == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static String injectExternalDocumentation(@Nullable String rendered, @Nullable String external) {
        if (rendered == null) {
            return external;
        }
        if (external == null) {
            return rendered;
        }
        int styleStart = external.indexOf("<style");
        int styleEnd = external.indexOf("</style>");
        if (styleStart != -1 && styleEnd != -1) {
            String style = external.substring(styleStart, styleEnd + "</style>".length());
            external = external.substring(0, styleStart) + external.substring(styleEnd + "</style>".length());
            int insert = rendered.indexOf("<body>");
            if (insert != -1) {
                int headEnd = rendered.lastIndexOf("</head>", insert);
                if (headEnd != -1) {
                    insert = headEnd;
                    rendered = rendered.substring(0, insert) + style + rendered.substring(insert);
                } else {
                    rendered = rendered.substring(0, insert) + "<head>" + style + "</head>" + rendered.substring(insert);
                }
            }
        }
        external = AndroidJavaDocRenderer.getTagContent(AndroidJavaDocRenderer.getTagContent(external, "body"), "html");
        int bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</body>", (int)0);
        if (bodyEnd == -1) {
            bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</html>", (int)0);
        }
        if (bodyEnd != -1) {
            return rendered.substring(0, bodyEnd) + external + rendered.substring(bodyEnd);
        }
        return rendered + external;
    }

    @NotNull
    private static String getTagContent(@NotNull String text, @NotNull String tag) {
        if (text == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(13);
        }
        if (tag == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(14);
        }
        int start = StringUtil.indexOfIgnoreCase((String)text, (String)("<" + tag), (int)0);
        int end = StringUtil.indexOfIgnoreCase((String)text, (String)("</" + tag + ">"), (int)0);
        if (start != -1 && end != -1 && (start = StringUtil.indexOfIgnoreCase((String)text, (String)">", (int)start)) != -1) {
            String string = text.substring(start + 1, end);
            if (string == null) {
                AndroidJavaDocRenderer.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean haveFlavors(List<ItemInfo> items2) {
        for (ItemInfo info : items2) {
            if (info.flavor == null) continue;
            return true;
        }
        return false;
    }

    private static void markHidden(List<ItemInfo> items2) {
        HashSet<String> hiddenQualifiers = new HashSet<String>();
        for (ItemInfo info : items2) {
            String folder = info.folder;
            if (hiddenQualifiers.contains(folder)) {
                info.displayMask |= 2;
            }
            hiddenQualifiers.add(folder);
        }
    }

    private static String renderFolderName(String name) {
        String prefix = "values";
        if (name.equals(prefix)) {
            return "Default";
        }
        if (name.startsWith(prefix + '-')) {
            return name.substring(prefix.length() + 1);
        }
        return name;
    }

    @NotNull
    private static ResourceReference urlToReference(ResourceUrl url) {
        ResourceReference resourceReference = new ResourceReference(url.type, url.name, url.isFramework());
        if (resourceReference == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(17);
        }
        return resourceReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Dimension getSize(File file) {
        try {
            ImageInputStream input = ImageIO.createImageInputStream(file);
            if (input != null) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            reader.setInput(input);
                            Dimension dimension2 = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            reader.dispose();
                            return dimension2;
                        }
                        catch (Throwable throwable) {
                            reader.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "renderAttributeDoc";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagContent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderAttributeDoc";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTagContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ItemInfo
    implements Comparable<ItemInfo> {
        @Nullable
        public final ResourceValue value;
        @NotNull
        public final FolderConfiguration configuration;
        @Nullable
        public final String flavor;
        @NotNull
        public final String folder;
        public final int rank;
        public int displayMask;

        private ItemInfo(@Nullable ResourceValue value, @NotNull FolderConfiguration configuration, @NotNull String folder, @Nullable String flavor, int rank, int initialMask) {
            if (configuration == null) {
                ItemInfo.$$$reportNull$$$0(0);
            }
            if (folder == null) {
                ItemInfo.$$$reportNull$$$0(1);
            }
            this.value = value;
            this.configuration = configuration;
            this.flavor = flavor;
            this.folder = folder;
            this.displayMask = initialMask;
            this.rank = rank;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemInfo itemInfo = (ItemInfo)o;
            if (this.rank != itemInfo.rank) {
                return false;
            }
            if (!this.configuration.equals((Object)itemInfo.configuration)) {
                return false;
            }
            if (this.flavor != null ? !this.flavor.equals(itemInfo.flavor) : itemInfo.flavor != null) {
                return false;
            }
            if (!this.folder.equals(itemInfo.folder)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals((Object)itemInfo.value) : itemInfo.value != null);
        }

        public int hashCode() {
            int result2 = this.value != null ? this.value.hashCode() : 0;
            result2 = 31 * result2 + this.configuration.hashCode();
            result2 = 31 * result2 + (this.flavor != null ? this.flavor.hashCode() : 0);
            result2 = 31 * result2 + this.folder.hashCode();
            result2 = 31 * result2 + this.rank;
            return result2;
        }

        @Override
        public int compareTo(@NotNull ItemInfo other) {
            if (other == null) {
                ItemInfo.$$$reportNull$$$0(2);
            }
            if (this.rank != other.rank) {
                return this.rank - other.rank;
            }
            DensityQualifier density1 = this.configuration.getDensityQualifier();
            DensityQualifier density2 = other.configuration.getDensityQualifier();
            if (density1 != null && density2 != null) {
                Density density1Value = density1.getValue() == null ? Density.MEDIUM : density1.getValue();
                Density density2Value = density2.getValue() == null ? Density.MEDIUM : density2.getValue();
                int delta = density2Value.compareTo((Enum)density1Value);
                if (delta != 0) {
                    return delta;
                }
                if (density1Value == Density.MEDIUM && density1 != density2) {
                    return density2 == density2.getNullQualifier() ? 1 : 0;
                }
            }
            return this.configuration.compareTo(other.configuration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ItemInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ColorValueRenderer
    extends ResourceValueRenderer {
        private ColorValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                ColorValueRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value) {
            if (resolver == null) {
                ColorValueRenderer.$$$reportNull$$$0(1);
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value != null) {
                value = resolver.resolveResValue(value);
            }
            return value;
        }

        private static float resolveAlpha(@NotNull ResourceItemResolver resolver, @Nullable String alphaValue) {
            if (resolver == null) {
                ColorValueRenderer.$$$reportNull$$$0(2);
            }
            float alpha = 1.0f;
            if (alphaValue != null) {
                try {
                    alpha = Float.parseFloat(ResourceHelper.resolveStringValue((RenderResources)resolver, alphaValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return alpha;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            if (builder == null) {
                ColorValueRenderer.$$$reportNull$$$0(3);
            }
            if (item == null) {
                ColorValueRenderer.$$$reportNull$$$0(4);
            }
            if (url == null) {
                ColorValueRenderer.$$$reportNull$$$0(5);
            }
            ResourceItemResolver resolver = this.createResolver(item);
            resourceValue2 = ColorValueRenderer.resolveValue(resolver, resourceValue2);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue2 != null) {
                this.renderColorToHtml(resolver, builder, resourceValue2, showResolution, 1.0f, 0);
            } else if (item.value != null) {
                ColorValueRenderer.renderError(builder, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }

        private void renderColorToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder, @NotNull ResourceValue resourceValue2, boolean showResolution, float alpha, int depth) {
            if (resolver == null) {
                ColorValueRenderer.$$$reportNull$$$0(6);
            }
            if (builder == null) {
                ColorValueRenderer.$$$reportNull$$$0(7);
            }
            if (resourceValue2 == null) {
                ColorValueRenderer.$$$reportNull$$$0(8);
            }
            if (depth >= 50) {
                ColorValueRenderer.renderError(builder, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resourceValue2, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    ColorValueRenderer.renderError(builder, "Empty StateList");
                } else {
                    builder.addHtml("<table>");
                    for (StateListState state : states) {
                        builder.addHtml("<tr>");
                        builder.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        float stateAlpha = ColorValueRenderer.resolveAlpha(resolver, state.getAlpha()) * alpha;
                        ResourceValue resolvedStateResource = resolver.findResValue(state.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = ColorValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderColorToHtml(resolver, builder, resolvedStateResource, showResolution, stateAlpha, depth + 1);
                        } else {
                            this.renderColorToHtml(builder, state.getValue(), stateAlpha);
                        }
                        this.mySmall = oldSmall;
                        builder.addHtml("</td>");
                        builder.addHtml("<td>");
                        builder.addHtml(state.getDescription());
                        builder.addHtml("</td>");
                        if (lookupChain != null) {
                            builder.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder, true, false);
                            builder.addHtml("</td>");
                        }
                        builder.addHtml("</tr>");
                    }
                    builder.addHtml("</table>");
                }
            } else {
                this.renderColorToHtml(builder, resourceValue2.getValue(), alpha);
            }
        }

        private void renderColorToHtml(@NotNull HtmlBuilder builder, @Nullable String colorString, float alpha) {
            Color color;
            if (builder == null) {
                ColorValueRenderer.$$$reportNull$$$0(9);
            }
            if ((color = ResourceHelper.parseColor(colorString)) == null) {
                ColorValueRenderer.renderError(builder, colorString);
                return;
            }
            int combinedAlpha = (int)((float)color.getAlpha() * alpha);
            color = ColorUtil.toAlpha((Color)color, (int)ResourceHelper.clamp(combinedAlpha, 0, 255));
            this.renderColorToHtml(builder, color);
        }

        public void renderColorToHtml(@NotNull HtmlBuilder builder, @NotNull Color color) {
            if (builder == null) {
                ColorValueRenderer.$$$reportNull$$$0(10);
            }
            if (color == null) {
                ColorValueRenderer.$$$reportNull$$$0(11);
            }
            Color displayColor = color;
            int width = 200;
            int height = 100;
            if (this.mySmall) {
                int divisor = 3;
                width /= divisor;
                height /= divisor;
            }
            if (color.getAlpha() != 255) {
                float alpha = (float)color.getAlpha() / 255.0f;
                Color backgroundColor = EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)DocumentationComponent.COLOR_KEY);
                if (backgroundColor != null) {
                    color = new Color((int)((float)backgroundColor.getRed() * (1.0f - alpha) + alpha * (float)color.getRed()), (int)((float)backgroundColor.getGreen() * (1.0f - alpha) + alpha * (float)color.getGreen()), (int)((float)backgroundColor.getBlue() * (1.0f - alpha) + alpha * (float)color.getBlue()));
                }
            }
            String colorString = String.format(Locale.US, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
            String foregroundColor = ColorUtil.isDark((Color)color) ? "white" : "black";
            String css = "background-color:" + colorString + ";width:" + width + "px;text-align:center;vertical-align:middle;";
            builder.addHtml("<table style=\"" + css + "\" border=\"0\"><tr height=\"" + height + "\">");
            builder.addHtml("<td align=\"center\" valign=\"middle\" height=\"" + height + "\" style=\"color:" + foregroundColor + "\">");
            builder.addHtml(ResourceHelper.colorToString(displayColor));
            builder.addHtml("</td></tr></table>");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 3: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceValue";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ColorValueRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveAlpha";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderColorToHtml";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DrawableValueRenderer
    extends ResourceValueRenderer {
        private DrawableValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                DrawableValueRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value) {
            if (resolver == null) {
                DrawableValueRenderer.$$$reportNull$$$0(1);
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value != null) {
                value = resolver.resolveResValue(value);
            }
            return value;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            FolderConfiguration configuration;
            DensityQualifier densityQualifier;
            if (builder == null) {
                DrawableValueRenderer.$$$reportNull$$$0(2);
            }
            if (item == null) {
                DrawableValueRenderer.$$$reportNull$$$0(3);
            }
            if (url == null) {
                DrawableValueRenderer.$$$reportNull$$$0(4);
            }
            if (!ResourceQualifier.isValid((ResourceQualifier)(densityQualifier = (configuration = item.configuration).getDensityQualifier()))) {
                densityQualifier = new DensityQualifier(Density.MEDIUM);
                configuration = FolderConfiguration.copyOf((FolderConfiguration)item.configuration);
                configuration.setDensityQualifier(densityQualifier);
            }
            ResourceItemResolver resolver = this.createResolver(item.value, configuration);
            resourceValue2 = DrawableValueRenderer.resolveValue(resolver, resourceValue2);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue2 != null) {
                this.renderDrawableToHtml(resolver, builder, resourceValue2, showResolution, configuration, 0);
            } else if (item.value != null) {
                DrawableValueRenderer.renderError(builder, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }

        private void renderDrawableToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder, @NotNull ResourceValue resolvedValue, boolean showResolution, @NotNull FolderConfiguration configuration, int depth) {
            if (resolver == null) {
                DrawableValueRenderer.$$$reportNull$$$0(5);
            }
            if (builder == null) {
                DrawableValueRenderer.$$$reportNull$$$0(6);
            }
            if (resolvedValue == null) {
                DrawableValueRenderer.$$$reportNull$$$0(7);
            }
            if (configuration == null) {
                DrawableValueRenderer.$$$reportNull$$$0(8);
            }
            if (depth >= 50) {
                DrawableValueRenderer.renderError(builder, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resolvedValue, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    DrawableValueRenderer.renderError(builder, "Empty StateList");
                } else {
                    builder.addHtml("<table>");
                    for (StateListState state : states) {
                        builder.addHtml("<tr>");
                        builder.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        ResourceValue resolvedStateResource = resolver.findResValue(state.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = DrawableValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderDrawableToHtml(resolver, builder, resolvedStateResource, showResolution, configuration, depth + 1);
                        } else {
                            DrawableValueRenderer.renderError(builder, state.getValue());
                        }
                        this.mySmall = oldSmall;
                        builder.addHtml("</td>");
                        builder.addHtml("<td>");
                        builder.addHtml(state.getDescription());
                        builder.addHtml("</td>");
                        if (lookupChain != null) {
                            builder.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder, true, false);
                            builder.addHtml("</td>");
                        }
                        builder.addHtml("</tr>");
                    }
                    builder.addHtml("</table>");
                }
            } else {
                AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
                assert (facet != null);
                FolderConfiguration folderConfiguration = ResolutionUtils.getFolderConfiguration(facet, resolvedValue, configuration);
                DensityQualifier densityQualifier = folderConfiguration.getDensityQualifier();
                if (!ResourceQualifier.isValid((ResourceQualifier)densityQualifier)) {
                    densityQualifier = configuration.getDensityQualifier();
                    assert (ResourceQualifier.isValid((ResourceQualifier)densityQualifier));
                }
                String value = resolvedValue.getValue();
                assert (value != null);
                this.renderDrawableToHtml(builder, value, densityQualifier.getValue(), resolvedValue);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder, @NotNull String result2, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            File file;
            if (builder == null) {
                DrawableValueRenderer.$$$reportNull$$$0(9);
            }
            if (result2 == null) {
                DrawableValueRenderer.$$$reportNull$$$0(10);
            }
            if (density == null) {
                DrawableValueRenderer.$$$reportNull$$$0(11);
            }
            if (resolvedValue == null) {
                DrawableValueRenderer.$$$reportNull$$$0(12);
            }
            if ((file = new File(result2)).exists() && file.isFile()) {
                this.renderDrawableToHtml(builder, file, density, resolvedValue);
            } else if (result2.startsWith("#")) {
                ColorValueRenderer colorRenderer = (ColorValueRenderer)ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                assert (colorRenderer != null);
                colorRenderer.setSmall(this.mySmall);
                colorRenderer.renderColorToHtml(builder, result2, 1.0f);
            } else {
                DrawableValueRenderer.renderError(builder, result2);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder, @NotNull File file, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            block22: {
                if (builder == null) {
                    DrawableValueRenderer.$$$reportNull$$$0(13);
                }
                if (file == null) {
                    DrawableValueRenderer.$$$reportNull$$$0(14);
                }
                if (density == null) {
                    DrawableValueRenderer.$$$reportNull$$$0(15);
                }
                if (resolvedValue == null) {
                    DrawableValueRenderer.$$$reportNull$$$0(16);
                }
                String path = file.getPath();
                boolean isWebP = path.endsWith(".webp");
                if (SdkUtils.hasImageExtension((String)path) && !isWebP) {
                    URL fileUrl = null;
                    try {
                        fileUrl = SdkUtils.fileToUrl((File)file);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (fileUrl != null) {
                        builder.beginDiv("background-color:gray;padding:10px");
                        builder.addImage(fileUrl, path);
                        builder.endDiv();
                        Dimension size = AndroidJavaDocRenderer.getSize(file);
                        if (size != null) {
                            builder.addHtml(String.format(Locale.US, "%1$d&#xd7;%2$d px (%3$d&#xd7;%4$d dp @ %5$s)", size.width, size.height, DrawableValueRenderer.px2dp(size.width, density), DrawableValueRenderer.px2dp(size.height, density), density.getResourceValue()));
                        }
                    }
                } else if (this.myConfiguration != null) {
                    BufferedImage image;
                    Dimension size;
                    RenderTask renderTask = DrawableRendererEditor.configureRenderTask(this.myModule, this.myConfiguration);
                    int width = 100;
                    int height = 100;
                    if (isWebP && (size = AndroidJavaDocRenderer.getSize(file)) != null) {
                        width = size.width;
                        height = size.height;
                    }
                    renderTask.setOverrideRenderSize(width, height);
                    try {
                        image = (BufferedImage)renderTask.renderDrawable(resolvedValue).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        DrawableValueRenderer.renderError(builder, e.toString());
                        return;
                    }
                    if (image != null) {
                        try {
                            File tempFile = FileUtil.createTempFile((String)"render", (String)".png");
                            tempFile.deleteOnExit();
                            boolean ok = ImageIO.write((RenderedImage)image, "PNG", tempFile);
                            if (!ok) break block22;
                            URL fileUrl = null;
                            try {
                                fileUrl = SdkUtils.fileToUrl((File)tempFile);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            if (fileUrl != null) {
                                builder.beginDiv("background-color:gray;padding:10px");
                                builder.addImage(fileUrl, null);
                                builder.endDiv();
                            }
                        }
                        catch (IOException e) {
                            DrawableValueRenderer.renderError(builder, e.toString());
                        }
                    } else {
                        DrawableValueRenderer.renderError(builder, "Couldn't render " + file);
                    }
                } else {
                    DrawableValueRenderer.renderError(builder, path);
                }
            }
        }

        private static int px2dp(int px, Density density) {
            return (int)((float)px * (float)Density.MEDIUM.getDpiValue() / (float)density.getDpiValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: 
                case 6: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 7: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedValue";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "density";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$DrawableValueRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveValue";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderDrawableToHtml";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ArrayRenderer
    extends ResourceValueRenderer {
        private ArrayRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                ArrayRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value) {
            if (resolver == null) {
                ArrayRenderer.$$$reportNull$$$0(1);
            }
            if (value != null) {
                assert (resolver.getLookupChain() != null);
                resolver.setLookupChainList(new ArrayList());
                return resolver.resolveResValue(value);
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            ResourceItemResolver resolver;
            ResourceValue value;
            if (builder == null) {
                ArrayRenderer.$$$reportNull$$$0(2);
            }
            if (item == null) {
                ArrayRenderer.$$$reportNull$$$0(3);
            }
            if (url == null) {
                ArrayRenderer.$$$reportNull$$$0(4);
            }
            if ((value = ArrayRenderer.resolveValue(resolver = this.createResolver(item), resourceValue2)) instanceof ArrayResourceValue) {
                ArrayResourceValue arv = (ArrayResourceValue)value;
                builder.add(Joiner.on((String)", ").skipNulls().join((Iterable)arv));
            } else if (value != null) {
                builder.add(value.toString());
            }
            if (showResolution) {
                List lookupChain = resolver.getLookupChain();
                assert (lookupChain != null);
                if (lookupChain.size() > 1) {
                    this.displayChain(url, lookupChain, builder, true, false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ArrayRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveValue";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TextValueRenderer
    extends ResourceValueRenderer {
        private TextValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                TextValueRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static String resolveStringValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue itemValue, @NotNull ResourceUrl url) {
            if (resolver == null) {
                TextValueRenderer.$$$reportNull$$$0(1);
            }
            if (url == null) {
                TextValueRenderer.$$$reportNull$$$0(2);
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (itemValue != null) {
                String value = itemValue.getValue();
                if (value != null) {
                    ResourceUrl parsed = ResourceUrl.parse((String)value);
                    if (parsed != null) {
                        ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        v.setValue(url.toString());
                        ResourceValue resourceValue2 = resolver.resolveResValue((ResourceValue)v);
                        if (resourceValue2 != null && resourceValue2.getValue() != null) {
                            return resourceValue2.getValue();
                        }
                    }
                    return value;
                }
                ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                v.setValue(url.toString());
                ResourceValue resourceValue3 = resolver.resolveResValue((ResourceValue)v);
                if (resourceValue3 != null && resourceValue3.getValue() != null) {
                    return resourceValue3.getValue();
                }
                if (resourceValue3 instanceof StyleResourceValue) {
                    return resourceValue3.getResourceUrl().toString();
                }
                return url.toString();
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            if (builder == null) {
                TextValueRenderer.$$$reportNull$$$0(3);
            }
            if (item == null) {
                TextValueRenderer.$$$reportNull$$$0(4);
            }
            if (url == null) {
                TextValueRenderer.$$$reportNull$$$0(5);
            }
            ResourceItemResolver resolver = this.createResolver(item);
            String value = TextValueRenderer.resolveStringValue(resolver, resourceValue2, url);
            List lookupChain = resolver.getLookupChain();
            if (value != null) {
                boolean found = false;
                if (url.isTheme()) {
                    File f;
                    ResourceValueImpl resolved;
                    ResourceValueRenderer renderer;
                    if (value.startsWith("#")) {
                        Color color = ResourceHelper.parseColor(value);
                        if (color != null) {
                            found = true;
                            renderer = ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                            assert (renderer != null);
                            resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                            resolved.setValue(value);
                            renderer.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                            builder.newline();
                        }
                    } else if (value.endsWith(".png") && (f = new File(value)).exists()) {
                        found = true;
                        renderer = ResourceValueRenderer.create(ResourceType.DRAWABLE, this.myModule, this.myConfiguration);
                        assert (renderer != null);
                        resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        resolved.setValue(value);
                        renderer.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                        builder.newline();
                    }
                    if (!found) {
                        assert (lookupChain != null);
                        for (int i = lookupChain.size() - 1; i >= 0; --i) {
                            ResourceValueRenderer renderer2;
                            ResourceUrl resourceUrl;
                            String value2;
                            ResourceValue rv = (ResourceValue)lookupChain.get(i);
                            if (rv == null || (value2 = rv.getValue()) == null || (resourceUrl = ResourceUrl.parse((String)value2, (boolean)rv.isFramework())) == null || resourceUrl.isTheme() || (renderer2 = TextValueRenderer.create(resourceUrl.type, this.myModule, this.myConfiguration)) == null || renderer2.getClass() == this.getClass()) continue;
                            found = true;
                            ResourceValueImpl resolved2 = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(resourceUrl), null);
                            resolved2.setValue(value);
                            renderer2.renderToHtml(builder, item, resourceUrl, false, (ResourceValue)resolved2);
                            builder.newline();
                            break;
                        }
                    }
                }
                if (!(found || showResolution && lookupChain != null && !lookupChain.isEmpty())) {
                    builder.add(value);
                }
            } else if (item.value != null && item.value.getValue() != null) {
                builder.add(item.value.getValue());
            }
            if (showResolution) {
                ResourceValue rv;
                assert (lookupChain != null);
                this.displayChain(url, lookupChain, builder, true, true);
                if (!lookupChain.isEmpty() && (rv = (ResourceValue)lookupChain.get(lookupChain.size() - 1)) instanceof StyleResourceValue) {
                    StyleResourceValue srv = (StyleResourceValue)rv;
                    this.displayStyleValues(builder, item, resolver, srv);
                }
            }
        }

        private void displayStyleValues(HtmlBuilder builder, ItemInfo item, ResourceItemResolver resolver, StyleResourceValue styleValue) {
            List lookupChain = resolver.getLookupChain();
            builder.addHtml("<hr>");
            builder.addBold(styleValue.getName()).add(":").newline();
            HashSet<String> masked = new HashSet<String>();
            while (styleValue != null) {
                ImmutableList values2 = Ordering.usingToString().immutableSortedCopy((Iterable)styleValue.getDefinedItems());
                for (StyleItemResourceValue itemResourceValue : values2) {
                    StyleItemResourceValueImpl v;
                    String name = itemResourceValue.getAttrName();
                    if (masked.contains(name)) continue;
                    masked.add(name);
                    String value = null;
                    ResourceReference attr = itemResourceValue.getAttr();
                    if (attr != null && (v = styleValue.getItem(attr)) != null) {
                        value = v.getValue();
                    }
                    builder.addNbsps(4);
                    if (attr != null && attr.getNamespace() == ResourceNamespace.ANDROID) {
                        builder.add("android:");
                    }
                    builder.addBold(name).add(" = ").add(value == null ? "null" : value);
                    if (value != null) {
                        ResourceUrl url = ResourceUrl.parse((String)value, (boolean)styleValue.isFramework());
                        if (url != null) {
                            ResourceValueRenderer renderer;
                            ResourceUrl resolvedUrl = url;
                            int count = 0;
                            while (resolvedUrl != null) {
                                ResourceValue resourceValue2;
                                if (lookupChain != null) {
                                    lookupChain.clear();
                                }
                                if (resolvedUrl.isTheme()) {
                                    ResourceReference ref = new ResourceReference(ResourceNamespace.fromBoolean((boolean)resolvedUrl.isFramework()), ResourceType.ATTR, resolvedUrl.name);
                                    resourceValue2 = resolver.findItemInTheme(ref);
                                } else {
                                    resourceValue2 = resolver.findResValue(resolvedUrl.toString(), resolvedUrl.isFramework());
                                }
                                if (resourceValue2 == null || resourceValue2.getValue() == null) break;
                                url = resolvedUrl;
                                value = resourceValue2.getValue();
                                resolvedUrl = ResourceUrl.parse((String)value, (boolean)resolvedUrl.isFramework());
                                if (count++ != 50) continue;
                                break;
                            }
                            if ((renderer = TextValueRenderer.create(url.type, this.myModule, this.myConfiguration)) != null && renderer.getClass() != this.getClass()) {
                                builder.newline();
                                renderer.setSmall(true);
                                ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), value);
                                renderer.renderToHtml(builder, item, url, false, (ResourceValue)resolved);
                                continue;
                            }
                            builder.add(" => ");
                            int index = value.indexOf("exploded-aar");
                            if (index != -1) {
                                value = value.substring(index + "exploded-aar".length() + 1);
                            }
                            builder.add(value);
                            builder.newline();
                            continue;
                        }
                        builder.newline();
                        continue;
                    }
                    builder.newline();
                }
                if ((styleValue = resolver.getParent(styleValue)) == null) continue;
                builder.newline();
                builder.add("Inherits from: ").add(styleValue.getResourceUrl().toString()).add(":").newline();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$TextValueRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveStringValue";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ResourceValueRenderer
    implements ResourceItemResolver.ResourceProvider {
        protected final Module myModule;
        protected final Configuration myConfiguration;
        protected LocalResourceRepository myAppResources;
        protected ResourceResolver myResourceResolver;
        protected boolean mySmall;
        protected AbstractResourceRepository myFrameworkResources;

        protected ResourceValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                ResourceValueRenderer.$$$reportNull$$$0(0);
            }
            this.myModule = module;
            this.myConfiguration = configuration;
        }

        protected ResourceValueRenderer(Module module) {
            this(module, null);
        }

        public void setSmall(boolean small) {
            this.mySmall = small;
        }

        public abstract void renderToHtml(@NotNull HtmlBuilder var1, @NotNull ItemInfo var2, @NotNull ResourceUrl var3, boolean var4, @Nullable ResourceValue var5);

        @Nullable
        public static ResourceValueRenderer create(@NotNull ResourceType type, @NotNull Module module, @Nullable Configuration configuration) {
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(1);
            }
            if (module == null) {
                ResourceValueRenderer.$$$reportNull$$$0(2);
            }
            switch (type) {
                case ATTR: 
                case STRING: 
                case DIMEN: 
                case INTEGER: 
                case BOOL: 
                case STYLE: {
                    return new TextValueRenderer(module, configuration);
                }
                case ARRAY: {
                    return new ArrayRenderer(module, configuration);
                }
                case MIPMAP: 
                case DRAWABLE: {
                    return new DrawableValueRenderer(module, configuration);
                }
                case COLOR: {
                    return new ColorValueRenderer(module, configuration);
                }
            }
            return null;
        }

        @Nullable
        private static AbstractResourceRepository getLatestPublicFrameworkResources(Module module) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            IAndroidTarget target = ConfigurationManager.getOrCreateInstance(module).getDefaultTarget();
            if (target == null) {
                return null;
            }
            AndroidTargetData targetData = AndroidTargetData.getTargetData(target, module);
            if (targetData != null) {
                return targetData.getFrameworkResources(true);
            }
            return null;
        }

        @Nullable
        public String render(@NotNull ResourceUrl url) {
            List<ItemInfo> items2;
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(3);
            }
            if ((items2 = this.gatherItems(url)) != null) {
                Collections.sort(items2);
                return this.renderKeyValues(items2, url);
            }
            return null;
        }

        @Nullable
        private List<ItemInfo> gatherItems(@NotNull ResourceUrl url) {
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(4);
            }
            ResourceType type = url.type;
            String resourceName = url.name;
            boolean framework = url.isFramework();
            if (framework) {
                ArrayList<ItemInfo> results = new ArrayList<ItemInfo>();
                this.addItemsFromFramework(null, 0, 0, type, resourceName, results);
                return results;
            }
            AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
            if (facet == null) {
                return null;
            }
            ArrayList<ItemInfo> results = new ArrayList<ItemInfo>();
            LocalResourceRepository resources = this.getAppResources();
            List<AndroidFacet> dependencies = AndroidUtils.getAllAndroidDependencies(this.myModule, true);
            boolean hasGradleModel = false;
            int rank = 0;
            for (AndroidFacet androidFacet : Iterables.concat((Iterable)ImmutableList.of((Object)((Object)facet)), dependencies)) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(androidFacet);
                if (androidModel == null) continue;
                hasGradleModel = true;
                String facetModuleName = androidFacet.getModule().getName();
                assert (androidFacet.requiresAndroidModel());
                IdeAndroidProject androidProject = androidModel.getAndroidProject();
                IdeVariant selectedVariant = androidModel.getSelectedVariant();
                HashSet<SourceProvider> selectedProviders = new HashSet<SourceProvider>();
                BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
                assert (buildType != null);
                SourceProvider sourceProvider = buildType.getSourceProvider();
                String buildTypeName = selectedVariant.getName();
                ResourceValueRenderer.addItemsFromSourceSet(buildTypeName + " (" + facetModuleName + ")", 1, rank++, sourceProvider, type, resourceName, results, androidFacet);
                selectedProviders.add(sourceProvider);
                List productFlavors = selectedVariant.getProductFlavors();
                for (int i = productFlavors.size() - 1; i >= 0; --i) {
                    String flavorName = (String)productFlavors.get(i);
                    ProductFlavorContainer productFlavor = androidModel.findProductFlavor(flavorName);
                    assert (productFlavor != null);
                    SourceProvider provider = productFlavor.getSourceProvider();
                    ResourceValueRenderer.addItemsFromSourceSet(flavorName + " (" + facetModuleName + ")", 1, rank++, provider, type, resourceName, results, androidFacet);
                    selectedProviders.add(provider);
                }
                SourceProvider main = androidProject.getDefaultConfig().getSourceProvider();
                ResourceValueRenderer.addItemsFromSourceSet("main (" + facetModuleName + ")", 1, rank++, main, type, resourceName, results, androidFacet);
                selectedProviders.add(main);
                Collection buildTypes = androidProject.getBuildTypes();
                for (BuildTypeContainer container : buildTypes) {
                    SourceProvider provider = container.getSourceProvider();
                    if (selectedProviders.contains(provider)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getBuildType().getName() + " (" + facetModuleName + ")", 0, rank++, provider, type, resourceName, results, androidFacet);
                    selectedProviders.add(provider);
                }
                Collection flavors = androidProject.getProductFlavors();
                for (ProductFlavorContainer container : flavors) {
                    SourceProvider provider = container.getSourceProvider();
                    if (selectedProviders.contains(provider)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getProductFlavor().getName() + " (" + facetModuleName + ")", 0, rank++, provider, type, resourceName, results, androidFacet);
                    selectedProviders.add(provider);
                }
            }
            if (resources != null) {
                if (hasGradleModel) {
                    for (LocalResourceRepository localResourceRepository : ResourceRepositoryManager.getOrCreateInstance(facet).getLibraries()) {
                        ResourceValueRenderer.addItemsFromRepository(localResourceRepository.getDisplayName(), 0, rank++, localResourceRepository, false, type, resourceName, results);
                    }
                } else {
                    ResourceValueRenderer.addItemsFromRepository(null, 0, 0, resources, false, type, resourceName, results);
                }
            }
            return results;
        }

        private static void addItemsFromSourceSet(@Nullable String flavor, int mask, int rank, @NotNull SourceProvider sourceProvider, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results, @NotNull AndroidFacet facet) {
            if (sourceProvider == null) {
                ResourceValueRenderer.$$$reportNull$$$0(5);
            }
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(6);
            }
            if (name == null) {
                ResourceValueRenderer.$$$reportNull$$$0(7);
            }
            if (results == null) {
                ResourceValueRenderer.$$$reportNull$$$0(8);
            }
            if (facet == null) {
                ResourceValueRenderer.$$$reportNull$$$0(9);
            }
            Collection resDirectories = sourceProvider.getResDirectories();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File dir : resDirectories) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
                if (virtualFile == null) continue;
                ResourceFolderRepository resources = ResourceFolderRegistry.getInstance(facet.getModule().getProject()).get(facet, virtualFile);
                ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, resources, false, type, name, results);
            }
        }

        private void addItemsFromFramework(@Nullable String flavor, int mask, int rank, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            AbstractResourceRepository frameworkResources;
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(10);
            }
            if (name == null) {
                ResourceValueRenderer.$$$reportNull$$$0(11);
            }
            if (results == null) {
                ResourceValueRenderer.$$$reportNull$$$0(12);
            }
            if ((frameworkResources = this.getFrameworkResources()) == null) {
                return;
            }
            ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, frameworkResources, true, type, name, results);
        }

        private static void addItemsFromRepository(@Nullable String flavor, int mask, int rank, @NotNull AbstractResourceRepository resources, boolean isFramework, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            if (resources == null) {
                ResourceValueRenderer.$$$reportNull$$$0(13);
            }
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(14);
            }
            if (name == null) {
                ResourceValueRenderer.$$$reportNull$$$0(15);
            }
            if (results == null) {
                ResourceValueRenderer.$$$reportNull$$$0(16);
            }
            ResourceNamespace namespace = isFramework ? ResourceNamespace.ANDROID : ResourceNamespace.TODO();
            List items2 = resources.getResourceItems(namespace, type, name);
            for (ResourceItem item : items2) {
                String folderName = null;
                PathString source = item.getSource();
                if (source != null) {
                    folderName = source.getParentFileName();
                }
                if (folderName == null) {
                    folderName = "?";
                }
                String folder = AndroidJavaDocRenderer.renderFolderName(folderName);
                ResourceValue value = item.getResourceValue();
                ItemInfo info = new ItemInfo(value, item.getConfiguration(), folder, flavor, rank, mask);
                results.add(info);
            }
        }

        @Nullable
        private String renderKeyValues(@NotNull List<ItemInfo> items2, @NotNull ResourceUrl url) {
            if (items2 == null) {
                ResourceValueRenderer.$$$reportNull$$$0(17);
            }
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(18);
            }
            if (items2.isEmpty()) {
                return null;
            }
            AndroidJavaDocRenderer.markHidden(items2);
            HtmlBuilder builder = new HtmlBuilder();
            builder.openHtmlBody();
            if (items2.size() == 1) {
                this.renderToHtml(builder, items2.get(0), url, true, items2.get((int)0).value);
            } else {
                builder.beginTable("valign=\"top\"");
                boolean haveFlavors = AndroidJavaDocRenderer.haveFlavors(items2);
                if (haveFlavors) {
                    builder.addTableRow(true, new String[]{"Flavor/Library", "Configuration", "Value"});
                } else {
                    builder.addTableRow(true, new String[]{"Configuration", "Value"});
                }
                String prevFlavor = null;
                boolean showResolution = true;
                for (ItemInfo info : items2) {
                    String style;
                    String folder = info.folder;
                    String flavor = StringUtil.notNullize((String)info.flavor);
                    if (flavor.equals(prevFlavor)) {
                        flavor = "";
                    } else {
                        prevFlavor = flavor;
                    }
                    builder.addHtml("<tr>");
                    if (haveFlavors) {
                        style = (info.displayMask & 1) != 0 ? "b" : null;
                        this.addTableCell(builder, style, flavor, null, null, false);
                    }
                    this.addTableCell(builder, null, folder, null, null, false);
                    style = (info.displayMask & 2) != 0 ? "s" : null;
                    this.addTableCell(builder, style, null, info, url, showResolution);
                    showResolution = false;
                    builder.addHtml("</tr>");
                }
                builder.endTable();
            }
            builder.closeHtmlBody();
            return builder.getHtml();
        }

        private void addTableCell(@NotNull HtmlBuilder builder, @Nullable String attribute, @Nullable String text, @Nullable ItemInfo info, @Nullable ResourceUrl url, boolean showResolution) {
            if (builder == null) {
                ResourceValueRenderer.$$$reportNull$$$0(19);
            }
            builder.addHtml("<td valign=\"top\">");
            if (attribute != null) {
                builder.addHtml("<").addHtml(attribute).addHtml(">");
            }
            if (text != null) {
                builder.add(text);
            } else {
                assert (info != null);
                assert (url != null);
                this.renderToHtml(builder, info, url, showResolution, info.value);
            }
            if (attribute != null) {
                builder.addHtml("</").addHtml(attribute).addHtml(">");
            }
            builder.addHtml("</td>");
        }

        @NotNull
        protected ResourceItemResolver createResolver(@NotNull ItemInfo item) {
            if (item == null) {
                ResourceValueRenderer.$$$reportNull$$$0(20);
            }
            ResourceItemResolver resourceItemResolver = this.createResolver(item.value, item.configuration);
            if (resourceItemResolver == null) {
                ResourceValueRenderer.$$$reportNull$$$0(21);
            }
            return resourceItemResolver;
        }

        @NotNull
        protected ResourceItemResolver createResolver(@Nullable ResourceValue value, @NotNull FolderConfiguration configuration) {
            if (configuration == null) {
                ResourceValueRenderer.$$$reportNull$$$0(22);
            }
            ResourceItemResolver resolver = new ResourceItemResolver(configuration, (ResourceItemResolver.ResourceProvider)this, null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>();
            lookupChain.add(value);
            resolver.setLookupChainList(lookupChain);
            ResourceItemResolver resourceItemResolver = resolver;
            if (resourceItemResolver == null) {
                ResourceValueRenderer.$$$reportNull$$$0(23);
            }
            return resourceItemResolver;
        }

        protected void displayChain(@NotNull ResourceUrl url, @NotNull List<ResourceValue> lookupChain, @NotNull HtmlBuilder builder, boolean newlineBefore, boolean newlineAfter) {
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(24);
            }
            if (lookupChain == null) {
                ResourceValueRenderer.$$$reportNull$$$0(25);
            }
            if (builder == null) {
                ResourceValueRenderer.$$$reportNull$$$0(26);
            }
            if (!lookupChain.isEmpty()) {
                if (newlineBefore) {
                    builder.newline();
                }
                String text = ResourceItemResolver.getDisplayString((String)url.toString(), lookupChain);
                builder.add(text);
                builder.newline();
                if (newlineAfter) {
                    builder.newline();
                }
            }
        }

        @Nullable
        public AbstractResourceRepository getFrameworkResources() {
            if (this.myFrameworkResources == null) {
                this.myFrameworkResources = ResourceValueRenderer.getLatestPublicFrameworkResources(this.myModule);
            }
            return this.myFrameworkResources;
        }

        @Nullable
        public LocalResourceRepository getAppResources() {
            if (this.myAppResources == null) {
                this.myAppResources = ResourceRepositoryManager.getAppResources(this.myModule);
            }
            return this.myAppResources;
        }

        @Nullable
        public ResourceResolver getResolver(boolean createIfNecessary) {
            if (this.myResourceResolver == null && createIfNecessary) {
                VirtualFile layout2;
                AndroidFacet facet;
                if (this.myConfiguration != null) {
                    this.myResourceResolver = this.myConfiguration.getResourceResolver();
                    if (this.myResourceResolver != null) {
                        return this.myResourceResolver;
                    }
                }
                if ((facet = AndroidFacet.getInstance(this.myModule)) != null && (layout2 = ResourceHelper.pickAnyLayoutFile(this.myModule, facet)) != null) {
                    Configuration configuration = ConfigurationManager.getOrCreateInstance(this.myModule).getConfiguration(layout2);
                    this.myResourceResolver = configuration.getResourceResolver();
                }
            }
            return this.myResourceResolver;
        }

        public static void renderError(@NotNull HtmlBuilder builder, @Nullable String error) {
            if (builder == null) {
                ResourceValueRenderer.$$$reportNull$$$0(27);
            }
            builder.beginColor((Color)JBColor.RED);
            builder.addBold(error == null ? "Error" : error);
            builder.endColor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 21: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 21: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 6: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 18: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceProvider";
                    break;
                }
                case 7: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 8: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resources";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 19: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupChain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "gatherItems";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addItemsFromSourceSet";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addItemsFromFramework";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addItemsFromRepository";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "renderKeyValues";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addTableCell";
                    break;
                }
                case 20: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "createResolver";
                    break;
                }
                case 21: 
                case 23: {
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "displayChain";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "renderError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 21: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

