/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.lint.AddTargetApiQuickFix;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintApiInspection(String displayName, Issue issue2) {
        super(displayName, issue2);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        Integer apiLevel;
        if (startElement == null) {
            AndroidLintApiInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintApiInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintApiInspection.$$$reportNull$$$0(2);
        }
        if ((apiLevel = (Integer)LintFix.getData((LintFix)fixData, Integer.class)) != null) {
            int api = apiLevel;
            ArrayList list = Lists.newArrayList();
            PsiFile file = startElement.getContainingFile();
            boolean isXml = false;
            if (file instanceof XmlFile) {
                FolderConfiguration config;
                isXml = true;
                ResourceFolderType folderType = ResourceHelper.getFolderType(file);
                if (folderType != null && (config = ResourceHelper.getFolderConfiguration(file)) != null) {
                    config.setVersionQualifier(new VersionQualifier(api));
                    String folder = config.getFolderName(folderType);
                    list.add(OverrideResourceAction.createFix(folder));
                }
            }
            list.add(new AddTargetVersionCheckQuickFix(api));
            list.add(new AddTargetApiQuickFix(api, false, startElement));
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Project project = startElement.getProject();
            if (!(isXml || JavaPsiFacade.getInstance((Project)project).findClass(ApiDetector.REQUIRES_API_ANNOTATION.oldName(), GlobalSearchScope.allScope((Project)project)) == null && JavaPsiFacade.getInstance((Project)project).findClass(ApiDetector.REQUIRES_API_ANNOTATION.newName(), GlobalSearchScope.allScope((Project)project)) == null)) {
                list.add(new AddTargetApiQuickFix(api, true, startElement));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = list.toArray(AndroidLintQuickFix.EMPTY_ARRAY);
            if (androidLintQuickFixArray == null) {
                AndroidLintApiInspection.$$$reportNull$$$0(3);
            }
            return androidLintQuickFixArray;
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = super.getQuickFixes(startElement, endElement, message, fixData);
        if (androidLintQuickFixArray == null) {
            AndroidLintApiInspection.$$$reportNull$$$0(4);
        }
        return androidLintQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintApiInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintApiInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

