/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.support.AndroidxName;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.lint.checks.ExifInterfaceDetector;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintExifInterfaceInspection
extends AndroidLintInspectionBase {
    private static final AndroidxName NEW_EXIT_INTERFACE = AndroidxName.of((String)"android.support.media.", (String)"ExifInterface");

    public AndroidLintExifInterfaceInspection() {
        super(AndroidBundle.message("android.lint.inspections.exif.interface", new Object[0]), ExifInterfaceDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintExifInterfaceInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintExifInterfaceInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintExifInterfaceInspection.$$$reportNull$$$0(2);
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceExifFix()};
        if (androidLintQuickFixArray == null) {
            AndroidLintExifInterfaceInspection.$$$reportNull$$$0(3);
        }
        return androidLintQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintExifInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintExifInterfaceInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceExifFix
    extends DefaultLintQuickFix {
        public ReplaceExifFix() {
            super("Update all references in this file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            Module module;
            if (startElement == null) {
                ReplaceExifFix.$$$reportNull$$$0(0);
            }
            if (endElement == null) {
                ReplaceExifFix.$$$reportNull$$$0(1);
            }
            if (context == null) {
                ReplaceExifFix.$$$reportNull$$$0(2);
            }
            if ((module = AndroidPsiUtils.getModuleSafely(startElement)) != null) {
                LocalHistoryAction action2 = LocalHistory.getInstance().startAction(this.getName());
                final Project project = module.getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIT_INTERFACE.newName(), GlobalSearchScope.allScope((Project)project));
                if (cls == null) {
                    cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIT_INTERFACE.oldName(), GlobalSearchScope.allScope((Project)project));
                }
                if (cls != null) {
                    ReplaceExifFix.replaceReferences(this.getName(), startElement, cls, false);
                    return;
                }
                final String libraryCoordinate = ReplaceExifFix.getExifLibraryCoordinate();
                final boolean useAndroidx = libraryCoordinate != null && libraryCoordinate.startsWith(GoogleMavenArtifactId.ANDROIDX_EXIF_INTERFACE.getMavenGroupId());
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                try {
                    if (buildModel == null) {
                        ReplaceExifFix.replaceReferences(this.getName(), startElement, null, useAndroidx);
                    } else {
                        new WriteCommandAction(module.getProject(), this.getName(), new PsiFile[0]){

                            protected void run(@NotNull Result result2) {
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (libraryCoordinate != null) {
                                    ModuleRootModificationUtil.updateModel((Module)module, model -> {
                                        GradleBuildModel buildModel = GradleBuildModel.get(module);
                                        if (buildModel != null) {
                                            String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                                            buildModel.dependencies().addArtifact(name, libraryCoordinate);
                                            buildModel.applyChanges();
                                        }
                                    });
                                }
                                this.syncAndReplaceReferences(project, startElement, useAndroidx);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/lint/AndroidLintExifInterfaceInspection$ReplaceExifFix$1", "run"));
                            }
                        }.execute();
                    }
                }
                finally {
                    action2.finish();
                }
            }
        }

        private void syncAndReplaceReferences(final @NotNull Project project, final @NotNull PsiElement startElement, final boolean useAndroidx) {
            if (project == null) {
                ReplaceExifFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReplaceExifFix.$$$reportNull$$$0(4);
            }
            assert (ApplicationManager.getApplication().isDispatchThread());
            ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, false);
            Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

                public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                    if (syncResult != null && syncResult.isSuccessful()) {
                        DumbService.getInstance((Project)project).runWhenSmart(() -> {
                            if (startElement == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            ReplaceExifFix.replaceReferences(this.getName(), startElement, null, useAndroidx);
                        });
                    }
                }

                public void onFailure(@Nullable Throwable t) {
                    throw new RuntimeException(t);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintExifInterfaceInspection$ReplaceExifFix$2", "lambda$onSuccess$0"));
                }
            });
        }

        private static String getExifLibraryCoordinate() {
            GradleVersion version2;
            RepositoryUrlManager manager = RepositoryUrlManager.get();
            String libraryCoordinate = manager.getArtifactStringCoordinate(GoogleMavenArtifactId.ANDROIDX_EXIF_INTERFACE, true);
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = manager.getArtifactStringCoordinate(GoogleMavenArtifactId.EXIF_INTERFACE, true);
            if (libraryCoordinate == null) {
                return null;
            }
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)libraryCoordinate);
            if (coordinate != null && (version2 = GradleVersion.tryParse((String)coordinate.getRevision())) != null && !version2.isAtLeast(25, 1, 0)) {
                libraryCoordinate = coordinate.getGroupId() + ':' + coordinate.getArtifactId() + ":25.1.0";
            }
            return libraryCoordinate;
        }

        private static void replaceReferences(@NotNull String actionName, final @NotNull PsiElement element, final @Nullable PsiClass cls, final boolean useAndroidx) {
            if (actionName == null) {
                ReplaceExifFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                ReplaceExifFix.$$$reportNull$$$0(6);
            }
            new WriteCommandAction(element.getProject(), actionName, new PsiFile[0]){

                protected void run(@NotNull Result result2) {
                    if (result2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Project project = element.getProject();
                    final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    PsiFile file = element.getContainingFile();
                    file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                        public void visitReferenceElement(PsiJavaCodeReferenceElement expression) {
                            if ("ExifInterface".equals(expression.getReferenceName()) && expression.isQualified()) {
                                PsiElement context = expression.getParent();
                                if (expression instanceof PsiReferenceExpression) {
                                    if (cls != null) {
                                        PsiReferenceExpression replacement = factory.createReferenceExpression(cls);
                                        expression.replace((PsiElement)replacement);
                                        return;
                                    }
                                } else {
                                    expression.replace((PsiElement)factory.createReferenceFromText(useAndroidx ? NEW_EXIT_INTERFACE.newName() : NEW_EXIT_INTERFACE.oldName(), context));
                                    return;
                                }
                            }
                            super.visitReferenceElement(expression);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/lint/AndroidLintExifInterfaceInspection$ReplaceExifFix$3", "run"));
                }
            }.execute();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/AndroidLintExifInterfaceInspection$ReplaceExifFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncAndReplaceReferences";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceReferences";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

