/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.ArrayList;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintInvalidUsesTagAttributeInspection
extends AndroidLintInspectionBase {
    public AndroidLintInvalidUsesTagAttributeInspection() {
        super(AndroidBundle.message("android.lint.inspections.invalid.uses.tag.attribute", new Object[0]), AndroidAutoDetector.INVALID_USES_TAG_ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        XmlAttribute attribute;
        XmlAttributeValue attributeValue;
        if (startElement == null) {
            AndroidLintInvalidUsesTagAttributeInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintInvalidUsesTagAttributeInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintInvalidUsesTagAttributeInspection.$$$reportNull$$$0(2);
        }
        XmlAttributeValue xmlAttributeValue = attributeValue = (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class)) == null ? null : attribute.getValueElement();
        if (attributeValue != null && attributeValue.getTextLength() != 0) {
            String value = StringUtil.unquoteString((String)attributeValue.getText());
            String regexp = "(" + value + ")";
            String[] suggestions = AndroidAutoDetector.getAllowedAutomotiveAppTypes();
            ArrayList fixes = Lists.newArrayListWithExpectedSize((int)suggestions.length);
            for (String suggestion : suggestions) {
                fixes.add(new ReplaceStringQuickFix("Replace with \"" + suggestion + "\"", null, regexp, suggestion));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = fixes.toArray(AndroidLintQuickFix.EMPTY_ARRAY);
            if (androidLintQuickFixArray == null) {
                AndroidLintInvalidUsesTagAttributeInspection.$$$reportNull$$$0(3);
            }
            return androidLintQuickFixArray;
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = super.getQuickFixes(startElement, endElement, message, fixData);
        if (androidLintQuickFixArray == null) {
            AndroidLintInvalidUsesTagAttributeInspection.$$$reportNull$$$0(4);
        }
        return androidLintQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintInvalidUsesTagAttributeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintInvalidUsesTagAttributeInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

