/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintMissingSuperCallInspection
extends AndroidLintInspectionBase {
    public AndroidLintMissingSuperCallInspection() {
        super(AndroidBundle.message("android.lint.inspections.missing.super.call", new Object[0]), CallSuperDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        if (startElement == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(2);
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new DefaultLintQuickFix("Add super call", true){

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                if (startElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
                assert (method != null);
                Project project = startElement.getProject();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                PsiStatement superStatement = factory.createStatementFromText(this.buildSuperStatement(method), null);
                PsiCodeBlock body = method.getBody();
                if (body != null) {
                    PsiStatement[] statements = body.getStatements();
                    if (statements.length > 0) {
                        body.addBefore((PsiElement)superStatement, (PsiElement)statements[0]);
                    } else {
                        PsiWhiteSpace whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)method.getBody(), PsiWhiteSpace.class);
                        if (whiteSpace != null && whiteSpace.getText().startsWith("\n\n")) {
                            method.getBody().replace((PsiElement)factory.createCodeBlock());
                            body = method.getBody();
                        }
                        body.add((PsiElement)superStatement);
                    }
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)body);
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)body);
                }
            }

            @NotNull
            private String buildSuperStatement(PsiMethod method) {
                StringBuilder methodCallText = new StringBuilder("super.").append(method.getName()).append('(');
                PsiParameter[] parameters = method.getParameterList().getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    methodCallText.append(parameters[i].getName());
                    if (i + 1 == parameters.length) continue;
                    methodCallText.append(",");
                }
                methodCallText.append(");");
                String string = methodCallText.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                if (startElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (contextType == null) {
                    1.$$$reportNull$$$0(6);
                }
                PsiMethod type = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
                return startElement.getLanguage() == JavaLanguage.INSTANCE && type != null && !type.isConstructor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/lint/AndroidLintMissingSuperCallInspection$1";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contextType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/lint/AndroidLintMissingSuperCallInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildSuperStatement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "isApplicable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }};
        if (androidLintQuickFixArray == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(3);
        }
        return androidLintQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintMissingSuperCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintMissingSuperCallInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

