/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.refactoring.psi.SearchUtils;
import com.intellij.util.containers.SmartHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

class GenerateBackupDescriptorFix
implements AndroidLintQuickFix {
    private static final String XML_CONTENT_START = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<full-backup-content>\n";
    private static final String XML_CONTENT_END = "</full-backup-content>\n";
    private final ResourceUrl myUrl;

    public GenerateBackupDescriptorFix(@NotNull ResourceUrl url) {
        if (url == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(0);
        }
        this.myUrl = url;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(1);
        }
        if (endElement == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(3);
        }
        Project project = startElement.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(startElement);
        if (facet == null) {
            return;
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        GlobalSearchScope useScope = GlobalSearchScope.projectScope((Project)project);
        PsiClassType stringType = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)allScope);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiOpenHelperClass = javaPsiFacade.findClass("android.database.sqlite.SQLiteOpenHelper", allScope);
        assert (psiOpenHelperClass != null);
        PsiClass psiContext = javaPsiFacade.findClass("android.content.Context", allScope);
        assert (psiContext != null);
        Set<String> databaseNames = GenerateBackupDescriptorFix.findDatabasesInProject(useScope, psiOpenHelperClass, stringType, javaPsiFacade);
        Set<String> sharedPreferenceFiles = GenerateBackupDescriptorFix.findSharedPrefsInProject(useScope, psiContext, facet, stringType, javaPsiFacade);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Create Backup Descriptor", null, () -> {
            try {
                VirtualFile primaryResourceDir = ResourceFolderManager.getInstance(facet).getPrimaryFolder();
                assert (primaryResourceDir != null);
                VirtualFile xmlDir = AndroidUtils.createChildDirectoryIfNotExist(project, primaryResourceDir, "xml");
                VirtualFile resFile = xmlDir.createChildData((Object)project, this.myUrl.name + ".xml");
                VfsUtil.saveText((VirtualFile)resFile, (String)GenerateBackupDescriptorFix.generateBackupDescriptorContents(databaseNames, sharedPreferenceFiles));
                TemplateUtils.reformatAndRearrange(project, resFile);
                TemplateUtils.openEditor(project, resFile);
                TemplateUtils.selectEditor(project, resFile);
            }
            catch (IOException e) {
                String error = String.format("Failed to create file: %1$s", e.getMessage());
                Messages.showErrorDialog((Project)project, (String)error, (String)"Create Backup Resource");
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        AndroidFacet facet;
        if (startElement == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(5);
        }
        if (contextType == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(6);
        }
        LocalResourceRepository appResources = (facet = AndroidFacet.getInstance(startElement)) == null ? null : ResourceRepositoryManager.getAppResources(facet);
        return appResources == null || !appResources.getItemsOfType(ResourceType.XML).contains(this.myUrl.name);
    }

    @Override
    @NotNull
    public String getName() {
        if ("Generate full-backup-content descriptor" == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(7);
        }
        return "Generate full-backup-content descriptor";
    }

    private static Set<String> findSharedPrefsInProject(GlobalSearchScope useScope, PsiClass psiContext, final @NotNull AndroidFacet facet, @NotNull PsiClassType stringType, @NotNull JavaPsiFacade psiFacade) {
        if (facet == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(8);
        }
        if (stringType == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(9);
        }
        if (psiFacade == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(10);
        }
        SmartHashSet prefFiles = new SmartHashSet();
        PsiMethod[] methods = psiContext.findMethodsByName("getSharedPreferences", true);
        ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>(Arrays.asList(methods));
        for (PsiMethod method : methods) {
            allMethods.addAll(Lists.newArrayList((Iterable)SearchUtils.findOverridingMethods((PsiMethod)method)));
        }
        for (PsiMethod method : allMethods) {
            Iterable references = SearchUtils.findAllReferences((PsiElement)method, (SearchScope)useScope);
            for (PsiReference ref : references) {
                ref.getElement().getParent().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)prefFiles, method, stringType, psiFacade){
                    final /* synthetic */ Set val$prefFiles;
                    final /* synthetic */ PsiMethod val$method;
                    final /* synthetic */ PsiClassType val$stringType;
                    final /* synthetic */ JavaPsiFacade val$psiFacade;
                    {
                        this.val$prefFiles = set;
                        this.val$method = psiMethod;
                        this.val$stringType = psiClassType;
                        this.val$psiFacade = javaPsiFacade;
                    }

                    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                        PsiExpression[] expressions;
                        String methodName;
                        PsiMethod psiMethod = expression.resolveMethod();
                        String string = methodName = psiMethod == null ? null : psiMethod.getName();
                        if ("getString".equals(methodName)) {
                            PsiExpression[] expressions2 = expression.getArgumentList().getExpressions();
                            if (expressions2.length == 1 && PsiType.INT.equals((Object)expressions2[0].getType())) {
                                ResourceUrl resource = ResourceEvaluator.getResource((JavaEvaluator)new DefaultJavaEvaluator(expression.getProject(), null), (PsiElement)expressions2[0]);
                                if (resource == null || resource.isFramework() || resource.type != ResourceType.STRING) {
                                    return;
                                }
                                List<PsiElement> resources = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().findResourcesByFieldName(ResourceNamespace.TODO(), ResourceType.STRING.getName(), resource.name);
                                for (PsiElement resElement : resources) {
                                    if (!(resElement instanceof XmlAttributeValue)) continue;
                                    XmlTagValue value = ((XmlTagImpl)resElement.getParent().getParent()).getValue();
                                    this.val$prefFiles.add(value.getText());
                                    break;
                                }
                            }
                        } else if (this.val$method.getName().equals(methodName) && (expressions = expression.getArgumentList().getExpressions()).length == 2 && this.val$stringType.equals((Object)expressions[0].getType())) {
                            Object result2 = this.val$psiFacade.getConstantEvaluationHelper().computeConstantExpression((PsiElement)expressions[0]);
                            if (result2 != null) {
                                this.val$prefFiles.add((String)result2);
                            } else {
                                super.visitMethodCallExpression(expression);
                            }
                        }
                    }
                });
            }
        }
        return prefFiles;
    }

    @NotNull
    private static Set<String> findDatabasesInProject(GlobalSearchScope useScope, final PsiClass psiClass, final PsiClassType stringType, final JavaPsiFacade psiFacade) {
        PsiMethod[] constructors = psiClass.getConstructors();
        SmartHashSet databaseNames = new SmartHashSet();
        for (PsiMethod method : constructors) {
            Iterable references = SearchUtils.findAllReferences((PsiElement)method, (SearchScope)useScope);
            for (PsiReference ref : references) {
                PsiElement element = ref.getElement();
                element.getParent().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)databaseNames){
                    final /* synthetic */ Set val$databaseNames;
                    {
                        this.val$databaseNames = set;
                    }

                    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                        PsiExpression[] expressions;
                        PsiMethod method = expression.resolveMethod();
                        if (method != null && method.getContainingClass() != null && method.getContainingClass().isEquivalentTo((PsiElement)psiClass) && (expressions = expression.getArgumentList().getExpressions()).length > 2 && stringType.equals((Object)expressions[1].getType())) {
                            PsiExpression expressionToEvaluate = expressions[1];
                            Object result2 = psiFacade.getConstantEvaluationHelper().computeConstantExpression((PsiElement)expressionToEvaluate);
                            if (result2 != null) {
                                this.val$databaseNames.add((String)result2);
                            }
                        }
                        super.visitMethodCallExpression(expression);
                    }
                });
            }
        }
        SmartHashSet smartHashSet = databaseNames;
        if (smartHashSet == null) {
            GenerateBackupDescriptorFix.$$$reportNull$$$0(11);
        }
        return smartHashSet;
    }

    private static String generateBackupDescriptorContents(Set<String> databaseNames, Set<String> sharedPrefs) {
        StringBuilder sb = new StringBuilder();
        sb.append(XML_CONTENT_START);
        if (!databaseNames.isEmpty() || !sharedPrefs.isEmpty()) {
            sb.append("<!-- TODO Remove the following \"exclude\" elements to make them a part of the auto backup -->\n");
        }
        for (String name : databaseNames) {
            sb.append(String.format("<exclude domain=\"database\" path=\"%1$s\"/>\n", name));
        }
        if (!sharedPrefs.isEmpty()) {
            sb.append("<!-- Exclude the shared preferences file that contains the GCM registrationId -->\n");
        } else {
            sb.append("<!-- Exclude specific shared preferences that contain GCM registration Id -->\n");
        }
        for (String name : sharedPrefs) {
            sb.append(String.format("<exclude domain=\"sharedpref\" path=\"%1$s.xml\" />\n", name));
        }
        sb.append(XML_CONTENT_END);
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/GenerateBackupDescriptorFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/GenerateBackupDescriptorFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findDatabasesInProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSharedPrefsInProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

