/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.LintIdeViewTypeDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.ManifestTypoDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class LintIdeIssueRegistry
extends BuiltinIssueRegistry {
    private static List<Issue> ourFilteredIssues;

    public List<Issue> getIssues() {
        if (ourFilteredIssues == null) {
            List sIssues = super.getIssues();
            ArrayList<Issue> result2 = new ArrayList<Issue>(sIssues.size());
            for (Issue issue2 : sIssues) {
                Implementation implementation = issue2.getImplementation();
                Class detectorClass = implementation.getDetectorClass();
                if (detectorClass == ViewTypeDetector.class) {
                    issue2.setImplementation(LintIdeViewTypeDetector.IMPLEMENTATION);
                } else if (!LintIdeIssueRegistry.isRelevant(issue2)) continue;
                result2.add(issue2);
            }
            ourFilteredIssues = result2;
        }
        return ourFilteredIssues;
    }

    public static boolean isRelevant(Issue issue2) {
        Implementation implementation = issue2.getImplementation();
        EnumSet scope = implementation.getScope();
        Class detectorClass = implementation.getDetectorClass();
        if (scope.contains(Scope.CLASS_FILE) || scope.contains(Scope.ALL_CLASS_FILES) || scope.contains(Scope.JAVA_LIBRARIES)) {
            if (detectorClass == ApiDetector.class) {
                return true;
            }
            for (EnumSet analysisScope : implementation.getAnalysisScopes()) {
                if (analysisScope.contains(Scope.CLASS_FILE) || analysisScope.contains(Scope.ALL_CLASS_FILES) || analysisScope.contains(Scope.JAVA_LIBRARIES)) continue;
                return true;
            }
            return false;
        }
        return issue2 != NamespaceDetector.UNUSED && issue2 != ManifestTypoDetector.ISSUE && issue2 != ManifestDetector.WRONG_PARENT;
    }
}

