/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"computeKotlinArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "intellij.android.core"})
public final class LintKotlinReflectionUtilsKt {
    @Nullable
    public static final Map<UExpression, PsiParameter> computeKotlinArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) throws Throwable {
        Map parameter;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiElement psiElement = call.getPsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement receiver = psiElement;
        if (Intrinsics.areEqual((Object)receiver.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
            return null;
        }
        Language language = receiver.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"receiver.language");
        if (Intrinsics.areEqual((Object)language.getID(), (Object)"kotlin") ^ true) {
            return null;
        }
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        if (psiParameterList.getParametersCount() < 2) {
            return null;
        }
        ClassLoader loader = receiver.getClass().getClassLoader();
        Object object = ServiceManager.getService((Project)receiver.getProject(), Class.forName("org.jetbrains.uast.kotlin.KotlinUastResolveProviderService", true, loader));
        if (object == null) {
            return null;
        }
        Object service = object;
        Class<?> ktElementClass = Class.forName("org.jetbrains.kotlin.psi.KtElement", true, loader);
        Class<?> bindingContextClass = Class.forName("org.jetbrains.kotlin.resolve.BindingContext", true, loader);
        Class<?> callUtilClass = Class.forName("org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt", true, loader);
        Object bindingContext = service.getClass().getMethod("getBindingContext", ktElementClass).invoke(service, receiver);
        PsiParameterList psiParameterList2 = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList2, (String)"method.parameterList");
        PsiParameter[] parameters = psiParameterList2.getParameters();
        Method method2 = callUtilClass.getDeclaredMethod("getResolvedCall", ktElementClass, bindingContextClass);
        if (method2 == null) {
            return null;
        }
        Method resolvedCallMethod = method2;
        Object object2 = resolvedCallMethod.invoke(null, receiver, bindingContext);
        if (object2 == null) {
            return null;
        }
        Object resolvedCall = object2;
        Method valueArgumentsMethod = resolvedCall.getClass().getDeclaredMethod("getValueArguments", new Class[0]);
        Object object3 = valueArgumentsMethod.invoke(resolvedCall, new Object[0]);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        }
        Map valueArguments = (Map)object3;
        Map elementMap = new LinkedHashMap();
        Object[] objectArray = call.getValueArguments().iterator();
        while (objectArray.hasNext()) {
            parameter = (UExpression)objectArray.next();
            PsiElement psiElement2 = parameter.getPsi();
            if (psiElement2 == null) {
                continue;
            }
            elementMap.put(psiElement2, parameter);
        }
        parameter = valueArguments;
        if (!parameter.isEmpty()) {
            int firstParameterIndex = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"parameters");
            Object[] objectArray2 = objectArray = (Object[])parameters;
            if (!(objectArray2.length == 0)) {
                PsiParameter psiParameter = parameters[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[0]");
                if (Intrinsics.areEqual((Object)"$receiver", (Object)psiParameter.getName())) {
                    ++firstParameterIndex;
                }
            }
            Class<?> valueParameterDescriptorClass = Class.forName("org.jetbrains.kotlin.descriptors.ValueParameterDescriptor", true, loader);
            Method getIndexMethod = valueParameterDescriptorClass.getDeclaredMethod("getIndex", new Class[0]);
            Class<?> valueArgumentClass = Class.forName("org.jetbrains.kotlin.psi.ValueArgument", true, loader);
            Method getArgumentExpressionMethod = valueArgumentClass.getDeclaredMethod("getArgumentExpression", new Class[0]);
            Class<?> resolvedValueArgumentClass = Class.forName("org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument", true, loader);
            Method getArgumentsMethod = resolvedValueArgumentClass.getDeclaredMethod("getArguments", new Class[0]);
            HashMap<UExpression, PsiParameter> mapping = new HashMap<UExpression, PsiParameter>();
            Map map2 = valueArguments;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Object parameterDescriptor = entry2.getKey();
                entry2 = entry;
                Object valueArgument = entry2.getValue();
                Object object4 = getArgumentsMethod.invoke(valueArgument, new Object[0]);
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                }
                List arguments = (List)object4;
                for (Object argument : arguments) {
                    UExpression arg;
                    Object expression;
                    if (getArgumentExpressionMethod.invoke(argument, new Object[0]) == null) {
                        continue;
                    }
                    Map map3 = elementMap;
                    if ((UExpression)map3.get(expression) == null) {
                        continue;
                    }
                    Object object5 = getIndexMethod.invoke(parameterDescriptor, new Object[0]);
                    if (object5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    int index = firstParameterIndex + (Integer)object5;
                    if (index >= ((Object[])parameters).length) continue;
                    mapping.put(arg, parameters[index]);
                }
            }
            if (!mapping.isEmpty()) {
                return mapping;
            }
        }
        return null;
    }
}

