/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.psi.SearchUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

class MigrateDrawableToMipmapFix
implements AndroidLintQuickFix {
    private final ResourceUrl myUrl;

    MigrateDrawableToMipmapFix(@NotNull ResourceUrl url) {
        if (url == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(0);
        }
        this.myUrl = url;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiField[] resourceFields;
        if (startElement == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(1);
        }
        if (endElement == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(3);
        }
        Project project = startElement.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(startElement);
        if (facet == null) {
            return;
        }
        final ArrayList bitmaps = Lists.newArrayList();
        final HashSet references = Sets.newHashSet();
        GlobalSearchScope useScope = GlobalSearchScope.projectScope((Project)project);
        LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(facet);
        List resourceItems = projectResources.getResourceItem(this.myUrl.type, this.myUrl.name);
        if (resourceItems != null) {
            for (ResourceItem item : resourceItems) {
                PsiFile file = LocalResourceRepository.getItemPsiFile(project, item);
                if (file == null) continue;
                bitmaps.add(file);
                Iterable allReferences = SearchUtils.findAllReferences((PsiElement)file, (SearchScope)useScope);
                for (PsiReference next : allReferences) {
                    PsiElement element = next.getElement();
                    if (element == null) continue;
                    references.add(element);
                }
            }
        }
        if ((resourceFields = AndroidResourceUtil.findResourceFields(facet, ResourceType.DRAWABLE.getName(), this.myUrl.name, true)).length == 1) {
            Iterable allReferences = SearchUtils.findAllReferences((PsiElement)resourceFields[0], (SearchScope)useScope);
            for (PsiReference next : allReferences) {
                PsiElement element = next.getElement();
                if (element == null) continue;
                references.add(element);
            }
        }
        HashSet applicableFiles = Sets.newHashSet();
        applicableFiles.addAll(bitmaps);
        for (PsiElement element : references) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            applicableFiles.add(containingFile);
        }
        WriteCommandAction<Void> action2 = new WriteCommandAction<Void>(project, "Migrate Drawable to Bitmap", applicableFiles.toArray(PsiFile.EMPTY_ARRAY)){

            protected void run(@NotNull Result<Void> result2) throws Throwable {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiFile bitmap : bitmaps) {
                    FolderConfiguration configuration;
                    VirtualFile parent;
                    VirtualFile file = bitmap.getVirtualFile();
                    if (file == null || (parent = file.getParent()) == null) continue;
                    if (file.getFileType() == StdFileTypes.XML && parent.getName().startsWith("values")) {
                        XmlFile xmlFile = (XmlFile)bitmap;
                        XmlTag root = xmlFile.getRootTag();
                        if (root == null) continue;
                        for (XmlTag item : root.getSubTags()) {
                            String name = item.getAttributeValue("name");
                            if (!((MigrateDrawableToMipmapFix)MigrateDrawableToMipmapFix.this).myUrl.name.equals(name)) continue;
                            if (ResourceType.DRAWABLE.getName().equals(item.getName())) {
                                item.setName(ResourceType.MIPMAP.getName());
                                continue;
                            }
                            if (!ResourceType.DRAWABLE.getName().equals(item.getAttributeValue("type"))) continue;
                            item.setAttribute("type", ResourceType.MIPMAP.getName());
                        }
                        continue;
                    }
                    VirtualFile res = parent.getParent();
                    if (res == null || (configuration = FolderConfiguration.getConfigForFolder((String)parent.getName())) == null) continue;
                    String targetFolderName = configuration.getFolderName(ResourceFolderType.MIPMAP);
                    VirtualFile targetFolder = res.findChild(targetFolderName);
                    if (targetFolder == null) {
                        targetFolder = res.createChildDirectory((Object)this, targetFolderName);
                    }
                    file.move((Object)this, targetFolder);
                }
                for (PsiElement reference2 : references) {
                    PsiReferenceExpression outer;
                    PsiReferenceExpression inner;
                    PsiExpression qualifier;
                    if (reference2 instanceof XmlAttributeValue) {
                        XmlAttributeValue value = (XmlAttributeValue)reference2;
                        XmlAttribute attribute = (XmlAttribute)value.getParent();
                        attribute.setValue(ResourceUrl.create((ResourceType)ResourceType.MIPMAP, (String)((MigrateDrawableToMipmapFix)MigrateDrawableToMipmapFix.this).myUrl.name, (boolean)false).toString());
                        continue;
                    }
                    if (!(reference2 instanceof PsiReferenceExpression) || !((qualifier = (inner = (PsiReferenceExpression)reference2).getQualifierExpression()) instanceof PsiReferenceExpression) || !((outer = (PsiReferenceExpression)qualifier).getReferenceNameElement() instanceof PsiIdentifier)) continue;
                    PsiIdentifier identifier = (PsiIdentifier)outer.getReferenceNameElement();
                    if (!ResourceType.DRAWABLE.getName().equals(identifier.getText())) continue;
                    Project project = reference2.getProject();
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                    PsiIdentifier newIdentifier = elementFactory.createIdentifier(ResourceType.MIPMAP.getName());
                    identifier.replace((PsiElement)newIdentifier);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/lint/MigrateDrawableToMipmapFix$1", "run"));
            }
        };
        action2.execute();
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(5);
        }
        if (contextType == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "Convert " + this.myUrl + " to @mipmap/" + this.myUrl.name;
        if (string == null) {
            MigrateDrawableToMipmapFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/MigrateDrawableToMipmapFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/MigrateDrawableToMipmapFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

