/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.lint.LintIdeAnalytics;
import com.google.wireless.android.sdk.stats.LintAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProvideLintFeedbackPanel
extends DialogWrapper
implements ActionListener,
ChangeListener {
    private static final String REQUEST_FEEDBACK = "request-lint-feedback";
    private static Boolean requestFeedback = null;
    private final Project myProject;
    private final String myIssue;
    private JButton myFalsePositiveButton;
    private JButton myGreatButton;
    private JButton myUnclearMessageButton;
    private JButton myOtherButton;
    private JPanel myPanel;
    private JBCheckBox myFeedbackCheckBox;

    public ProvideLintFeedbackPanel(@Nullable Project project, @NotNull String issue2) {
        if (issue2 == null) {
            ProvideLintFeedbackPanel.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.myIssue = issue2;
        this.$$$setupUI$$$();
        this.setTitle("Provide Feedback");
        this.init();
        this.myGreatButton.addActionListener(this);
        this.myFalsePositiveButton.addActionListener(this);
        this.myUnclearMessageButton.addActionListener(this);
        this.myOtherButton.addActionListener(this);
        this.myFeedbackCheckBox.addChangeListener((ChangeListener)this);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        if (actionArray == null) {
            ProvideLintFeedbackPanel.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @Nullable
    protected JPanel createCenterPanel() {
        return this.myPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LintAction.LintFeedback feedback;
        Object source = e.getSource();
        if (source == this.myGreatButton) {
            feedback = LintAction.LintFeedback.LOVE_IT;
        } else if (source == this.myFalsePositiveButton) {
            feedback = LintAction.LintFeedback.FALSE_POSITIVE;
        } else if (source == this.myUnclearMessageButton) {
            feedback = LintAction.LintFeedback.UNCLEAR_MESSAGE;
        } else if (source == this.myOtherButton) {
            feedback = LintAction.LintFeedback.UNKNOWN_FEEDBACK;
        } else {
            assert (false) : source;
            return;
        }
        LintIdeAnalytics analytics = new LintIdeAnalytics(this.myProject);
        analytics.logFeedback(this.myIssue, feedback);
        this.close(1);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean selected;
        if (e.getSource() == this.myFeedbackCheckBox && (selected = this.myFeedbackCheckBox.isSelected()) != ProvideLintFeedbackPanel.canRequestFeedback()) {
            ProvideLintFeedbackPanel.setRequestFeedback(selected);
        }
    }

    public static boolean canRequestFeedback() {
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return false;
        }
        if (requestFeedback == null) {
            requestFeedback = PropertiesComponent.getInstance().getBoolean(REQUEST_FEEDBACK, true);
        }
        return requestFeedback;
    }

    private static void setRequestFeedback(boolean request) {
        requestFeedback = request;
        PropertiesComponent.getInstance().setValue(REQUEST_FEEDBACK, request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/ProvideLintFeedbackPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/ProvideLintFeedbackPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Provide feedback on this issue reported by Android Lint:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myFalsePositiveButton = jButton4 = new JButton();
        jButton4.setText("False Positive");
        jPanel.add((Component)jButton4, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Lint incorrectly diagnosed this problem; it's not a real issue.");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myGreatButton = jButton3 = new JButton();
        jButton3.setText("Great!");
        jPanel.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Lint found a real issue.");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myUnclearMessageButton = jButton2 = new JButton();
        jButton2.setText("Unclear Message");
        jPanel.add((Component)jButton2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("The error message and/or full explanation is not clear; I'm not sure what to do.");
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 1, 1, 1, 0, 0, 1, 0, null, null, null));
        this.myOtherButton = jButton = new JButton();
        jButton.setText("Other");
        jPanel.add((Component)jButton, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("There is some other problem with this lint result.");
        jPanel.add((Component)jBLabel5, new GridConstraints(4, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myFeedbackCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Continue to ask for feedback on lint checks");
        jPanel.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, new Dimension(-1, 12), new Dimension(-1, 12), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

