/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.ConfigureLogcatHeaderDialog;
import com.android.tools.idea.logcat.DefaultAndroidLogcatFilter;
import com.android.tools.idea.logcat.EditLogFilterDialog;
import com.android.tools.idea.logcat.FormattedLogcatReceiver;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatView
implements Disposable {
    public static final Key<AndroidLogcatView> ANDROID_LOGCAT_VIEW_KEY = Key.create((String)"ANDROID_LOGCAT_VIEW_KEY");
    static final AndroidLogcatFilter NO_FILTERS_ITEM = new AndroidLogcatFilter(){

        @Override
        @NotNull
        public String getName() {
            String string = NO_FILTERS;
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isApplicable(@NotNull String message, @NotNull String tag, @NotNull String p, int processId, @NotNull Log.LogLevel priority) {
            if (message == null) {
                1.$$$reportNull$$$0(1);
            }
            if (tag == null) {
                1.$$$reportNull$$$0(2);
            }
            if (p == null) {
                1.$$$reportNull$$$0(3);
            }
            if (priority == null) {
                1.$$$reportNull$$$0(4);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatView$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    static final AndroidLogcatFilter EDIT_FILTER_CONFIGURATION_ITEM = new AndroidLogcatFilter(){

        @Override
        @NotNull
        public String getName() {
            String string = EDIT_FILTER_CONFIGURATION;
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isApplicable(@NotNull String message, @NotNull String tag, @NotNull String p, int pid, @NotNull Log.LogLevel logLevel) {
            if (message == null) {
                2.$$$reportNull$$$0(1);
            }
            if (tag == null) {
                2.$$$reportNull$$$0(2);
            }
            if (p == null) {
                2.$$$reportNull$$$0(3);
            }
            if (logLevel == null) {
                2.$$$reportNull$$$0(4);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatView$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    static final String SELECTED_APP_FILTER = AndroidBundle.message("android.logcat.filters.selected", new Object[0]);
    static final String NO_FILTERS = AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    static final String EDIT_FILTER_CONFIGURATION = AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    private final Project myProject;
    private final FormattedLogcatReceiver myLogcatReceiver;
    private final AndroidLogConsole myLogConsole;
    private final DeviceContext myDeviceContext;
    private final AndroidLogFilterModel myLogFilterModel;
    private volatile IDevice myDevice;
    private DefaultComboBoxModel<AndroidLogcatFilter> myFilterComboBoxModel;
    private JPanel myPanel;

    private void notifyDeviceUpdated(boolean forceReconnect) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (forceReconnect) {
                if (this.myDevice != null) {
                    AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
                }
                this.myDevice = null;
            }
            this.updateLogConsole();
        });
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AndroidLogcatView.$$$reportNull$$$0(0);
        }
        return project;
    }

    @NotNull
    public final AndroidLogConsole getLogConsole() {
        AndroidLogConsole androidLogConsole = this.myLogConsole;
        if (androidLogConsole == null) {
            AndroidLogcatView.$$$reportNull$$$0(1);
        }
        return androidLogConsole;
    }

    @NotNull
    DeviceContext getDeviceContext() {
        DeviceContext deviceContext = this.myDeviceContext;
        if (deviceContext == null) {
            AndroidLogcatView.$$$reportNull$$$0(2);
        }
        return deviceContext;
    }

    @NotNull
    ListModel<AndroidLogcatFilter> getEditFiltersComboBoxModel() {
        DefaultComboBoxModel<AndroidLogcatFilter> defaultComboBoxModel = this.myFilterComboBoxModel;
        if (defaultComboBoxModel == null) {
            AndroidLogcatView.$$$reportNull$$$0(3);
        }
        return defaultComboBoxModel;
    }

    AndroidLogcatView(final @NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            AndroidLogcatView.$$$reportNull$$$0(4);
        }
        if (deviceContext == null) {
            AndroidLogcatView.$$$reportNull$$$0(5);
        }
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        AndroidLogcatFormatter formatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), AndroidLogcatPreferences.getInstance(project));
        this.myLogFilterModel = new AndroidLogFilterModel(formatter){

            @NotNull
            private AndroidLogcatPreferences getPreferences() {
                AndroidLogcatPreferences androidLogcatPreferences = AndroidLogcatPreferences.getInstance(project);
                if (androidLogcatPreferences == null) {
                    3.$$$reportNull$$$0(0);
                }
                return androidLogcatPreferences;
            }

            @Override
            protected void saveLogLevel(String logLevelName) {
                this.getPreferences().TOOL_WINDOW_LOG_LEVEL = logLevelName;
            }

            @Override
            public String getSelectedLogLevelName() {
                return this.getPreferences().TOOL_WINDOW_LOG_LEVEL;
            }

            @Override
            protected void saveConfiguredFilterName(String filterName) {
                this.getPreferences().TOOL_WINDOW_CONFIGURED_FILTER = filterName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView$3", "getPreferences"));
            }
        };
        this.myLogConsole = new AndroidLogConsole(project, this.myLogFilterModel, (LogFormatter)formatter, this);
        this.myLogcatReceiver = new MyLogcatListener(formatter, this.myLogConsole, this.myLogFilterModel);
        DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

            @Override
            public void deviceSelected(@Nullable IDevice device) {
                AndroidLogcatView.this.notifyDeviceUpdated(false);
            }

            @Override
            public void deviceChanged(@NotNull IDevice device, int changeMask) {
                if (device == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (device == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                    AndroidLogcatView.this.notifyDeviceUpdated(true);
                }
            }

            @Override
            public void clientSelected(@Nullable Client c) {
                if (AndroidLogcatView.this.myFilterComboBoxModel == null) {
                    return;
                }
                AndroidLogcatFilter selected = (AndroidLogcatFilter)AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem();
                AndroidLogcatView.this.updateDefaultFilters(c != null ? c.getClientData() : null);
                if (selected != null && AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem() != selected) {
                    AndroidLogcatView.this.selectFilterByName(selected.getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatView$4", "deviceChanged"));
            }
        };
        deviceContext.addListener(deviceSelectionListener, this);
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("AndroidLogcatView", this.myLogConsole.getOrCreateActions(), false);
            toolbar.setTargetComponent(console.getComponent());
            JComponent tbComp1 = toolbar.getComponent();
            this.myPanel.add((Component)tbComp1, "West");
        }
        this.myPanel.add((Component)consoleComponent, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myLogConsole);
        this.updateLogConsole();
    }

    @NotNull
    public final JPanel createSearchComponent() {
        JPanel panel = new JPanel();
        panel.add(this.createEditFiltersComboBox());
        JPanel searchComponent = new JPanel();
        searchComponent.setLayout(new BoxLayout(searchComponent, 0));
        searchComponent.add(this.myLogConsole.getSearchComponent());
        searchComponent.add(panel);
        JPanel jPanel = searchComponent;
        if (jPanel == null) {
            AndroidLogcatView.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public Component createEditFiltersComboBox() {
        ComboBox editFiltersCombo = new ComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        this.myFilterComboBoxModel.addElement(NO_FILTERS_ITEM);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION_ITEM);
        this.updateDefaultFilters(null);
        this.updateUserFilters();
        String selectName = AndroidLogcatPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        if (StringUtil.isEmpty((String)selectName)) {
            selectName = this.myDeviceContext != null ? SELECTED_APP_FILTER : NO_FILTERS;
        }
        this.selectFilterByName(selectName);
        editFiltersCombo.setModel(this.myFilterComboBoxModel);
        this.applySelectedFilter();
        editFiltersCombo.addItemListener(new ItemListener((JComboBox)editFiltersCombo){
            @Nullable
            private AndroidLogcatFilter myLastSelected;
            final /* synthetic */ JComboBox val$editFiltersCombo;
            {
                this.val$editFiltersCombo = jComboBox;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 2) {
                    if (item instanceof AndroidLogcatFilter) {
                        this.myLastSelected = (AndroidLogcatFilter)item;
                    }
                } else if (e.getStateChange() == 1) {
                    if (item.equals(EDIT_FILTER_CONFIGURATION_ITEM)) {
                        EditLogFilterDialog dialog = new EditLogFilterDialog(AndroidLogcatView.this, this.myLastSelected == null ? null : this.myLastSelected.getName());
                        dialog.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                        if (dialog.showAndGet()) {
                            PersistentAndroidLogFilters.FilterData filterData = dialog.getActiveFilter();
                            AndroidLogcatView.this.updateUserFilters();
                            if (filterData != null) {
                                AndroidLogcatView.this.selectFilterByName(filterData.getName());
                            }
                        } else {
                            this.val$editFiltersCombo.setSelectedItem(this.myLastSelected);
                        }
                    } else {
                        AndroidLogcatView.this.applySelectedFilter();
                    }
                }
            }
        });
        editFiltersCombo.setRenderer(new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (value instanceof AndroidLogcatFilter) {
                    this.setBorder(null);
                    this.append(((AndroidLogcatFilter)value).getName());
                } else {
                    this.setBorder(IdeBorderFactory.createBorder((int)8));
                    this.append(value.toString());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/logcat/AndroidLogcatView$6", "customizeCellRenderer"));
            }
        });
        ComboBox comboBox = editFiltersCombo;
        if (comboBox == null) {
            AndroidLogcatView.$$$reportNull$$$0(7);
        }
        return comboBox;
    }

    boolean isActive() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Logcat").isVisible();
    }

    public final void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    private void updateLogConsole() {
        IDevice device = this.getSelectedDevice();
        if (this.myDevice != device) {
            AndroidLogcatService androidLogcatService = AndroidLogcatService.getInstance();
            if (this.myDevice != null) {
                androidLogcatService.removeListener(this.myDevice, this.myLogcatReceiver);
            }
            if (this.myLogConsole.getConsole() != null) {
                this.myLogConsole.clear();
            }
            this.myDevice = device;
            this.myLogFilterModel.processingStarted();
            androidLogcatService.addListener(this.myDevice, this.myLogcatReceiver, true);
        }
    }

    @Nullable
    IDevice getSelectedDevice() {
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    private void applySelectedFilter() {
        final Object filter2 = this.myFilterComboBoxModel.getSelectedItem();
        if (filter2 instanceof AndroidLogcatFilter) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying Filter..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    AndroidLogcatView.this.myLogFilterModel.updateLogcatFilter((AndroidLogcatFilter)filter2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/logcat/AndroidLogcatView$7", "run"));
                }
            });
        }
    }

    void updateDefaultFilters(@Nullable ClientData client) {
        int noFilterIndex = this.myFilterComboBoxModel.getIndexOf(NO_FILTERS_ITEM);
        for (int i = 0; i < noFilterIndex; ++i) {
            this.myFilterComboBoxModel.removeElementAt(0);
        }
        int insertIndex = 0;
        if (client != null) {
            DefaultAndroidLogcatFilter filter2 = new DefaultAndroidLogcatFilter.Builder(SELECTED_APP_FILTER).setPid(client.getPid()).build();
            this.myFilterComboBoxModel.insertElementAt(filter2, insertIndex++);
        }
        for (LogcatFilterProvider filterProvider : (LogcatFilterProvider[])LogcatFilterProvider.EP_NAME.getExtensions()) {
            AndroidLogcatFilter filter3 = filterProvider.getFilter(client);
            this.myFilterComboBoxModel.insertElementAt(filter3, insertIndex++);
        }
    }

    private void updateUserFilters() {
        int editFilterConfigurationItemIndex = this.myFilterComboBoxModel.getIndexOf(EDIT_FILTER_CONFIGURATION_ITEM);
        assert (editFilterConfigurationItemIndex != -1);
        int userFiltersStartIndex = editFilterConfigurationItemIndex + 1;
        while (this.myFilterComboBoxModel.getSize() > userFiltersStartIndex) {
            this.myFilterComboBoxModel.removeElementAt(userFiltersStartIndex);
        }
        List<PersistentAndroidLogFilters.FilterData> filters = PersistentAndroidLogFilters.getInstance(this.myProject).getFilters();
        for (PersistentAndroidLogFilters.FilterData filter2 : filters) {
            String name = filter2.getName();
            assert (name != null);
            DefaultAndroidLogcatFilter compiled = DefaultAndroidLogcatFilter.compile(filter2, name);
            this.myFilterComboBoxModel.addElement(compiled);
        }
    }

    private void selectFilterByName(String name) {
        Optional<AndroidLogcatFilter> optionalFilter = IntStream.range(0, this.myFilterComboBoxModel.getSize()).mapToObj(i -> this.myFilterComboBoxModel.getElementAt(i)).filter(filter2 -> filter2.getName().equals(name)).findFirst();
        optionalFilter.ifPresent(filter2 -> this.myFilterComboBoxModel.setSelectedItem(filter2));
    }

    @NotNull
    public final JPanel getContentPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AndroidLogcatView.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public final void dispose() {
        if (this.myDevice != null) {
            AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogConsole";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditFiltersComboBoxModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditFiltersComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static final class MyConfigureLogcatHeaderAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyConfigureLogcatHeaderAction(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyConfigureLogcatHeaderAction.$$$reportNull$$$0(0);
            }
            super(AndroidBundle.message("android.configure.logcat.header.text", new Object[0]), AndroidBundle.message("android.configure.logcat.header.description", new Object[0]), AllIcons.General.GearPlain);
            this.myView = view;
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLogcatPreferences preferences;
            Project project = this.myView.myProject;
            ConfigureLogcatHeaderDialog dialog = new ConfigureLogcatHeaderDialog(project, preferences = AndroidLogcatPreferences.getInstance(project), ZoneId.systemDefault());
            if (dialog.showAndGet()) {
                preferences.LOGCAT_FORMAT_STRING = dialog.getFormat();
                preferences.SHOW_AS_SECONDS_SINCE_EPOCH = dialog.getShowAsSecondsSinceEpochCheckBox().isSelected();
                this.myView.myLogConsole.refresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/logcat/AndroidLogcatView$MyConfigureLogcatHeaderAction", "<init>"));
        }
    }

    static final class MyRestartAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyRestartAction(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyRestartAction.$$$reportNull$$$0(0);
            }
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
            this.myView = view;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myView.notifyDeviceUpdated(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/logcat/AndroidLogcatView$MyRestartAction", "<init>"));
        }
    }

    private static final class MyLogcatListener
    extends FormattedLogcatReceiver {
        private final AndroidLogConsole myConsole;
        private final AndroidLogFilterModel myModel;

        private MyLogcatListener(@NotNull AndroidLogcatFormatter formatter, @NotNull AndroidLogConsole console, @NotNull AndroidLogFilterModel model) {
            if (formatter == null) {
                MyLogcatListener.$$$reportNull$$$0(0);
            }
            if (console == null) {
                MyLogcatListener.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyLogcatListener.$$$reportNull$$$0(2);
            }
            super(formatter);
            this.myConsole = console;
            this.myModel = model;
        }

        @Override
        protected void receiveFormattedLogLine(@NotNull String line) {
            if (line == null) {
                MyLogcatListener.$$$reportNull$$$0(3);
            }
            this.myConsole.addLogLine(line);
        }

        @Override
        public void onCleared() {
            this.myModel.beginRejectingOldMessages();
            if (this.myConsole.getConsole() == null) {
                return;
            }
            this.myConsole.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$MyLogcatListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "receiveFormattedLogLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

