/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.time.Instant;
import java.time.ZoneId;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

final class ConfigureLogcatHeaderDialog
extends DialogWrapper {
    private static final LogCatMessage SAMPLE = new LogCatMessage(new LogCatHeader(Log.LogLevel.INFO, 123, 456, "com.android.sample", "SampleTag", Instant.ofEpochMilli(1517955388555L)), "This is a sample message");
    private final ZoneId myTimeZone;
    private final AbstractButton myShowDateAndTimeCheckBox;
    private final AbstractButton myShowAsSecondsSinceEpochCheckBox;
    private final AbstractButton myShowProcessAndThreadIdsCheckBox;
    private final AbstractButton myShowPackageNameCheckBox;
    private final AbstractButton myShowTagCheckBox;
    private final JLabel mySampleLabel;

    ConfigureLogcatHeaderDialog(@NotNull Project project, @NotNull AndroidLogcatPreferences preferences, @NotNull ZoneId timeZone) {
        if (project == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(0);
        }
        if (preferences == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(1);
        }
        if (timeZone == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(2);
        }
        super(project, false, DialogWrapper.IdeModalityType.PROJECT);
        this.myTimeZone = timeZone;
        String format = preferences.LOGCAT_FORMAT_STRING;
        this.myShowDateAndTimeCheckBox = this.createShowDateAndTimeCheckBox(format);
        this.myShowAsSecondsSinceEpochCheckBox = this.createCheckBox("Show as seconds since epoch", preferences.SHOW_AS_SECONDS_SINCE_EPOCH, 8);
        this.myShowProcessAndThreadIdsCheckBox = this.createCheckBox("Show process and thread IDs", format.isEmpty() || format.contains("%2$s"), 5);
        this.myShowPackageNameCheckBox = this.createCheckBox("Show package name", format.isEmpty() || format.contains("%3$s"), 13);
        this.myShowTagCheckBox = this.createCheckBox("Show tag", format.isEmpty() || format.contains("%5$s"), 7);
        this.mySampleLabel = this.createSampleLabel();
        this.init();
        this.setTitle(AndroidBundle.message("android.configure.logcat.header.title", new Object[0]));
    }

    @NotNull
    private AbstractButton createShowDateAndTimeCheckBox(@NotNull String format) {
        if (format == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(3);
        }
        JCheckBox checkBox = new JCheckBox("Show date and time", format.isEmpty() || format.contains("%1$s"));
        checkBox.setDisplayedMnemonicIndex(14);
        checkBox.addItemListener(event -> {
            this.myShowAsSecondsSinceEpochCheckBox.setVisible(this.myShowDateAndTimeCheckBox.isSelected());
            this.mySampleLabel.setText(this.formatSample());
        });
        JCheckBox jCheckBox = checkBox;
        if (jCheckBox == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(4);
        }
        return jCheckBox;
    }

    @NotNull
    private AbstractButton createCheckBox(@NotNull String text, boolean selected, int displayedMnemonicIndex) {
        if (text == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(5);
        }
        JCheckBox checkBox = new JCheckBox(text, selected);
        checkBox.setDisplayedMnemonicIndex(displayedMnemonicIndex);
        checkBox.addItemListener(event -> this.mySampleLabel.setText(this.formatSample()));
        JCheckBox jCheckBox = checkBox;
        if (jCheckBox == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(6);
        }
        return jCheckBox;
    }

    @NotNull
    private JLabel createSampleLabel() {
        JLabel label = new JLabel(this.formatSample());
        label.setFont((Font)JBFont.create((Font)new Font("Monospaced", 0, 15)));
        JLabel jLabel = label;
        if (jLabel == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(7);
        }
        return jLabel;
    }

    @NotNull
    private String formatSample() {
        AndroidLogcatPreferences preferences = new AndroidLogcatPreferences();
        preferences.LOGCAT_FORMAT_STRING = this.getFormat();
        preferences.SHOW_AS_SECONDS_SINCE_EPOCH = this.myShowAsSecondsSinceEpochCheckBox.isSelected();
        String string = new AndroidLogcatFormatter(this.myTimeZone, preferences).formatMessage(SAMPLE);
        if (string == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    String getFormat() {
        boolean showDateAndTime = this.myShowDateAndTimeCheckBox.isSelected();
        boolean showProcessAndThreadIds = this.myShowProcessAndThreadIdsCheckBox.isSelected();
        boolean showPackageName = this.myShowPackageNameCheckBox.isSelected();
        boolean showTag = this.myShowTagCheckBox.isSelected();
        String string = showDateAndTime && showProcessAndThreadIds && showPackageName && showTag ? "" : AndroidLogcatFormatter.createCustomFormat(showDateAndTime, showProcessAndThreadIds, showPackageName, showTag);
        if (string == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    AbstractButton getShowDateAndTimeCheckBox() {
        AbstractButton abstractButton = this.myShowDateAndTimeCheckBox;
        if (abstractButton == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(10);
        }
        return abstractButton;
    }

    @NotNull
    AbstractButton getShowAsSecondsSinceEpochCheckBox() {
        AbstractButton abstractButton = this.myShowAsSecondsSinceEpochCheckBox;
        if (abstractButton == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(11);
        }
        return abstractButton;
    }

    @NotNull
    AbstractButton getShowProcessAndThreadIdsCheckBox() {
        AbstractButton abstractButton = this.myShowProcessAndThreadIdsCheckBox;
        if (abstractButton == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(12);
        }
        return abstractButton;
    }

    @NotNull
    AbstractButton getShowPackageNameCheckBox() {
        AbstractButton abstractButton = this.myShowPackageNameCheckBox;
        if (abstractButton == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(13);
        }
        return abstractButton;
    }

    @NotNull
    AbstractButton getShowTagCheckBox() {
        AbstractButton abstractButton = this.myShowTagCheckBox;
        if (abstractButton == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(14);
        }
        return abstractButton;
    }

    @NotNull
    JLabel getSampleLabel() {
        JLabel jLabel = this.mySampleLabel;
        if (jLabel == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(15);
        }
        return jLabel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(null);
        GroupLayout layout2 = new GroupLayout(panel);
        GroupLayout.ParallelGroup horizontalGroup = layout2.createParallelGroup().addComponent(this.myShowDateAndTimeCheckBox).addGroup(layout2.createSequentialGroup().addPreferredGap(this.myShowDateAndTimeCheckBox, this.myShowAsSecondsSinceEpochCheckBox, LayoutStyle.ComponentPlacement.INDENT).addComponent(this.myShowAsSecondsSinceEpochCheckBox)).addComponent(this.myShowProcessAndThreadIdsCheckBox).addComponent(this.myShowPackageNameCheckBox).addComponent(this.myShowTagCheckBox).addComponent(this.mySampleLabel);
        GroupLayout.SequentialGroup verticalGroup = layout2.createSequentialGroup().addComponent(this.myShowDateAndTimeCheckBox).addComponent(this.myShowAsSecondsSinceEpochCheckBox).addComponent(this.myShowProcessAndThreadIdsCheckBox).addComponent(this.myShowPackageNameCheckBox).addComponent(this.myShowTagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mySampleLabel);
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel.setLayout(layout2);
        JPanel jPanel = panel;
        if (jPanel == null) {
            ConfigureLogcatHeaderDialog.$$$reportNull$$$0(16);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeZone";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/ConfigureLogcatHeaderDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/ConfigureLogcatHeaderDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createShowDateAndTimeCheckBox";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckBox";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSampleLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSample";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowDateAndTimeCheckBox";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowAsSecondsSinceEpochCheckBox";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowProcessAndThreadIdsCheckBox";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowPackageNameCheckBox";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowTagCheckBox";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSampleLabel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createShowDateAndTimeCheckBox";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCheckBox";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

