/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.lint.checks.PermissionHolder;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedManifest {
    private final Module myModule;
    private String myPackage;
    private String myApplicationId;
    private Integer myVersionCode;
    private String myManifestTheme;
    private Map<String, ActivityAttributes> myActivityAttributesMap;
    private ManifestInfo.ManifestFile myManifestFile;
    private long myLastChecked;
    private AndroidVersion myMinSdk;
    private AndroidVersion myTargetSdk;
    private String myApplicationIcon;
    private String myApplicationLabel;
    private boolean myApplicationSupportsRtl;
    private Boolean myApplicationDebuggable;
    @Nullable
    private Map<String, XmlNode.NodeKey> myNodeKeys;
    private Document myDocument;
    private List<VirtualFile> myManifestFiles;
    private ModulePermissions myPermissionHolder;
    private boolean myApplicationHasCode;
    private List<Element> myActivities;
    private List<Element> myActivityAliases;
    private List<Element> myServices;

    MergedManifest(@NotNull Module module) {
        if (module == null) {
            MergedManifest.$$$reportNull$$$0(0);
        }
        this.myApplicationHasCode = true;
        this.myActivities = Collections.emptyList();
        this.myActivityAliases = Collections.emptyList();
        this.myServices = Collections.emptyList();
        this.myModule = module;
    }

    @NotNull
    public static MergedManifest get(@NotNull Module module) {
        if (module == null) {
            MergedManifest.$$$reportNull$$$0(1);
        }
        if (module.isDisposed()) {
            MergedManifest mergedManifest = new MergedManifest(module){

                @Override
                protected void syncWithReadPermission() {
                }
            };
            if (mergedManifest == null) {
                MergedManifest.$$$reportNull$$$0(2);
            }
            return mergedManifest;
        }
        MergedManifest manifest = (MergedManifest)module.getComponent(MergedManifest.class);
        assert (manifest != null);
        MergedManifest mergedManifest = manifest;
        if (mergedManifest == null) {
            MergedManifest.$$$reportNull$$$0(3);
        }
        return mergedManifest;
    }

    @NotNull
    public static MergedManifest get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            MergedManifest.$$$reportNull$$$0(4);
        }
        MergedManifest mergedManifest = MergedManifest.get(facet.getModule());
        if (mergedManifest == null) {
            MergedManifest.$$$reportNull$$$0(5);
        }
        return mergedManifest;
    }

    @Nullable
    public Document getDocument() {
        this.sync();
        return this.myDocument;
    }

    @Nullable
    public List<VirtualFile> getManifestFiles() {
        return this.myManifestFiles;
    }

    public void clear() {
        this.myLastChecked = 0L;
    }

    @Nullable
    public String getPackage() {
        this.sync();
        return this.myPackage;
    }

    @Nullable
    public String getApplicationId() {
        this.sync();
        return this.myApplicationId;
    }

    @Nullable
    public Integer getVersionCode() {
        this.sync();
        return this.myVersionCode;
    }

    @NotNull
    public Map<String, ActivityAttributes> getActivityAttributesMap() {
        this.sync();
        if (this.myActivityAttributesMap == null) {
            Map<String, ActivityAttributes> map2 = Collections.emptyMap();
            if (map2 == null) {
                MergedManifest.$$$reportNull$$$0(6);
            }
            return map2;
        }
        Map<String, ActivityAttributes> map3 = this.myActivityAttributesMap;
        if (map3 == null) {
            MergedManifest.$$$reportNull$$$0(7);
        }
        return map3;
    }

    @Nullable
    public ActivityAttributes getActivityAttributes(@NotNull String activity) {
        int index;
        if (activity == null) {
            MergedManifest.$$$reportNull$$$0(8);
        }
        if ((index = activity.indexOf(46)) <= 0 && this.myApplicationId != null && !this.myApplicationId.isEmpty()) {
            activity = this.myApplicationId + (index == -1 ? "." : "") + activity;
        }
        return this.getActivityAttributesMap().get(activity);
    }

    @Nullable
    public String getManifestTheme() {
        this.sync();
        return this.myManifestTheme;
    }

    @NotNull
    public String getDefaultTheme(@Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        int targetSdk;
        AndroidFacet facet;
        this.sync();
        if (this.myManifestTheme != null) {
            String string = this.myManifestTheme;
            if (string == null) {
                MergedManifest.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                if ("@android:style/Theme.DeviceDefault.Light" == null) {
                    MergedManifest.$$$reportNull$$$0(10);
                }
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                if ("@style/Theme.Leanback" == null) {
                    MergedManifest.$$$reportNull$$$0(11);
                }
                return "@style/Theme.Leanback";
            }
        }
        if ((facet = AndroidFacet.getInstance(this.myModule)) == null) {
            if ("@android:style/Theme.Material.Light" == null) {
                MergedManifest.$$$reportNull$$$0(12);
            }
            return "@android:style/Theme.Material.Light";
        }
        AndroidModuleInfo info = AndroidModuleInfo.getInstance(facet);
        int renderingTargetSdk = targetSdk = info.getTargetSdkVersion().getApiLevel();
        if (renderingTarget instanceof CompatibilityRenderTarget) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        } else if (renderingTarget != null) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        }
        int apiLevel = Math.min(targetSdk, renderingTargetSdk);
        if (apiLevel >= 21) {
            if ("@android:style/Theme.Material.Light" == null) {
                MergedManifest.$$$reportNull$$$0(13);
            }
            return "@android:style/Theme.Material.Light";
        }
        if (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE) {
            if ("@android:style/Theme.Holo" == null) {
                MergedManifest.$$$reportNull$$$0(14);
            }
            return "@android:style/Theme.Holo";
        }
        if ("@android:style/Theme" == null) {
            MergedManifest.$$$reportNull$$$0(15);
        }
        return "@android:style/Theme";
    }

    @Nullable
    public String getApplicationIcon() {
        this.sync();
        return this.myApplicationIcon;
    }

    @Nullable
    public String getApplicationLabel() {
        this.sync();
        return this.myApplicationLabel;
    }

    public boolean isRtlSupported() {
        this.sync();
        return this.myApplicationSupportsRtl;
    }

    @Nullable
    public Boolean getApplicationDebuggable() {
        this.sync();
        return this.myApplicationDebuggable;
    }

    public boolean getApplicationHasCode() {
        this.sync();
        return this.myApplicationHasCode;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        this.sync();
        AndroidVersion androidVersion = this.myTargetSdk != null ? this.myTargetSdk : this.getMinSdkVersion();
        if (androidVersion == null) {
            MergedManifest.$$$reportNull$$$0(16);
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        this.sync();
        AndroidVersion androidVersion = this.myMinSdk != null ? this.myMinSdk : AndroidVersion.DEFAULT;
        if (androidVersion == null) {
            MergedManifest.$$$reportNull$$$0(17);
        }
        return androidVersion;
    }

    @NotNull
    public PermissionHolder getPermissionHolder() {
        this.sync();
        if (this.myPermissionHolder == null) {
            ModulePermissions modulePermissions = new ModulePermissions(Collections.emptySet(), Collections.emptySet());
            if (modulePermissions == null) {
                MergedManifest.$$$reportNull$$$0(18);
            }
            return modulePermissions;
        }
        ModulePermissions modulePermissions = this.myPermissionHolder;
        if (modulePermissions == null) {
            MergedManifest.$$$reportNull$$$0(19);
        }
        return modulePermissions;
    }

    private void sync() {
        long now = System.currentTimeMillis();
        if (now - this.myLastChecked < 50L && this.myManifestFile != null) {
            return;
        }
        this.myLastChecked = now;
        ApplicationManager.getApplication().runReadAction(this::syncWithReadPermission);
    }

    static String getAttributeValue(@NotNull Element element, @Nullable String namespace, @NotNull String localName) {
        if (element == null) {
            MergedManifest.$$$reportNull$$$0(20);
        }
        if (localName == null) {
            MergedManifest.$$$reportNull$$$0(21);
        }
        return Strings.emptyToNull((String)element.getAttributeNS(namespace, localName));
    }

    protected synchronized void syncWithReadPermission() {
        boolean refresh2;
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null) : "Attempt to obtain manifest info from a non Android module: " + this.myModule.getName();
        if (this.myManifestFile == null) {
            this.myManifestFile = ManifestInfo.ManifestFile.create(facet);
        }
        if (!(refresh2 = this.myManifestFile.refresh())) {
            return;
        }
        this.myActivityAttributesMap = new HashMap<String, ActivityAttributes>();
        this.myManifestTheme = null;
        this.myTargetSdk = AndroidVersion.DEFAULT;
        this.myMinSdk = AndroidVersion.DEFAULT;
        this.myPackage = "";
        this.myApplicationId = "";
        this.myVersionCode = null;
        this.myApplicationIcon = null;
        this.myApplicationLabel = null;
        this.myApplicationSupportsRtl = false;
        this.myNodeKeys = null;
        this.myActivities = Lists.newArrayList();
        this.myActivityAliases = Lists.newArrayListWithExpectedSize((int)4);
        this.myServices = Lists.newArrayListWithExpectedSize((int)4);
        HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
        HashSet revocable = Sets.newHashSetWithExpectedSize((int)2);
        try {
            Document document = this.myManifestFile.getXmlDocument();
            if (document == null) {
                return;
            }
            this.myDocument = document;
            this.myManifestFiles = this.myManifestFile.getManifestFiles();
            Element root = document.getDocumentElement();
            if (root == null) {
                return;
            }
            this.myApplicationId = MergedManifest.getAttributeValue(root, null, "package");
            Manifest manifest = facet.getManifest();
            this.myPackage = manifest == null ? this.myApplicationId : (String)manifest.getPackage().getValue();
            String versionCode2 = MergedManifest.getAttributeValue(root, "http://schemas.android.com/apk/res/android", "versionCode");
            try {
                this.myVersionCode = Integer.valueOf(versionCode2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                String name;
                String protectionLevel;
                Element element;
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if ("application".equals(nodeName)) {
                    Element application = (Element)node;
                    this.myApplicationIcon = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "icon");
                    this.myApplicationLabel = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "label");
                    this.myManifestTheme = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "theme");
                    this.myApplicationSupportsRtl = "true".equals(MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "supportsRtl"));
                    String debuggable2 = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "debuggable");
                    this.myApplicationDebuggable = debuggable2 == null ? null : Boolean.valueOf("true".equals(debuggable2));
                    String hasCode = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "hasCode");
                    this.myApplicationHasCode = hasCode == null ? true : "true".equals(hasCode);
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 1) continue;
                        String childNodeName = child.getNodeName();
                        if ("activity".equals(childNodeName)) {
                            Element element2 = (Element)child;
                            ActivityAttributes attributes = new ActivityAttributes(element2, this.myApplicationId);
                            this.myActivityAttributesMap.put(attributes.getName(), attributes);
                            this.myActivities.add(element2);
                            continue;
                        }
                        if ("activity-alias".equals(childNodeName)) {
                            this.myActivityAliases.add((Element)child);
                            continue;
                        }
                        if (!"service".equals(childNodeName)) continue;
                        this.myServices.add((Element)child);
                    }
                    continue;
                }
                if ("uses-sdk".equals(nodeName)) {
                    Element usesSdk = (Element)node;
                    this.myMinSdk = MergedManifest.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                    this.myTargetSdk = MergedManifest.getApiVersion(usesSdk, "targetSdkVersion", this.myMinSdk);
                    continue;
                }
                if ("uses-permission".equals(nodeName) || "uses-permission-sdk-23".equals(nodeName) || "uses-permission-sdk-m".equals(nodeName)) {
                    element = (Element)node;
                    String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (name2.isEmpty()) continue;
                    permissions.add(name2);
                    continue;
                }
                if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
                revocable.add(name);
            }
            this.myPermissionHolder = new ModulePermissions((Set)ImmutableSet.copyOf((Collection)permissions), (Set)ImmutableSet.copyOf((Collection)revocable));
        }
        catch (ProcessCanceledException e) {
            this.myManifestFile = null;
            this.myDocument = null;
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(MergedManifest.class).warn("Could not read Manifest data", (Throwable)e);
        }
    }

    private static AndroidVersion getApiVersion(Element usesSdk, String attribute, AndroidVersion defaultApiLevel) {
        AndroidVersion version2;
        String valueString = MergedManifest.getAttributeValue(usesSdk, "http://schemas.android.com/apk/res/android", attribute);
        if (valueString != null && (version2 = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version2;
        }
        return defaultApiLevel;
    }

    @NotNull
    public List<Element> getActivities() {
        this.sync();
        List<Element> list = this.myActivities;
        if (list == null) {
            MergedManifest.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public List<Element> getActivityAliases() {
        this.sync();
        List<Element> list = this.myActivityAliases;
        if (list == null) {
            MergedManifest.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public List<Element> getServices() {
        List<Element> list = this.myServices;
        if (list == null) {
            MergedManifest.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    public Element findUsedFeature(@NotNull String name) {
        if (name == null) {
            MergedManifest.$$$reportNull$$$0(25);
        }
        this.sync();
        if (this.myDocument == null) {
            return null;
        }
        for (Node node = this.myDocument.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (node.getNodeType() != 1 || !"uses-feature".equals(node.getNodeName()) || !name.equals((element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        this.sync();
        ImmutableList<MergingReport.Record> immutableList = this.myManifestFile == null ? ImmutableList.of() : this.myManifestFile.getLoggingRecords();
        if (immutableList == null) {
            MergedManifest.$$$reportNull$$$0(26);
        }
        return immutableList;
    }

    @Nullable
    public Actions getActions() {
        this.sync();
        return this.myManifestFile == null ? null : this.myManifestFile.getActions();
    }

    @Nullable
    public XmlNode.NodeKey getNodeKey(String name) {
        this.sync();
        if (this.myNodeKeys == null) {
            HashMap<String, XmlNode.NodeKey> nodeKeys = new HashMap<String, XmlNode.NodeKey>();
            Actions actions2 = this.getActions();
            if (actions2 != null) {
                Set keys = actions2.getNodeKeys();
                for (XmlNode.NodeKey key : keys) {
                    nodeKeys.put(key.toString(), key);
                }
            }
            this.myNodeKeys = nodeKeys;
        }
        return this.myNodeKeys.get(name);
    }

    @Nullable
    public Element findActivity(@Nullable String qualifiedName) {
        this.sync();
        if (qualifiedName == null || this.myActivities == null) {
            return null;
        }
        return MergedManifest.getActivityOrAliasByName(qualifiedName, this.myActivities);
    }

    @Nullable
    public Element findActivityAlias(@Nullable String qualifiedName) {
        this.sync();
        if (qualifiedName == null || this.myActivityAliases == null) {
            return null;
        }
        return MergedManifest.getActivityOrAliasByName(qualifiedName, this.myActivityAliases);
    }

    @Nullable
    private static Element getActivityOrAliasByName(@NotNull String qualifiedName, @NotNull List<Element> activityOrAliasElements) {
        if (qualifiedName == null) {
            MergedManifest.$$$reportNull$$$0(27);
        }
        if (activityOrAliasElements == null) {
            MergedManifest.$$$reportNull$$$0(28);
        }
        for (Element activity : activityOrAliasElements) {
            if (!qualifiedName.equals(ActivityLocatorUtils.getQualifiedName(activity))) continue;
            return activity;
        }
        return null;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            MergedManifest.$$$reportNull$$$0(29);
        }
        return module;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/model/MergedManifest";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityOrAliasElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/model/MergedManifest";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityAttributesMap";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTheme";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionHolder";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivities";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityAliases";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingRecords";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActivityAttributes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findUsedFeature";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getActivityOrAliasByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModulePermissions
    implements PermissionHolder {
        @NotNull
        private final Set<String> myPermissions;
        @NotNull
        private final Set<String> myRevocable;

        private ModulePermissions(@NotNull Set<String> permissions, Set<String> revocable) {
            if (permissions == null) {
                ModulePermissions.$$$reportNull$$$0(0);
            }
            if (revocable == null) {
                ModulePermissions.$$$reportNull$$$0(1);
            }
            this.myPermissions = permissions;
            this.myRevocable = revocable;
        }

        public boolean hasPermission(@NotNull String permission) {
            if (permission == null) {
                ModulePermissions.$$$reportNull$$$0(2);
            }
            return this.myPermissions.contains(permission);
        }

        public boolean isRevocable(@NotNull String permission) {
            if (permission == null) {
                ModulePermissions.$$$reportNull$$$0(3);
            }
            return this.myRevocable.contains(permission);
        }

        @NotNull
        public AndroidVersion getMinSdkVersion() {
            AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(MergedManifest.this.myModule);
            AndroidVersion androidVersion = androidModuleInfo != null ? androidModuleInfo.getMinSdkVersion() : MergedManifest.this.getMinSdkVersion();
            if (androidVersion == null) {
                ModulePermissions.$$$reportNull$$$0(4);
            }
            return androidVersion;
        }

        @NotNull
        public AndroidVersion getTargetSdkVersion() {
            AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(MergedManifest.this.myModule);
            AndroidVersion androidVersion = androidModuleInfo != null ? androidModuleInfo.getTargetSdkVersion() : MergedManifest.this.getTargetSdkVersion();
            if (androidVersion == null) {
                ModulePermissions.$$$reportNull$$$0(5);
            }
            return androidVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "permissions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revocable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "permission";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/model/MergedManifest$ModulePermissions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/model/MergedManifest$ModulePermissions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMinSdkVersion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetSdkVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "hasPermission";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isRevocable";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActivityAttributes {
        @NotNull
        private final Element myElement;
        @Nullable
        private final String myIcon;
        @Nullable
        private final String myLabel;
        @NotNull
        private final String myName;
        @Nullable
        private final String myParentActivity;
        @Nullable
        private final String myTheme;
        @Nullable
        private final String myUiOptions;

        public ActivityAttributes(@NotNull Element activity, @Nullable String packageName) {
            if (activity == null) {
                ActivityAttributes.$$$reportNull$$$0(0);
            }
            this.myElement = activity;
            String name = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "name");
            if (name == null || name.isEmpty()) {
                throw new RuntimeException("Activity name cannot be empty.");
            }
            int index = name.indexOf(46);
            if (index <= 0 && packageName != null && !packageName.isEmpty()) {
                name = packageName + (index == -1 ? "." : "") + name;
            }
            this.myName = name;
            String value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "icon");
            this.myIcon = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "label");
            this.myLabel = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "parentActivityName");
            if (value == null || value.isEmpty()) {
                for (Node child = activity.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String metaDataName;
                    if (child.getNodeType() != 1 || !child.getNodeName().equals("meta-data") || !"android.support.PARENT_ACTIVITY".equals(metaDataName = MergedManifest.getAttributeValue((Element)child, "http://schemas.android.com/apk/res/android", "name")) || (value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "value")) == null || (index = value.indexOf(46)) > 0 || packageName == null || packageName.isEmpty()) continue;
                    value = packageName + (index == -1 ? "." : "") + value;
                    break;
                }
            }
            this.myParentActivity = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "theme");
            this.myTheme = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "uiOptions");
            this.myUiOptions = value != null && !value.isEmpty() ? value : null;
        }

        @NotNull
        public Element getElement() {
            Element element = this.myElement;
            if (element == null) {
                ActivityAttributes.$$$reportNull$$$0(1);
            }
            return element;
        }

        @Nullable
        public String getIcon() {
            return this.myIcon;
        }

        @Nullable
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ActivityAttributes.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getParentActivity() {
            return this.myParentActivity;
        }

        @Nullable
        public String getTheme() {
            return this.myTheme;
        }

        @Nullable
        public String getUiOptions() {
            return this.myUiOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activity";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/model/MergedManifest$ActivityAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/model/MergedManifest$ActivityAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

