/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.LogcatPanel;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ProjectTopics;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidToolWindowFactory
implements ToolWindowFactory,
DumbAware,
Condition<Project> {
    public static final Key<DevicePanel> DEVICES_PANEL_KEY = Key.create((String)"DevicePanel");

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(1);
        }
        ExecutionManager.getInstance((Project)project).getContentManager();
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        final LogcatPanel logcatPanel = new LogcatPanel(project);
        AndroidLogcatView logcatView = logcatPanel.getLogcatView();
        ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener((ToolWindowManagerListener)new MyToolWindowManagerListener(project, logcatView));
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(logcatView));
        ContentManager contentManager = toolWindow.getContentManager();
        Content c = contentManager.getFactory().createContent((JComponent)((Object)logcatPanel), "", true);
        c.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        c.putUserData(DEVICES_PANEL_KEY, (Object)logcatPanel.getDevicePanel());
        contentManager.addContent(c);
        ApplicationManager.getApplication().invokeLater(() -> {
            ConsoleView console;
            if (project == null) {
                AndroidToolWindowFactory.$$$reportNull$$$0(4);
            }
            logcatView.activate();
            ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.getToolWindowId());
            if (window != null && window.isVisible() && (console = logcatView.getLogConsole().getConsole()) != null) {
                AndroidToolWindowFactory.checkFacetAndSdk(project, console);
            }
        }, project.getDisposed());
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        logcatPanel.setLoadingText("Initializing ADB");
        logcatPanel.startLoading();
        ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future2, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                Logger.getInstance(AndroidToolWindowFactory.class).info("Successfully obtained debug bridge");
                logcatPanel.stopLoading();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                logcatPanel.stopLoading();
                Logger.getInstance(AndroidToolWindowFactory.class).info("Unable to obtain debug bridge", t);
                Messages.showErrorDialog((String)AdbService.getDebugBridgeDiagnosticErrorMessage(t, adb), (String)"ADB Connection Error");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/monitor/AndroidToolWindowFactory$1", "onFailure"));
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    @NotNull
    public static String getToolWindowId() {
        if ("Logcat" == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(2);
        }
        return "Logcat";
    }

    private static void checkFacetAndSdk(Project project, @NotNull ConsoleView console) {
        List facets;
        if (console == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(3);
        }
        if ((facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
            console.clear();
            console.print(AndroidBundle.message("android.logcat.no.android.facets.error", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            console.clear();
            Module module = facet.getModule();
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                console.print("Please ", ConsoleViewContentType.ERROR_OUTPUT);
                console.printHyperlink("configure", p -> AndroidSdkUtils.openModuleDependenciesConfigurable(module));
                console.print(" Android SDK\n", ConsoleViewContentType.ERROR_OUTPUT);
            } else {
                console.print(AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName()) + '\n', ConsoleViewContentType.ERROR_OUTPUT);
            }
        }
    }

    public boolean value(Project project) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/AndroidToolWindowFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/AndroidToolWindowFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFacetAndSdk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createToolWindowContent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAndroidPlatformListener
    implements ModuleRootListener {
        private final Project myProject;
        private final AndroidLogcatView myView;
        private AndroidPlatform myPrevPlatform;

        private MyAndroidPlatformListener(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyAndroidPlatformListener.$$$reportNull$$$0(0);
            }
            this.myProject = view.getProject();
            this.myView = view;
            this.myPrevPlatform = this.getPlatform();
        }

        public void rootsChanged(ModuleRootEvent event) {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(AndroidToolWindowFactory.getToolWindowId());
            if (window == null) {
                return;
            }
            if (window.isDisposed() || !window.isVisible()) {
                return;
            }
            AndroidPlatform newPlatform = this.getPlatform();
            if (!Comparing.equal((Object)this.myPrevPlatform, (Object)newPlatform)) {
                this.myPrevPlatform = newPlatform;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!window.isDisposed() && window.isVisible()) {
                        this.myView.activate();
                    }
                });
            }
        }

        @Nullable
        private AndroidPlatform getPlatform() {
            AndroidPlatform newPlatform = null;
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (!facets.isEmpty()) {
                AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
                newPlatform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            }
            return newPlatform;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/monitor/AndroidToolWindowFactory$MyAndroidPlatformListener", "<init>"));
        }
    }

    private static final class MyToolWindowManagerListener
    extends ToolWindowManagerAdapter {
        private final Project myProject;
        private final AndroidLogcatView myLogcatView;
        private boolean myToolWindowVisible;

        private MyToolWindowManagerListener(@NotNull Project project, @NotNull AndroidLogcatView logcatView) {
            if (project == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(0);
            }
            if (logcatView == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myLogcatView = logcatView;
        }

        public void stateChanged() {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Logcat");
            if (window == null) {
                return;
            }
            boolean visible = window.isVisible();
            if (this.myToolWindowVisible == visible) {
                return;
            }
            this.myToolWindowVisible = visible;
            this.myLogcatView.activate();
            if (!visible) {
                return;
            }
            ConsoleView consoleView = this.myLogcatView.getLogConsole().getConsole();
            if (consoleView == null) {
                return;
            }
            AndroidToolWindowFactory.checkFacetAndSdk(this.myProject, consoleView);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logcatView";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/monitor/AndroidToolWindowFactory$MyToolWindowManagerListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

