/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.editors;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.model.stdui.CommonBorderModel;
import com.android.tools.adtui.model.stdui.DefaultCommonBorderModel;
import com.android.tools.adtui.stdui.CommonBorder;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditor
extends BaseComponentEditor {
    private static final int HORIZONTAL_SPACE_AFTER_LABEL = 4;
    private final JPanel myPanel;
    private final JLabel myLabel;
    private final Project myProject;
    private final EditorTextField myTextEditor;
    private NlProperty myProperty;
    private String myLastReadValue;
    private Object myLastWriteValue;

    public TextEditor(@NotNull Project project, final boolean drawBorder, @NotNull NlEditingListener listener2) {
        if (project == null) {
            TextEditor.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            TextEditor.$$$reportNull$$$0(1);
        }
        super(listener2);
        this.myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout());
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        this.myLabel = new JBLabel();
        this.myPanel.add((Component)this.myLabel, "Before");
        this.myPanel.setFocusable(false);
        if (drawBorder) {
            this.myLabel.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        }
        this.myProject = project;
        this.myTextEditor = new EditorTextField("", this.myProject, (FileType)FileTypes.PLAIN_TEXT){

            public void addNotify() {
                super.addNotify();
                this.getEditor().getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)true);
                if (drawBorder) {
                    this.getEditor().setBorder((Border)new CommonBorder(1.0f, (CommonBorderModel)new DefaultCommonBorderModel(), (Insets)JBUI.insets((int)4, (int)3)));
                }
            }

            public void removeNotify() {
                super.removeNotify();
                this.removeAll();
            }
        };
        this.myPanel.add((Component)this.myTextEditor, "Center");
        this.myTextEditor.registerKeyboardAction(event -> this.stopEditing(this.getText()), KeyStroke.getKeyStroke(10, 0), 1);
        this.myTextEditor.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.myTextEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                TextEditor.this.myTextEditor.selectAll();
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                TextEditor.this.stopEditing(TextEditor.this.getText());
                TextEditor.this.myTextEditor.removeSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/naveditor/property/editors/TextEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myProperty = EmptyProperty.INSTANCE;
    }

    @NotNull
    private String getText() {
        String string = this.myTextEditor.getDocument().getText();
        if (string == null) {
            TextEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setText(@NotNull String value) {
        if (value == null) {
            TextEditor.$$$reportNull$$$0(3);
        }
        this.myTextEditor.getDocument().setText((CharSequence)value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myTextEditor.setEnabled(enabled);
        if (!enabled) {
            this.myLastReadValue = "";
            this.myLastWriteValue = "";
            this.myTextEditor.setText("");
        }
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        NlProperty nlProperty = this.myProperty;
        if (nlProperty == null) {
            TextEditor.$$$reportNull$$$0(4);
        }
        return nlProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property2) {
        if (property2 == null) {
            TextEditor.$$$reportNull$$$0(5);
        }
        if (this.myProperty != property2) {
            this.myProperty = property2;
            this.myLastReadValue = null;
        }
        this.myPanel.add((Component)this.myLabel, "Before");
        String propValue = StringUtil.notNullize((String)this.myProperty.getValue());
        if (!propValue.equals(this.myLastReadValue)) {
            this.myLastReadValue = propValue;
            this.myLastWriteValue = propValue;
            this.myTextEditor.setText(propValue);
        }
        JBColor color = this.myProperty.isDefaultValue(this.myLastReadValue) ? DEFAULT_VALUE_TEXT_COLOR : CHANGED_VALUE_TEXT_COLOR;
        this.myTextEditor.setForeground((Color)color);
    }

    @Override
    public void requestFocus() {
        if (this.myTextEditor.getEditor() != null) {
            this.myTextEditor.requestFocus();
        }
        this.myTextEditor.selectAll();
        this.myTextEditor.scrollRectToVisible(this.myTextEditor.getBounds());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TextEditor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public Object getValue() {
        String string = this.getText();
        if (string == null) {
            TextEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public void stopEditing(@Nullable Object newValue) {
        this.myTextEditor.setText((String)newValue);
        if (this.myTextEditor.hasFocus()) {
            this.myTextEditor.selectAll();
        }
        if (!Objects.equals(newValue, this.myLastWriteValue)) {
            this.myLastWriteValue = newValue;
            this.myLastReadValue = null;
            super.stopEditing(newValue);
        }
    }

    protected void cancel() {
        this.myTextEditor.setText(this.myProperty.getValue());
        this.myTextEditor.selectAll();
        this.cancelEditing();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/property/editors/TextEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/property/editors/TextEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

