/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavDestinationHitProvider;
import com.android.tools.idea.naveditor.scene.decorator.NavSceneDecoratorFactory;
import com.android.tools.idea.naveditor.scene.layout.ElkLayeredLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.ManualLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NewDestinationLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.targets.NavScreenTargetProvider;
import com.android.tools.idea.naveditor.scene.targets.NavigationTargetProvider;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.naveditor.surface.NavView;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavSceneManager
extends SceneManager {
    private static final int SCREEN_LONG = JBUI.scale((int)256);
    private static final int SUBNAV_WIDTH = JBUI.scale((int)140);
    private static final int SUBNAV_HEIGHT = JBUI.scale((int)38);
    private static final int PAN_LIMIT = JBUI.scale((int)150);
    private static final int BOUNDING_BOX_PADDING = JBUI.scale((int)100);
    public static final int ACTION_ARROW_PARALLEL = JBUI.scale((int)10);
    public static final int ACTION_ARROW_PERPENDICULAR;
    private static final int ACTION_HEIGHT;
    private static final int ACTION_VERTICAL_PADDING;
    private static final int GLOBAL_ACTION_LINE_LENGTH;
    private static final int GLOBAL_ACTION_WIDTH;
    private static final int GLOBAL_ACTION_HORIZONTAL_PADDING;
    private static final int EXIT_ACTION_LINE_LENGTH;
    private static final int EXIT_ACTION_WIDTH;
    private static final int EXIT_ACTION_HORIZONTAL_PADDING;
    private final NavScreenTargetProvider myScreenTargetProvider;
    private final NavigationTargetProvider myNavigationTargetProvider;
    private final HitProvider myNavDestinationHitProvider;
    private final List<NavSceneLayoutAlgorithm> myLayoutAlgorithms;
    private final NavSceneLayoutAlgorithm mySavingLayoutAlgorithm;
    private SceneDecoratorFactory myDecoratorFactory;
    private NavigationSchema mySchema;

    public NavSceneManager(@NotNull NlModel model, @NotNull NavDesignSurface surface) {
        if (model == null) {
            NavSceneManager.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            NavSceneManager.$$$reportNull$$$0(1);
        }
        super(model, surface);
        this.myNavDestinationHitProvider = new NavDestinationHitProvider();
        this.createSceneView();
        this.myLayoutAlgorithms = ImmutableList.of((Object)new NewDestinationLayoutAlgorithm(), (Object)new ManualLayoutAlgorithm(model.getModule()), (Object)new ElkLayeredLayoutAlgorithm());
        this.mySavingLayoutAlgorithm = this.myLayoutAlgorithms.stream().filter(algorithm -> algorithm.canSave()).findFirst().orElse(null);
        this.myScreenTargetProvider = new NavScreenTargetProvider();
        this.myNavigationTargetProvider = new NavigationTargetProvider(surface);
        NavSceneManager.updateHierarchy(this.getModel(), null);
        this.getModel().addListener(new ModelChangeListener());
        this.getDesignSurface().getSelectionModel().addListener((unused, selection) -> this.getScene().needsRebuildList());
    }

    @Override
    @NotNull
    protected NavDesignSurface getDesignSurface() {
        NavDesignSurface navDesignSurface = (NavDesignSurface)super.getDesignSurface();
        if (navDesignSurface == null) {
            NavSceneManager.$$$reportNull$$$0(2);
        }
        return navDesignSurface;
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NavDesignSurface surface = this.getDesignSurface();
        NavView navView = new NavView(surface, (SceneManager)this);
        surface.getLayeredPane().setPreferredSize(navView.getPreferredSize());
        NavView navView2 = navView;
        if (navView2 == null) {
            NavSceneManager.$$$reportNull$$$0(3);
        }
        return navView2;
    }

    @Override
    protected void updateFromComponent(@NotNull SceneComponent sceneComponent) {
        if (sceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(4);
        }
        super.updateFromComponent(sceneComponent);
        NlComponent nlComponent = sceneComponent.getNlComponent();
        switch (NavComponentHelperKt.getActionType(nlComponent)) {
            case GLOBAL: {
                sceneComponent.setSize(GLOBAL_ACTION_WIDTH, ACTION_HEIGHT, false);
                return;
            }
            case EXIT: {
                sceneComponent.setSize(EXIT_ACTION_WIDTH, ACTION_HEIGHT, false);
                return;
            }
        }
        NavigationSchema.DestinationType type = this.getSchema().getDestinationType(nlComponent.getTagName());
        if (type != null) {
            sceneComponent.setTargetProvider(sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation() ? this.myNavigationTargetProvider : this.myScreenTargetProvider);
            switch (type) {
                case NAVIGATION: {
                    if (sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
                        sceneComponent.setSize(-1, -1, false);
                        break;
                    }
                    sceneComponent.setSize(SUBNAV_WIDTH, SUBNAV_HEIGHT, false);
                    break;
                }
                case FRAGMENT: 
                case ACTIVITY: {
                    State state = this.getModel().getConfiguration().getDeviceState();
                    assert (state != null);
                    Screen screen = state.getHardware().getScreen();
                    int x = SCREEN_LONG;
                    int y = SCREEN_LONG;
                    double ratio = (double)screen.getXDimension() / (double)screen.getYDimension();
                    if (ratio > 1.0) {
                        y = (int)((double)y / ratio);
                    } else {
                        x = (int)((double)x * ratio);
                    }
                    if (ratio < 1.1 && ratio > 0.9) {
                        x = (int)((double)x * 0.5);
                        y = (int)((double)y * 0.5);
                    }
                    if (state.getOrientation() == ScreenOrientation.LANDSCAPE) {
                        int tmp = x;
                        x = y;
                        y = tmp;
                    }
                    sceneComponent.setSize(x, y, true);
                    break;
                }
            }
        }
    }

    @Override
    protected void postUpdateFromComponent(@NotNull SceneComponent sceneComponent) {
        NavigationSchema.DestinationType type;
        if (sceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(5);
        }
        if ((type = this.getSchema().getDestinationType(sceneComponent.getNlComponent().getTagName())) == NavigationSchema.DestinationType.NAVIGATION && sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
            this.layoutAll(sceneComponent);
            this.updateRootBounds(sceneComponent);
        }
    }

    private void updateRootBounds(@NotNull SceneComponent root) {
        Rectangle rootBounds;
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(6);
        }
        NavDesignSurface surface = this.getDesignSurface();
        Dimension extentSize = surface.getExtentSize();
        int extentWidth = Coordinates.getAndroidDimension(surface, extentSize.width);
        int extentHeight = Coordinates.getAndroidDimension(surface, extentSize.height);
        if (this.isEmpty()) {
            rootBounds = new Rectangle(0, 0, extentWidth, extentHeight);
        } else {
            int panLimit = Coordinates.getAndroidDimension(surface, PAN_LIMIT);
            rootBounds = NavSceneManager.getBoundingBox(root);
            rootBounds.grow(extentWidth - panLimit, extentHeight - panLimit);
        }
        int drawX = root.getDrawX();
        int drawY = root.getDrawY();
        root.setPosition(rootBounds.x, rootBounds.y);
        root.setSize(rootBounds.width, rootBounds.height, false);
        surface.updateScrolledAreaSize();
        SceneView view = surface.getCurrentSceneView();
        if (view != null) {
            int deltaX = Coordinates.getSwingDimension(view, root.getDrawX() - drawX);
            int deltaY = Coordinates.getSwingDimension(view, root.getDrawY() - drawY);
            Point point = surface.getScrollPosition();
            surface.setScrollPosition(point.x - deltaX, point.y - deltaY);
        }
    }

    @Override
    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = this.getDesignSurface().getCurrentNavigation();
        if (nlComponent == null) {
            NavSceneManager.$$$reportNull$$$0(7);
        }
        return nlComponent;
    }

    @Override
    @Nullable
    protected SceneComponent createHierarchy(@NotNull NlComponent component) {
        if (component == null) {
            NavSceneManager.$$$reportNull$$$0(8);
        }
        boolean shouldCreateHierarchy = false;
        if (NavComponentHelperKt.isAction(component)) {
            shouldCreateHierarchy = this.shouldCreateActionHierarchy(component);
        } else {
            NavigationSchema.DestinationType destinationType = NavComponentHelperKt.getDestinationType(component);
            if (destinationType != null && destinationType != NavigationSchema.DestinationType.OTHER) {
                shouldCreateHierarchy = this.shouldCreateDestinationHierarchy(component);
            }
        }
        if (!shouldCreateHierarchy) {
            return null;
        }
        SceneComponent hierarchy = super.createHierarchy(component);
        if (hierarchy != null && component == this.getRoot()) {
            this.moveGlobalActions(hierarchy);
        }
        return hierarchy;
    }

    private boolean shouldCreateDestinationHierarchy(@NotNull NlComponent component) {
        if (component == null) {
            NavSceneManager.$$$reportNull$$$0(9);
        }
        return component == this.getRoot() || component.getParent() == this.getRoot();
    }

    private boolean shouldCreateActionHierarchy(@NotNull NlComponent component) {
        if (component == null) {
            NavSceneManager.$$$reportNull$$$0(10);
        }
        ActionType actionType = NavComponentHelperKt.getActionType(component);
        switch (actionType) {
            case GLOBAL: {
                return component.getParent() == this.getRoot();
            }
            case EXIT: {
                NlComponent parent = component.getParent();
                return parent != null && parent.getParent() == this.getRoot();
            }
        }
        return false;
    }

    private void moveGlobalActions(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(11);
        }
        HashMap<String, SceneComponent> destinationMap = new HashMap<String, SceneComponent>();
        for (SceneComponent component : root.getChildren()) {
            NlComponent child = component.getNlComponent();
            if (!NavComponentHelperKt.isDestination(child)) continue;
            destinationMap.put(child.getId(), component);
        }
        ArrayList<SceneComponent> globalActions = new ArrayList<SceneComponent>();
        for (SceneComponent component : root.getChildren()) {
            NlComponent child = component.getNlComponent();
            if (!NavComponentHelperKt.isAction(child)) continue;
            globalActions.add(component);
        }
        for (SceneComponent globalAction : globalActions) {
            String destination = NavComponentHelperKt.getActionDestinationId(globalAction.getNlComponent());
            SceneComponent parent = (SceneComponent)destinationMap.get(destination);
            if (parent == null) {
                this.getScene().removeComponent(globalAction);
                continue;
            }
            parent.addChild(globalAction);
        }
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component) {
        if (component == null) {
            NavSceneManager.$$$reportNull$$$0(12);
        }
        TemporarySceneComponent temporarySceneComponent = new TemporarySceneComponent(this.getScene(), component);
        if (temporarySceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(13);
        }
        return temporarySceneComponent;
    }

    @Override
    public void requestRender() {
        boolean wasEmpty = this.getScene().getRoot() == null || this.getScene().getRoot().getChildCount() == 0;
        this.update();
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            root.updateTargets();
            this.layoutAll(root);
        }
        if (wasEmpty) {
            this.getDesignSurface().zoomToFit();
        }
    }

    private void layoutAll(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(14);
        }
        List<SceneComponent> destinations = new ArrayList<SceneComponent>();
        for (SceneComponent child : root.getChildren()) {
            if (!NavComponentHelperKt.isDestination(child.getNlComponent())) continue;
            destinations.add(child);
        }
        for (SceneComponent destination : destinations) {
            destination.setPosition(0, 0);
        }
        for (NavSceneLayoutAlgorithm algorithm : this.myLayoutAlgorithms) {
            List<SceneComponent> remaining = algorithm.layout(destinations);
            destinations.removeAll(remaining);
            if (!algorithm.canSave()) {
                this.save(destinations);
            }
            if (remaining.isEmpty()) break;
            destinations = remaining;
        }
        HashSet<String> connectedActionSources = new HashSet<String>();
        HashSet<String> connectedActionDestinations = new HashSet<String>();
        NavSceneManager.getConnectedActions(root.getNlComponent(), connectedActionSources, connectedActionDestinations);
        for (SceneComponent component : root.getChildren()) {
            NlComponent nlComponent = component.getNlComponent();
            if (!NavComponentHelperKt.isDestination(nlComponent)) continue;
            ArrayList<SceneComponent> globalActions = new ArrayList<SceneComponent>();
            ArrayList<SceneComponent> exitActions = new ArrayList<SceneComponent>();
            for (SceneComponent child : component.getChildren()) {
                switch (NavComponentHelperKt.getActionType(child.getNlComponent())) {
                    case GLOBAL: {
                        globalActions.add(child);
                        break;
                    }
                    case EXIT: {
                        exitActions.add(child);
                        break;
                    }
                }
            }
            String id = nlComponent.getId();
            NavSceneManager.layoutGlobalActions(component, globalActions, connectedActionDestinations.contains(id));
            NavSceneManager.layoutExitActions(component, exitActions, connectedActionSources.contains(id));
        }
    }

    public void save(@NotNull List<SceneComponent> components) {
        if (components == null) {
            NavSceneManager.$$$reportNull$$$0(15);
        }
        if (this.mySavingLayoutAlgorithm != null) {
            components.forEach(this.mySavingLayoutAlgorithm::save);
        }
    }

    @Nullable
    public Object getPositionData(@NotNull SceneComponent component) {
        if (component == null) {
            NavSceneManager.$$$reportNull$$$0(16);
        }
        if (this.mySavingLayoutAlgorithm != null) {
            return this.mySavingLayoutAlgorithm.getPositionData(component);
        }
        return null;
    }

    public void restorePositionData(@NotNull SceneComponent component, @NotNull Object positionData) {
        if (component == null) {
            NavSceneManager.$$$reportNull$$$0(17);
        }
        if (positionData == null) {
            NavSceneManager.$$$reportNull$$$0(18);
        }
        if (this.mySavingLayoutAlgorithm != null) {
            this.mySavingLayoutAlgorithm.restorePositionData(component, positionData);
        }
    }

    private static void getConnectedActions(@NotNull NlComponent root, @NotNull HashSet<String> connectedActionSources, @NotNull HashSet<String> connectedActionDestinations) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(19);
        }
        if (connectedActionSources == null) {
            NavSceneManager.$$$reportNull$$$0(20);
        }
        if (connectedActionDestinations == null) {
            NavSceneManager.$$$reportNull$$$0(21);
        }
        HashSet<String> children = new HashSet<String>();
        for (NlComponent child : root.getChildren()) {
            children.add(child.getId());
        }
        for (NlComponent component : root.getChildren()) {
            if (!NavComponentHelperKt.isDestination(component)) continue;
            component.flatten().filter(NavComponentHelperKt::isAction).forEach(action2 -> {
                String destinationId;
                if (connectedActionSources == null) {
                    NavSceneManager.$$$reportNull$$$0(36);
                }
                if (connectedActionDestinations == null) {
                    NavSceneManager.$$$reportNull$$$0(37);
                }
                if (children.contains(destinationId = NavComponentHelperKt.getEffectiveDestinationId(action2))) {
                    connectedActionSources.add(component.getId());
                    if (!NavComponentHelperKt.isSelfAction(action2)) {
                        connectedActionDestinations.add(destinationId);
                    }
                }
            });
        }
    }

    private static void layoutGlobalActions(@NotNull SceneComponent destination, @NotNull ArrayList<SceneComponent> globalActions, Boolean skip) {
        if (destination == null) {
            NavSceneManager.$$$reportNull$$$0(22);
        }
        if (globalActions == null) {
            NavSceneManager.$$$reportNull$$$0(23);
        }
        NavSceneManager.layoutActions(destination, globalActions, skip, destination.getDrawX() - GLOBAL_ACTION_WIDTH - GLOBAL_ACTION_HORIZONTAL_PADDING);
    }

    private static void layoutExitActions(@NotNull SceneComponent source, @NotNull ArrayList<SceneComponent> exitActions, Boolean skip) {
        if (source == null) {
            NavSceneManager.$$$reportNull$$$0(24);
        }
        if (exitActions == null) {
            NavSceneManager.$$$reportNull$$$0(25);
        }
        NavSceneManager.layoutActions(source, exitActions, skip, source.getDrawX() + source.getDrawWidth() + EXIT_ACTION_HORIZONTAL_PADDING);
    }

    private static void layoutActions(SceneComponent component, ArrayList<SceneComponent> actions2, Boolean skip, int x) {
        int count = actions2.size();
        if (count == 0) {
            return;
        }
        if (skip.booleanValue()) {
            actions2.add((count + 1) / 2, null);
            ++count;
        }
        int y = component.getDrawY() + component.getDrawHeight() / 2 - ACTION_HEIGHT / 2 - count / 2 * (ACTION_HEIGHT + ACTION_VERTICAL_PADDING);
        for (SceneComponent action2 : actions2) {
            if (action2 != null) {
                action2.setPosition(x, y);
            }
            y += ACTION_HEIGHT + ACTION_VERTICAL_PADDING;
        }
    }

    @Override
    public void layout(boolean animate) {
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            this.updateRootBounds(root);
        }
        this.getDesignSurface().updateScrolledAreaSize();
        this.getScene().needsRebuildList();
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        if (this.myDecoratorFactory == null) {
            this.myDecoratorFactory = new NavSceneDecoratorFactory(this.getSchema());
        }
        SceneDecoratorFactory sceneDecoratorFactory = this.myDecoratorFactory;
        if (sceneDecoratorFactory == null) {
            NavSceneManager.$$$reportNull$$$0(26);
        }
        return sceneDecoratorFactory;
    }

    @Override
    public Map<Object, PropertiesMap> getDefaultProperties() {
        return ImmutableMap.of();
    }

    public static void updateHierarchy(@NotNull NlModel model, @Nullable NlModel newModel) {
        if (model == null) {
            NavSceneManager.$$$reportNull$$$0(27);
        }
        Object roots = ImmutableList.of();
        XmlTag newRoot = AndroidPsiUtils.getRootTagSafely(model.getFile());
        if (newModel != null) {
            newRoot = AndroidPsiUtils.getRootTagSafely(newModel.getFile());
            roots = NavSceneManager.buildTree((XmlTag[])newModel.getComponents().stream().map(NlComponent::getTag).toArray(XmlTag[]::new));
        }
        if (newRoot != null) {
            model.syncWithPsi(newRoot, (List<NlModel.TagSnapshotTreeNode>)roots);
        }
    }

    public boolean isEmpty() {
        return this.getDesignSurface().getCurrentNavigation().getChildren().stream().noneMatch(c -> NavComponentHelperKt.isDestination(c));
    }

    private static List<NlModel.TagSnapshotTreeNode> buildTree(XmlTag[] roots) {
        ArrayList<NlModel.TagSnapshotTreeNode> result2 = new ArrayList<NlModel.TagSnapshotTreeNode>();
        for (final XmlTag root : roots) {
            NlModel.TagSnapshotTreeNode node = new NlModel.TagSnapshotTreeNode(){

                @Override
                public TagSnapshot getTagSnapshot() {
                    return TagSnapshot.createTagSnapshot(root, null);
                }

                @Override
                @NotNull
                public List<NlModel.TagSnapshotTreeNode> getChildren() {
                    List list = NavSceneManager.buildTree(root.getSubTags());
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/naveditor/scene/NavSceneManager$1", "getChildren"));
                }
            };
            result2.add(node);
        }
        return result2;
    }

    @NotNull
    public static Rectangle getBoundingBox(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(28);
        }
        Rectangle rectangle = NavSceneManager.getBoundingBox(root.getChildren());
        if (rectangle == null) {
            NavSceneManager.$$$reportNull$$$0(29);
        }
        return rectangle;
    }

    @NotNull
    public static Rectangle getBoundingBox(@NotNull List<SceneComponent> components) {
        if (components == null) {
            NavSceneManager.$$$reportNull$$$0(30);
        }
        Rectangle boundingBox = new Rectangle(0, 0, -1, -1);
        Rectangle childRect = new Rectangle();
        for (SceneComponent child : components) {
            child.fillDrawRect(0L, childRect);
            if (boundingBox.width < 0) {
                boundingBox.setBounds(childRect);
                continue;
            }
            boundingBox.add(childRect);
        }
        boundingBox.grow(BOUNDING_BOX_PADDING, BOUNDING_BOX_PADDING);
        Rectangle rectangle = boundingBox;
        if (rectangle == null) {
            NavSceneManager.$$$reportNull$$$0(31);
        }
        return rectangle;
    }

    @NotNull
    public NavigationSchema getSchema() {
        if (this.mySchema == null) {
            this.mySchema = NavigationSchema.get(this.getModel().getFacet());
        }
        NavigationSchema navigationSchema = this.mySchema;
        if (navigationSchema == null) {
            NavSceneManager.$$$reportNull$$$0(32);
        }
        return navigationSchema;
    }

    @Override
    @NotNull
    public HitProvider getHitProvider(@NotNull NlComponent component) {
        if (component == null) {
            NavSceneManager.$$$reportNull$$$0(33);
        }
        if (NavComponentHelperKt.getSupportsActions(component)) {
            HitProvider hitProvider = this.myNavDestinationHitProvider;
            if (hitProvider == null) {
                NavSceneManager.$$$reportNull$$$0(34);
            }
            return hitProvider;
        }
        HitProvider hitProvider = super.getHitProvider(component);
        if (hitProvider == null) {
            NavSceneManager.$$$reportNull$$$0(35);
        }
        return hitProvider;
    }

    static {
        ACTION_HEIGHT = ACTION_ARROW_PERPENDICULAR = JBUI.scale((int)12);
        ACTION_VERTICAL_PADDING = JBUI.scale((int)6);
        GLOBAL_ACTION_LINE_LENGTH = JBUI.scale((int)8);
        GLOBAL_ACTION_WIDTH = ACTION_ARROW_PARALLEL + GLOBAL_ACTION_LINE_LENGTH;
        GLOBAL_ACTION_HORIZONTAL_PADDING = JBUI.scale((int)8);
        EXIT_ACTION_LINE_LENGTH = JBUI.scale((int)14);
        EXIT_ACTION_WIDTH = ACTION_ARROW_PARALLEL + EXIT_ACTION_LINE_LENGTH;
        EXIT_ACTION_HORIZONTAL_PADDING = JBUI.scale((int)2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 13: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 13: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 13: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/NavSceneManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionData";
                break;
            }
            case 20: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedActionSources";
                break;
            }
            case 21: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedActionDestinations";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalActions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/NavSceneManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateSceneView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundingBox";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 13: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "postUpdateFromComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRootBounds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateDestinationHierarchy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateActionHierarchy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveGlobalActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "layoutAll";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPositionData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "restorePositionData";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getConnectedActions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "layoutGlobalActions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "layoutExitActions";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBoundingBox";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getHitProvider";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConnectedActions$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 13: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            NavSceneManager.updateHierarchy(model, model);
            NavSceneManager.this.getDesignSurface().refreshRoot();
            NavSceneManager.this.requestRender();
            model.notifyListenersModelUpdateComplete();
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            boolean previous = NavSceneManager.this.getScene().isAnimated();
            UIUtil.invokeLaterIfNeeded(() -> {
                NavSceneManager.this.getScene().setAnimated(animate);
                NavSceneManager.this.update();
                NavSceneManager.this.getScene().setAnimated(previous);
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            NavSceneManager.updateHierarchy(model, model);
            NavSceneManager.this.requestRender();
        }

        @Override
        public void modelDeactivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/naveditor/scene/NavSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelActivated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDeactivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

