/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThumbnailManager
extends AndroidFacetScopedService {
    private static final Key<ThumbnailManager> KEY = Key.create((String)ThumbnailManager.class.getName());
    private final Table<VirtualFile, Configuration, SoftReference<BufferedImage>> myImages;
    private final Table<VirtualFile, Configuration, Long> myRenderVersions;
    private final Table<VirtualFile, Configuration, Long> myRenderModStamps;
    private final LocalResourceRepository myResourceRepository;
    @GuardedBy(value="DISPOSAL_LOCK")
    private final Map<VirtualFile, CompletableFuture<BufferedImage>> myPendingFutures;
    @GuardedBy(value="DISPOSAL_LOCK")
    private boolean myDisposed;
    private final Object DISPOSAL_LOCK;

    @NotNull
    public static ThumbnailManager getInstance(@NotNull AndroidFacet facet) {
        ThumbnailManager manager;
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(0);
        }
        if ((manager = (ThumbnailManager)facet.getUserData(KEY)) == null) {
            manager = new ThumbnailManager(facet);
            ThumbnailManager.setInstance(facet, manager);
        }
        ThumbnailManager thumbnailManager = manager;
        if (thumbnailManager == null) {
            ThumbnailManager.$$$reportNull$$$0(1);
        }
        return thumbnailManager;
    }

    public static void setInstance(@NotNull AndroidFacet facet, @Nullable ThumbnailManager manager) {
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(2);
        }
        facet.putUserData(KEY, manager);
    }

    protected ThumbnailManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(3);
        }
        super(facet);
        this.myImages = HashBasedTable.create();
        this.myRenderVersions = HashBasedTable.create();
        this.myRenderModStamps = HashBasedTable.create();
        this.myPendingFutures = new HashMap<VirtualFile, CompletableFuture<BufferedImage>>();
        this.DISPOSAL_LOCK = new Object();
        this.myResourceRepository = ResourceRepositoryManager.getAppResources(facet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDispose() {
        CompletableFuture[] futures;
        Object object = this.DISPOSAL_LOCK;
        synchronized (object) {
            this.myDisposed = true;
            futures = this.myPendingFutures.values().toArray(new CompletableFuture[0]);
            this.myPendingFutures.clear();
        }
        try {
            CompletableFuture.allOf(futures).get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletableFuture<BufferedImage> getThumbnail(@NotNull XmlFile xmlFile, @NotNull Configuration configuration) {
        VirtualFile file;
        SoftReference cachedReference;
        BufferedImage cached;
        if (xmlFile == null) {
            ThumbnailManager.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            ThumbnailManager.$$$reportNull$$$0(5);
        }
        BufferedImage bufferedImage = cached = (cachedReference = (SoftReference)this.myImages.get((Object)(file = xmlFile.getVirtualFile()), (Object)configuration)) != null ? (BufferedImage)cachedReference.get() : null;
        if (cached != null && ((Long)this.myRenderVersions.get((Object)file, (Object)configuration)).longValue() == this.myResourceRepository.getModificationCount() && ((Long)this.myRenderModStamps.get((Object)file, (Object)configuration)).longValue() == file.getModificationStamp()) {
            return CompletableFuture.completedFuture(cached);
        }
        CompletableFuture<BufferedImage> result2 = new CompletableFuture<BufferedImage>();
        Object object = this.DISPOSAL_LOCK;
        synchronized (object) {
            if (this.myDisposed) {
                return null;
            }
            CompletableFuture<BufferedImage> inProgress = this.myPendingFutures.get(file);
            if (inProgress != null) {
                return inProgress;
            }
            this.myPendingFutures.put(file, result2);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (xmlFile == null) {
                ThumbnailManager.$$$reportNull$$$0(13);
            }
            if (configuration == null) {
                ThumbnailManager.$$$reportNull$$$0(14);
            }
            try {
                Object object = this.DISPOSAL_LOCK;
                synchronized (object) {
                    if (this.myDisposed) {
                        result2.complete(null);
                        return;
                    }
                }
                try {
                    result2.complete(this.getImage(xmlFile, file, configuration));
                }
                catch (Exception e) {
                    result2.completeExceptionally(e);
                }
                finally {
                    Object e = this.DISPOSAL_LOCK;
                    synchronized (e) {
                        this.myPendingFutures.remove(file);
                    }
                }
            }
            catch (Throwable t) {
                result2.completeExceptionally(t);
                Object object = this.DISPOSAL_LOCK;
                synchronized (object) {
                    this.myPendingFutures.remove(file);
                }
            }
        });
        return result2;
    }

    @Nullable
    private BufferedImage getImage(@NotNull XmlFile xmlFile, @NotNull VirtualFile file, @NotNull Configuration configuration) throws InterruptedException, ExecutionException {
        if (xmlFile == null) {
            ThumbnailManager.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ThumbnailManager.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            ThumbnailManager.$$$reportNull$$$0(8);
        }
        RenderService renderService = RenderService.getInstance(this.getModule().getProject());
        RenderTask task = this.createTask(this.getFacet(), xmlFile, configuration, renderService);
        ListenableFuture<RenderResult> renderResult = null;
        if (task != null) {
            renderResult = task.render();
        }
        BufferedImage image = null;
        if (renderResult != null) {
            image = ((RenderResult)renderResult.get()).getRenderedImage().getCopy();
            this.myImages.put((Object)file, (Object)configuration, (Object)new SoftReference((Object)image));
            this.myRenderVersions.put((Object)file, (Object)configuration, (Object)this.myResourceRepository.getModificationCount());
            this.myRenderModStamps.put((Object)file, (Object)configuration, (Object)file.getModificationStamp());
        }
        return image;
    }

    @Nullable
    protected RenderTask createTask(@NotNull AndroidFacet facet, @NotNull XmlFile file, @NotNull Configuration configuration, RenderService renderService) {
        RenderTask task;
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ThumbnailManager.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            ThumbnailManager.$$$reportNull$$$0(11);
        }
        if ((task = renderService.createTask(facet, (PsiFile)file, configuration)) != null) {
            task.setDecorations(false);
        }
        return task;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(12);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/ThumbnailManager";
                break;
            }
            case 4: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/ThumbnailManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getThumbnail";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImage";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getThumbnail$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

