/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.naveditor.scene.NavColorSet;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.draw.DrawNavScreenKt;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B!\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0019\u001a\u00020\u0004H\u0016R\u0018\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawNavScreen;", "Lcom/android/tools/idea/naveditor/scene/draw/NavBaseDrawCommand;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "rectangle", "Ljava/awt/Rectangle;", "image", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/Rectangle;Ljava/util/concurrent/CompletableFuture;)V", "drawText", "", "text1", "text2", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "getLevel", "", "onPaint", "serialize", "intellij.android.designer"})
public final class DrawNavScreen
extends NavBaseDrawCommand {
    private final Rectangle rectangle;
    private final CompletableFuture<BufferedImage> image;

    @Override
    public int getLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, DrawCommandSerializationHelperKt.rectToString(this.rectangle));
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        NavDrawHelperKt.setRenderingHints(g);
        g.clipRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        if (this.image == null || this.image.isDone() && this.image.get() == null) {
            this.drawText("Preview", "Unavailable", g, sceneContext);
        } else if (this.image.isDone()) {
            g.drawImage(this.image.get(), this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height, null);
        } else {
            this.drawText("Loading...", null, g, sceneContext);
            this.image.thenRun(new Runnable(sceneContext){
                final /* synthetic */ SceneContext $sceneContext;

                public final void run() {
                    this.$sceneContext.repaint();
                }
                {
                    this.$sceneContext = sceneContext;
                }
            });
        }
    }

    private final void drawText(String text1, String text2, Graphics2D g, SceneContext sceneContext) {
        g.setColor((Color)NavColorSet.NO_PREVIEW_BACKGROUND_COLOR);
        g.fillRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        g.setColor((Color)NavColorSet.NO_PREVIEW_TEXT_COLOR);
        g.setFont(new Font("Default", 0, sceneContext.getSwingDimension(DrawNavScreenKt.access$getFONT_SIZE$p())));
        int x = this.rectangle.x + (this.rectangle.width - g.getFontMetrics().stringWidth(text1)) / 2;
        int padding = sceneContext.getSwingDimension(DrawNavScreenKt.access$getTEXT_PADDING$p());
        int y = this.rectangle.y + (this.rectangle.height - padding) / 2;
        g.drawString(text1, x, y);
        if (text2 != null) {
            x = this.rectangle.x + (this.rectangle.width - g.getFontMetrics().stringWidth(text2)) / 2;
            FontMetrics fontMetrics = g.getFontMetrics();
            Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"g.fontMetrics");
            g.drawString(text2, x, y += fontMetrics.getAscent() + padding);
        }
    }

    public DrawNavScreen(@NotNull Rectangle rectangle, @Nullable CompletableFuture<BufferedImage> image) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        this.rectangle = rectangle;
        this.image = image;
    }

    private DrawNavScreen(String[] sp) {
        this(DrawCommandSerializationHelperKt.stringToRect(sp[0]), null);
    }

    public DrawNavScreen(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 1));
    }
}

