/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.LerpValue;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCircle;
import com.android.tools.idea.common.scene.draw.DrawFilledCircle;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandleDrag;
import com.android.tools.idea.naveditor.scene.targets.NavBaseTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.util.List;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionHandleTarget
extends NavBaseTarget {
    private static final int DURATION = 200;
    private static final int STROKE_WIDTH = 2;
    private static String DRAG_CREATE_IN_PROGRESS = "DRAG_CREATE_IN_PROGRESS";
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private HandleState myHandleState;
    private boolean myIsDragging;

    public ActionHandleTarget(@NotNull SceneComponent component) {
        if (component == null) {
            ActionHandleTarget.$$$reportNull$$$0(0);
        }
        super(component);
        this.myIsDragging = false;
        this.myHandleState = this.calculateState();
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            ActionHandleTarget.$$$reportNull$$$0(1);
        }
        int x = r;
        if (NavComponentHelperKt.isFragment(this.getComponent().getNlComponent())) {
            x += NavDrawHelperKt.ACTION_HANDLE_OFFSET;
        }
        this.layoutCircle(x, t + (b - t) / 2, this.myHandleState.myOuterRadius);
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        Scene scene = this.myComponent.getScene();
        scene.getDesignSurface().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.getComponent().getNlComponent()));
        this.myIsDragging = true;
        scene.needsRebuildList();
        this.myComponent.getParent().getNlComponent().putClientProperty(DRAG_CREATE_IN_PROGRESS, true);
        this.getComponent().setDragging(true);
        scene.repaint();
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ActionHandleTarget.$$$reportNull$$$0(2);
        }
        this.myIsDragging = false;
        this.myComponent.getScene().needsRebuildList();
        this.myComponent.getParent().getNlComponent().removeClientProperty(DRAG_CREATE_IN_PROGRESS);
        this.getComponent().setDragging(false);
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Nullable
    public NlComponent createAction(@NotNull SceneComponent destination) {
        if (destination == null) {
            ActionHandleTarget.$$$reportNull$$$0(3);
        }
        if (this.mIsOver) {
            return null;
        }
        NlComponent destinationNlComponent = destination.getNlComponent();
        NavigationSchema schema = NavigationSchema.get(destinationNlComponent.getModel().getFacet());
        if (schema.getDestinationType(destinationNlComponent.getTagName()) == null) {
            return null;
        }
        NlComponent myNlComponent = this.getComponent().getNlComponent();
        return (NlComponent)WriteCommandAction.runWriteCommandAction((Project)myNlComponent.getModel().getProject(), () -> NavComponentHelperKt.createAction(myNlComponent, destinationNlComponent.getId()));
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Color color;
        HandleState newState;
        if (list == null) {
            ActionHandleTarget.$$$reportNull$$$0(4);
        }
        if (sceneContext == null) {
            ActionHandleTarget.$$$reportNull$$$0(5);
        }
        if ((newState = this.calculateState()) == HandleState.INVISIBLE && this.myHandleState == HandleState.INVISIBLE) {
            return;
        }
        Point center = new Point(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext));
        int initialRadius = sceneContext.getSwingDimension(this.myHandleState.myOuterRadius);
        int finalRadius = sceneContext.getSwingDimension(newState.myOuterRadius);
        int duration = Math.abs(200 * (finalRadius - initialRadius) / NavDrawHelperKt.OUTER_RADIUS_LARGE);
        ColorSet colorSet = sceneContext.getColorSet();
        list.add(new DrawFilledCircle(6, center, colorSet.getBackground(), new LerpValue(initialRadius, finalRadius, duration)));
        initialRadius = sceneContext.getSwingDimension(this.myHandleState.myInnerRadius);
        finalRadius = sceneContext.getSwingDimension(newState.myInnerRadius);
        Color color2 = color = this.getComponent().isSelected() ? colorSet.getSelectedFrames() : colorSet.getSubduedFrames();
        if (this.myIsDragging) {
            list.add(new DrawFilledCircle(7, center, color, finalRadius));
            list.add(new DrawActionHandleDrag(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext)));
        } else {
            list.add(new DrawCircle(7, center, color, STROKE, new LerpValue(initialRadius, finalRadius, duration)));
        }
        this.myHandleState = newState;
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (transform2 == null) {
            ActionHandleTarget.$$$reportNull$$$0(6);
        }
        if (picker == null) {
            ActionHandleTarget.$$$reportNull$$$0(7);
        }
        picker.addCircle(this, 0, this.getSwingCenterX(transform2), this.getSwingCenterY(transform2), transform2.getSwingDimension(NavDrawHelperKt.OUTER_RADIUS_LARGE));
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    private HandleState calculateState() {
        if (this.myIsDragging) {
            return HandleState.SMALL;
        }
        if (this.myComponent.getScene().getDesignSurface().getInteractionManager().isInteractionInProgress()) {
            return HandleState.INVISIBLE;
        }
        if (this.mIsOver) {
            return HandleState.LARGE;
        }
        if (this.getComponent().getDrawState() == SceneComponent.DrawState.HOVER) {
            return HandleState.SMALL;
        }
        if (this.getComponent().isSelected() && this.myComponent.getScene().getSelection().size() == 1) {
            return HandleState.SMALL;
        }
        return HandleState.INVISIBLE;
    }

    public static boolean isDragCreateInProgress(@NotNull NlComponent component) {
        NlComponent parent;
        if (component == null) {
            ActionHandleTarget.$$$reportNull$$$0(8);
        }
        return (parent = component.getParent()) != null && parent.getClientProperty(DRAG_CREATE_IN_PROGRESS) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/naveditor/scene/targets/ActionHandleTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addHit";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragCreateInProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum HandleState {
        INVISIBLE(0, 0),
        SMALL(NavDrawHelperKt.INNER_RADIUS_SMALL, NavDrawHelperKt.OUTER_RADIUS_SMALL),
        LARGE(NavDrawHelperKt.INNER_RADIUS_LARGE, NavDrawHelperKt.OUTER_RADIUS_LARGE);

        private final int myInnerRadius;
        private final int myOuterRadius;

        private HandleState(int innerRadius, int outerRadius) {
            this.myInnerRadius = innerRadius;
            this.myOuterRadius = outerRadius;
        }
    }
}

