/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.ArrowDirection;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawArrow;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavColorSet;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.draw.DrawAction;
import com.android.tools.idea.naveditor.scene.draw.DrawSelfAction;
import com.google.common.collect.ImmutableList;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ActionTarget
extends BaseTarget {
    private Rectangle mySourceRect;
    private Rectangle myDestRect;
    private final NlComponent myNlComponent;
    private final SceneComponent myDestination;
    private boolean myHighlighted;
    private static final int ACTION_PADDING = JBUI.scale((int)8);
    private static final int CONTROL_POINT_THRESHOLD = JBUI.scale((int)120);
    private static final ConnectionDirection START_DIRECTION = ConnectionDirection.RIGHT;

    public ActionTarget(@NotNull SceneComponent component, @NotNull SceneComponent destination, @NotNull NlComponent actionComponent) {
        if (component == null) {
            ActionTarget.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            ActionTarget.$$$reportNull$$$0(1);
        }
        if (actionComponent == null) {
            ActionTarget.$$$reportNull$$$0(2);
        }
        this.myHighlighted = false;
        this.setComponent(component);
        this.myNlComponent = actionComponent;
        this.myDestination = destination;
    }

    public String getId() {
        return this.myNlComponent.getId();
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    public void setHighlighted(boolean highlighted) {
        this.myHighlighted = highlighted;
    }

    public boolean isHighlighted() {
        return this.myHighlighted;
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ActionTarget.$$$reportNull$$$0(3);
        }
        this.myComponent.getScene().getDesignSurface().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.myNlComponent));
    }

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        if (context == null) {
            ActionTarget.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Color color;
        if (list == null) {
            ActionTarget.$$$reportNull$$$0(5);
        }
        if (sceneContext == null) {
            ActionTarget.$$$reportNull$$$0(6);
        }
        Rectangle sourceRect = Coordinates.getSwingRect(sceneContext, this.getComponent().fillRect(null));
        String sourceId = this.getComponent().getId();
        if (sourceId == null) {
            return;
        }
        String targetId = NavComponentHelperKt.getEffectiveDestinationId(this.myNlComponent);
        if (targetId == null) {
            return;
        }
        this.myDestRect = Coordinates.getSwingRect(sceneContext, this.myDestination.fillRect(null));
        this.mySourceRect = sourceRect;
        boolean selected = this.getComponent().getScene().getSelection().contains(this.myNlComponent);
        NavColorSet colorSet = (NavColorSet)sceneContext.getColorSet();
        Color color2 = selected ? colorSet.getSelectedActions() : (color = this.mIsOver || this.myHighlighted ? colorSet.getHighlightedActions() : colorSet.getActions());
        if (sourceId.equals(targetId)) {
            this.renderSelfAction(list, sceneContext, color);
            return;
        }
        ConnectionType connectionType = ConnectionType.NORMAL;
        if (NavComponentHelperKt.getActionType(this.myNlComponent) == ActionType.EXIT) {
            connectionType = ConnectionType.EXIT;
        }
        DrawAction.buildDisplayList(list, connectionType, sourceRect, this.myDestRect, selected ? DrawAction.DrawMode.SELECTED : (this.mIsOver || this.myHighlighted ? DrawAction.DrawMode.HOVER : DrawAction.DrawMode.NORMAL));
        ConnectionDirection direction = ActionTarget.getDestinationDirection(sourceRect, this.myDestRect);
        Point arrowPoint = ActionTarget.getArrowPoint(sceneContext, this.myDestRect, direction);
        ArrowDirection arrowDirection = ActionTarget.getArrowDirection(direction);
        Rectangle arrowRectangle = ActionTarget.getArrowRectangle(sceneContext, arrowPoint, direction);
        list.add(new DrawArrow(2, arrowDirection, arrowRectangle, color));
    }

    @NotNull
    public NlComponent getActionComponent() {
        NlComponent nlComponent = this.myNlComponent;
        if (nlComponent == null) {
            ActionTarget.$$$reportNull$$$0(7);
        }
        return nlComponent;
    }

    private void renderSelfAction(@NotNull DisplayList list, @NotNull SceneContext sceneContext, Color color) {
        if (list == null) {
            ActionTarget.$$$reportNull$$$0(8);
        }
        if (sceneContext == null) {
            ActionTarget.$$$reportNull$$$0(9);
        }
        Point start = ActionTarget.getStartPoint(this.mySourceRect);
        Point arrowPoint = ActionTarget.getArrowPoint(sceneContext, this.myDestRect, ConnectionDirection.BOTTOM);
        arrowPoint.x += this.myDestRect.width / 2 + sceneContext.getSwingDimension(NavDrawHelperKt.SELF_ACTION_LENGTHS[0] - NavDrawHelperKt.SELF_ACTION_LENGTHS[2]);
        Rectangle arrowRectangle = ActionTarget.getArrowRectangle(sceneContext, arrowPoint, ConnectionDirection.BOTTOM);
        Point end = new Point(arrowRectangle.x + arrowRectangle.width / 2, arrowRectangle.y + arrowRectangle.height - 1);
        list.add(new DrawArrow(2, ArrowDirection.UP, arrowRectangle, color));
        list.add(new DrawSelfAction(start, end, color));
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (transform2 == null) {
            ActionTarget.$$$reportNull$$$0(10);
        }
        if (picker == null) {
            ActionTarget.$$$reportNull$$$0(11);
        }
        if (this.mySourceRect == null || this.myDestRect == null) {
            return;
        }
        String sourceId = this.getComponent().getId();
        if (sourceId == null) {
            return;
        }
        String targetId = NavComponentHelperKt.getEffectiveDestinationId(this.myNlComponent);
        if (targetId == null) {
            return;
        }
        if (sourceId.equals(targetId)) {
            Point[] points = ActionTarget.getSelfActionPoints(this.mySourceRect, transform2);
            for (int i = 1; i < points.length; ++i) {
                picker.addLine(this, 0, points[i - 1].x, points[i - 1].y, points[i].x, points[i].y, 5);
            }
            return;
        }
        CurvePoints points = ActionTarget.getCurvePoints(this.mySourceRect, this.myDestRect, transform2);
        picker.addCurveTo(this, 0, points.p1.x, points.p1.y, points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y, 10);
    }

    @NotNull
    public static CurvePoints getCurvePoints(@NotNull Rectangle source, @NotNull Rectangle dest, SceneContext sceneContext) {
        if (source == null) {
            ActionTarget.$$$reportNull$$$0(12);
        }
        if (dest == null) {
            ActionTarget.$$$reportNull$$$0(13);
        }
        ConnectionDirection destDirection = ActionTarget.getDestinationDirection(source, dest);
        CurvePoints result2 = new CurvePoints();
        result2.dir = destDirection;
        result2.p1 = ActionTarget.getStartPoint(source);
        result2.p4 = ActionTarget.getEndPoint(sceneContext, dest, destDirection);
        result2.p2 = ActionTarget.getControlPoint(sceneContext, result2.p1, result2.p4, START_DIRECTION);
        result2.p3 = ActionTarget.getControlPoint(sceneContext, result2.p4, result2.p1, destDirection);
        CurvePoints curvePoints = result2;
        if (curvePoints == null) {
            ActionTarget.$$$reportNull$$$0(14);
        }
        return curvePoints;
    }

    @NotNull
    public static Point[] getSelfActionPoints(@NotNull Rectangle rect, @NotNull SceneContext sceneContext) {
        if (rect == null) {
            ActionTarget.$$$reportNull$$$0(15);
        }
        if (sceneContext == null) {
            ActionTarget.$$$reportNull$$$0(16);
        }
        Point start = ActionTarget.getStartPoint(rect);
        Point end = ActionTarget.getSelfActionEndPoint(rect, sceneContext);
        Point[] pointArray = NavDrawHelperKt.selfActionPoints(start, end, sceneContext);
        if (pointArray == null) {
            ActionTarget.$$$reportNull$$$0(17);
        }
        return pointArray;
    }

    @NotNull
    public static Point getSelfActionEndPoint(@NotNull Rectangle rect, @NotNull SceneContext sceneContext) {
        if (rect == null) {
            ActionTarget.$$$reportNull$$$0(18);
        }
        if (sceneContext == null) {
            ActionTarget.$$$reportNull$$$0(19);
        }
        Point end = ActionTarget.getEndPoint(sceneContext, rect, ConnectionDirection.BOTTOM);
        end.x += rect.width / 2 + sceneContext.getSwingDimension(NavDrawHelperKt.SELF_ACTION_LENGTHS[0] - NavDrawHelperKt.SELF_ACTION_LENGTHS[2]);
        Point point = end;
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(20);
        }
        return point;
    }

    @NotNull
    private static Point getArrowPoint(@NotNull SceneContext context, @NotNull Rectangle rectangle, @NotNull ConnectionDirection direction) {
        if (context == null) {
            ActionTarget.$$$reportNull$$$0(21);
        }
        if (rectangle == null) {
            ActionTarget.$$$reportNull$$$0(22);
        }
        if (direction == null) {
            ActionTarget.$$$reportNull$$$0(23);
        }
        Point point = ActionTarget.shiftPoint(ActionTarget.getConnectionPoint(rectangle, direction), direction, context.getSwingDimension(ACTION_PADDING));
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(24);
        }
        return point;
    }

    @NotNull
    private static Point getStartPoint(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            ActionTarget.$$$reportNull$$$0(25);
        }
        Point point = ActionTarget.getConnectionPoint(rectangle, START_DIRECTION);
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(26);
        }
        return point;
    }

    @NotNull
    private static Point getEndPoint(@NotNull SceneContext context, @NotNull Rectangle rectangle, @NotNull ConnectionDirection direction) {
        if (context == null) {
            ActionTarget.$$$reportNull$$$0(27);
        }
        if (rectangle == null) {
            ActionTarget.$$$reportNull$$$0(28);
        }
        if (direction == null) {
            ActionTarget.$$$reportNull$$$0(29);
        }
        Point point = ActionTarget.shiftPoint(ActionTarget.getConnectionPoint(rectangle, direction), direction, context.getSwingDimension(NavSceneManager.ACTION_ARROW_PARALLEL + ACTION_PADDING) - 1);
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(30);
        }
        return point;
    }

    @NotNull
    private static Point getConnectionPoint(@NotNull Rectangle rectangle, @NotNull ConnectionDirection direction) {
        if (rectangle == null) {
            ActionTarget.$$$reportNull$$$0(31);
        }
        if (direction == null) {
            ActionTarget.$$$reportNull$$$0(32);
        }
        Point point = ActionTarget.shiftPoint(ActionTarget.getCenterPoint(rectangle), direction, rectangle.width / 2, rectangle.height / 2);
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(33);
        }
        return point;
    }

    @NotNull
    private static Point getControlPoint(@NotNull SceneContext context, @NotNull Point p1, @NotNull Point p2, @NotNull ConnectionDirection direction) {
        if (context == null) {
            ActionTarget.$$$reportNull$$$0(34);
        }
        if (p1 == null) {
            ActionTarget.$$$reportNull$$$0(35);
        }
        if (p2 == null) {
            ActionTarget.$$$reportNull$$$0(36);
        }
        if (direction == null) {
            ActionTarget.$$$reportNull$$$0(37);
        }
        int shift = (int)Math.min(Math.hypot(p1.x - p2.x, p1.y - p2.y) / 2.0, (double)context.getSwingDimension(CONTROL_POINT_THRESHOLD));
        Point point = ActionTarget.shiftPoint(p1, direction, shift);
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(38);
        }
        return point;
    }

    @NotNull
    private static Point shiftPoint(@NotNull Point p, @NotNull ConnectionDirection direction, int shift) {
        if (p == null) {
            ActionTarget.$$$reportNull$$$0(39);
        }
        if (direction == null) {
            ActionTarget.$$$reportNull$$$0(40);
        }
        Point point = ActionTarget.shiftPoint(p, direction, shift, shift);
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(41);
        }
        return point;
    }

    @NotNull
    private static Point shiftPoint(@NotNull Point p, ConnectionDirection direction, int shiftX, int shiftY) {
        if (p == null) {
            ActionTarget.$$$reportNull$$$0(42);
        }
        Point point = new Point(p.x + shiftX * direction.getDeltaX(), p.y + shiftY * direction.getDeltaY());
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(43);
        }
        return point;
    }

    @NotNull
    private static ConnectionDirection getDestinationDirection(@NotNull Rectangle source, @NotNull Rectangle destination) {
        boolean higher;
        if (source == null) {
            ActionTarget.$$$reportNull$$$0(44);
        }
        if (destination == null) {
            ActionTarget.$$$reportNull$$$0(45);
        }
        Point start = ActionTarget.getStartPoint(source);
        Point end = ActionTarget.getCenterPoint(destination);
        float slope = destination.width == 0 ? 1.0f : (float)destination.height / (float)destination.width;
        float rise = (float)(start.x - end.x) * slope;
        boolean bl = higher = start.y < end.y;
        if (higher && (float)start.y < (float)end.y + rise) {
            ConnectionDirection connectionDirection = ConnectionDirection.TOP;
            if (connectionDirection == null) {
                ActionTarget.$$$reportNull$$$0(46);
            }
            return connectionDirection;
        }
        if (!higher && (float)start.y > (float)end.y - rise) {
            ConnectionDirection connectionDirection = ConnectionDirection.BOTTOM;
            if (connectionDirection == null) {
                ActionTarget.$$$reportNull$$$0(47);
            }
            return connectionDirection;
        }
        ConnectionDirection connectionDirection = ConnectionDirection.LEFT;
        if (connectionDirection == null) {
            ActionTarget.$$$reportNull$$$0(48);
        }
        return connectionDirection;
    }

    @NotNull
    private static Rectangle getArrowRectangle(@NotNull SceneContext context, @NotNull Point p, @NotNull ConnectionDirection direction) {
        if (context == null) {
            ActionTarget.$$$reportNull$$$0(49);
        }
        if (p == null) {
            ActionTarget.$$$reportNull$$$0(50);
        }
        if (direction == null) {
            ActionTarget.$$$reportNull$$$0(51);
        }
        Rectangle rectangle = new Rectangle();
        int parallel = context.getSwingDimension(NavSceneManager.ACTION_ARROW_PARALLEL);
        int perpendicular = context.getSwingDimension(NavSceneManager.ACTION_ARROW_PERPENDICULAR);
        int deltaX = direction.getDeltaX();
        int deltaY = direction.getDeltaY();
        rectangle.x = p.x + (deltaX == 0 ? -perpendicular : parallel * (deltaX - 1)) / 2;
        rectangle.y = p.y + (deltaY == 0 ? -perpendicular : parallel * (deltaY - 1)) / 2;
        rectangle.width = Math.abs(deltaX * parallel) + Math.abs(deltaY * perpendicular);
        rectangle.height = Math.abs(deltaX * perpendicular) + Math.abs(deltaY * parallel);
        Rectangle rectangle2 = rectangle;
        if (rectangle2 == null) {
            ActionTarget.$$$reportNull$$$0(52);
        }
        return rectangle2;
    }

    @NotNull
    private static ArrowDirection getArrowDirection(@NotNull ConnectionDirection direction) {
        if (direction == null) {
            ActionTarget.$$$reportNull$$$0(53);
        }
        switch (direction) {
            case LEFT: {
                ArrowDirection arrowDirection = ArrowDirection.RIGHT;
                if (arrowDirection == null) {
                    ActionTarget.$$$reportNull$$$0(54);
                }
                return arrowDirection;
            }
            case RIGHT: {
                ArrowDirection arrowDirection = ArrowDirection.LEFT;
                if (arrowDirection == null) {
                    ActionTarget.$$$reportNull$$$0(55);
                }
                return arrowDirection;
            }
            case TOP: {
                ArrowDirection arrowDirection = ArrowDirection.DOWN;
                if (arrowDirection == null) {
                    ActionTarget.$$$reportNull$$$0(56);
                }
                return arrowDirection;
            }
            case BOTTOM: {
                ArrowDirection arrowDirection = ArrowDirection.UP;
                if (arrowDirection == null) {
                    ActionTarget.$$$reportNull$$$0(57);
                }
                return arrowDirection;
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static Point getCenterPoint(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            ActionTarget.$$$reportNull$$$0(58);
        }
        Point point = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
        if (point == null) {
            ActionTarget.$$$reportNull$$$0(59);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 4: 
            case 21: 
            case 27: 
            case 34: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/targets/ActionTarget";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 12: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 23: 
            case 29: 
            case 32: 
            case 37: 
            case 40: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 39: 
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/targets/ActionTarget";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurvePoints";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfActionPoints";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfActionEndPoint";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowPoint";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartPoint";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndPoint";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionPoint";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlPoint";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftPoint";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationDirection";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowRectangle";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowDirection";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mouseRelease";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderSelfAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addHit";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCurvePoints";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSelfActionPoints";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelfActionEndPoint";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getArrowPoint";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getStartPoint";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEndPoint";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionPoint";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getControlPoint";
                break;
            }
            case 39: 
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shiftPoint";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationDirection";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getArrowRectangle";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getArrowDirection";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getCenterPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ConnectionDirection {
        LEFT(-1, 0),
        RIGHT(1, 0),
        TOP(0, -1),
        BOTTOM(0, 1);

        private ConnectionDirection myOpposite;
        private final int myDeltaX;
        private final int myDeltaY;

        private ConnectionDirection(int deltaX, int deltaY) {
            this.myDeltaX = deltaX;
            this.myDeltaY = deltaY;
        }

        public int getDeltaX() {
            return this.myDeltaX;
        }

        public int getDeltaY() {
            return this.myDeltaY;
        }

        public ConnectionDirection getOpposite() {
            return this.myOpposite;
        }

        static {
            ConnectionDirection.LEFT.myOpposite = RIGHT;
            ConnectionDirection.RIGHT.myOpposite = LEFT;
            ConnectionDirection.TOP.myOpposite = BOTTOM;
            ConnectionDirection.BOTTOM.myOpposite = TOP;
        }
    }

    public static enum ConnectionType {
        NORMAL,
        EXIT;

    }

    public static class SelfActionPoints {
        public final int[] x = new int[5];
        public final int[] y = new int[5];
        public ConnectionDirection dir;
    }

    public static class CurvePoints {
        public Point p1;
        public Point p2;
        public Point p3;
        public Point p4;
        public ConnectionDirection dir;
    }
}

