/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.MultiComponentTarget;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScreenDragTarget
extends DragBaseTarget
implements MultiComponentTarget {
    private final Point[] myChildOffsets;

    public ScreenDragTarget(@NotNull SceneComponent component) {
        if (component == null) {
            ScreenDragTarget.$$$reportNull$$$0(0);
        }
        this.setComponent(component);
        this.myChildOffsets = new Point[component.getChildren().size()];
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            ScreenDragTarget.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        for (int i = 0; i < this.getComponent().getChildren().size(); ++i) {
            SceneComponent child = this.getComponent().getChild(i);
            this.myChildOffsets[i] = new Point(x - child.getDrawX(), y - child.getDrawY());
        }
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTarget) {
        SceneComponent parent;
        if (closestTarget == null) {
            ScreenDragTarget.$$$reportNull$$$0(2);
        }
        if ((parent = this.myComponent.getParent()) == null) {
            return;
        }
        this.myComponent.setDragging(true);
        int dx = x - this.myOffsetX;
        int dy = y - this.myOffsetY;
        if (dx < parent.getDrawX() || dx + this.myComponent.getDrawWidth() > parent.getDrawX() + parent.getDrawWidth()) {
            return;
        }
        if (dy < parent.getDrawY() || dy + this.myComponent.getDrawHeight() > parent.getDrawY() + parent.getDrawHeight()) {
            return;
        }
        this.myComponent.setPosition(dx, dy, false);
        this.myChangedComponent = true;
        for (int i = 0; i < this.myChildOffsets.length; ++i) {
            int newX = x - this.myChildOffsets[i].x;
            int newY = y - this.myChildOffsets[i].y;
            this.getComponent().getChild(i).setPosition(newX, newY);
        }
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ScreenDragTarget.$$$reportNull$$$0(3);
        }
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                return;
            }
            ((NavSceneManager)this.myComponent.getScene().getSceneManager()).save((List<SceneComponent>)ImmutableList.of((Object)this.myComponent));
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/naveditor/scene/targets/ScreenDragTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

