/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.editor.NlEditorPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.LerpValue;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ZoomType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceActionHandler;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JViewport;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavDesignSurface
extends DesignSurface {
    private static final int SCROLL_DURATION_MS = 300;
    private static final Object CONNECTION_CLIENT_PROPERTY_KEY = new Object();
    private NlComponent myCurrentNavigation;
    AtomicReference<Future<?>> myScheduleRef;
    private final NlEditorPanel myEditorPanel;
    private static final WeakHashMap<AndroidFacet, SoftReference<ConfigurationManager>> ourConfigurationManagers = new WeakHashMap();

    public NavDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NavDesignSurface.$$$reportNull$$$0(1);
        }
        this(project, (NlEditorPanel)null, parentDisposable);
    }

    public NavDesignSurface(@NotNull Project project, @Nullable NlEditorPanel editorPanel, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            NavDesignSurface.$$$reportNull$$$0(3);
        }
        super(project, new SelectionModel(), parentDisposable);
        this.myScheduleRef = new AtomicReference();
        this.setBackground((Color)JBColor.white);
        this.myEditorPanel = editorPanel;
    }

    @Override
    public void dispose() {
        Future<?> future2 = this.getScheduleRef().get();
        if (future2 != null) {
            future2.cancel(false);
        }
        this.getScheduleRef().set(null);
        super.dispose();
    }

    @Override
    public float getSceneScalingFactor() {
        return 1.0f;
    }

    @Deprecated
    @NotNull
    public NavigationSchema getSchema() {
        NavSceneManager manager = this.getSceneManager();
        assert (manager != null);
        NavigationSchema navigationSchema = manager.getSchema();
        if (navigationSchema == null) {
            NavDesignSurface.$$$reportNull$$$0(4);
        }
        return navigationSchema;
    }

    @Override
    public void forceUserRequestedRefresh() {
    }

    @NotNull
    protected NavActionManager createActionManager() {
        NavActionManager navActionManager = new NavActionManager(this);
        if (navActionManager == null) {
            NavDesignSurface.$$$reportNull$$$0(5);
        }
        return navActionManager;
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model) {
        if (model == null) {
            NavDesignSurface.$$$reportNull$$$0(6);
        }
        NavSceneManager navSceneManager = new NavSceneManager(model, this);
        if (navSceneManager == null) {
            NavDesignSurface.$$$reportNull$$$0(7);
        }
        return navSceneManager;
    }

    @Override
    @Nullable
    public NavSceneManager getSceneManager() {
        return (NavSceneManager)super.getSceneManager();
    }

    @Override
    public CompletableFuture<?> goingToSetModel(final NlModel model) {
        model.getConfiguration().getResourceResolver();
        final AndroidFacet facet = model.getFacet();
        final CompletableFuture result2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (NavDesignSurface.tryToCreateSchema(facet)) {
                result2.complete(null);
            } else if (NavDesignSurface.requestAddDependency(facet)) {
                ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getSyncManager(this.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
                Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object unused) {
                        application.executeOnPooledThread(() -> {
                            if (!NavDesignSurface.tryToCreateSchema(facet)) {
                                NavDesignSurface.this.showFailToAddMessage(result2, model);
                            } else {
                                result2.complete(null);
                            }
                        });
                    }

                    public void onFailure(@Nullable Throwable t) {
                        NavDesignSurface.this.showFailToAddMessage(result2, model);
                    }
                });
            } else {
                this.showFailToAddMessage(result2, model);
            }
        });
        return result2;
    }

    private void showFailToAddMessage(@NotNull CompletableFuture<?> result2, final @NotNull NlModel model) {
        if (result2 == null) {
            NavDesignSurface.$$$reportNull$$$0(8);
        }
        if (model == null) {
            NavDesignSurface.$$$reportNull$$$0(9);
        }
        if (this.myEditorPanel != null) {
            ProjectSystemSyncManager.SyncResultListener syncFailedListener = new ProjectSystemSyncManager.SyncResultListener(){

                @Override
                public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result2) {
                    if (result2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (model == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (NavDesignSurface.tryToCreateSchema(model.getFacet())) {
                            NavDesignSurface.this.myEditorPanel.initNeleModel();
                            ((MessageBusConnection)NavDesignSurface.this.myEditorPanel.getClientProperty(CONNECTION_CLIENT_PROPERTY_KEY)).disconnect();
                            NavDesignSurface.this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, null);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "model";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/naveditor/surface/NavDesignSurface$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "syncEnded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$syncEnded$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, connection);
            connection.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)syncFailedListener);
        }
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.getProject(), (String)"Failed to add navigation library dependency", (String)"Failed to Add Dependency"));
        result2.completeExceptionally(new Exception("Failed to add nav library dependency"));
    }

    private static boolean requestAddDependency(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(10);
        }
        AtomicBoolean didAdd = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (facet == null) {
                NavDesignSurface.$$$reportNull$$$0(30);
            }
            didAdd.set(DependencyManagementUtil.addDependencies(facet.getModule(), (List<GradleCoordinate>)ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT.getCoordinate("+")), true, false, false).isEmpty());
        });
        return didAdd.get();
    }

    private static boolean tryToCreateSchema(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(11);
        }
        return (Boolean)DumbService.getInstance((Project)facet.getModule().getProject()).runReadActionInSmartMode(() -> {
            if (facet == null) {
                NavDesignSurface.$$$reportNull$$$0(29);
            }
            try {
                NavigationSchema.createIfNecessary(facet);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }

    @Override
    protected void layoutContent() {
        this.requestRender();
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if (this.myCurrentNavigation == null || this.myCurrentNavigation.getModel() != this.getModel()) {
            this.refreshRoot();
        }
        NlComponent nlComponent = this.myCurrentNavigation;
        if (nlComponent == null) {
            NavDesignSurface.$$$reportNull$$$0(12);
        }
        return nlComponent;
    }

    public void setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        if (currentNavigation == null) {
            NavDesignSurface.$$$reportNull$$$0(13);
        }
        this.myCurrentNavigation = currentNavigation;
        this.getSceneManager().update();
        this.getSelectionModel().clear();
        this.getSceneManager().layout(false);
        this.zoomToFit();
        currentNavigation.getModel().notifyModified(NlModel.ChangeType.UPDATE_HIERARCHY);
        this.repaint();
    }

    @Override
    @Nullable
    public Dimension getScrolledAreaSize() {
        return this.getContentSize(null);
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension2) {
        SceneView view = this.getCurrentSceneView();
        if (view == null) {
            Dimension dim = dimension2 == null ? new Dimension() : dimension2;
            dim.setSize(0, 0);
            Dimension dimension3 = dim;
            if (dimension3 == null) {
                NavDesignSurface.$$$reportNull$$$0(14);
            }
            return dimension3;
        }
        Dimension dimension4 = view.getSize(dimension2);
        if (dimension4 == null) {
            NavDesignSurface.$$$reportNull$$$0(15);
        }
        return dimension4;
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(0, 0);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        SceneView view = this.getCurrentSceneView();
        if (view == null) {
            Dimension dimension2 = new Dimension(0, 0);
            if (dimension2 == null) {
                NavDesignSurface.$$$reportNull$$$0(16);
            }
            return dimension2;
        }
        SceneComponent root = view.getScene().getRoot();
        if (root == null) {
            Dimension dimension3 = new Dimension(0, 0);
            if (dimension3 == null) {
                NavDesignSurface.$$$reportNull$$$0(17);
            }
            return dimension3;
        }
        Rectangle boundingBox = NavSceneManager.getBoundingBox(root);
        Dimension dimension4 = boundingBox.getSize();
        if (dimension4 == null) {
            NavDesignSurface.$$$reportNull$$$0(18);
        }
        return dimension4;
    }

    @Override
    public boolean isLayoutDisabled() {
        return false;
    }

    @Override
    public int getContentOriginX() {
        return 0;
    }

    @Override
    public int getContentOriginY() {
        return 0;
    }

    @Override
    protected double getMinScale() {
        return this.isEmpty() ? 1.0 : 0.1;
    }

    @Override
    protected double getMaxScale() {
        return this.isEmpty() ? 1.0 : 3.0;
    }

    @Override
    public boolean canZoomToFit() {
        return !this.isEmpty();
    }

    @Override
    protected double getFitScale(boolean fitInto) {
        return Math.min(super.getFitScale(fitInto), 1.0);
    }

    private boolean isEmpty() {
        NavSceneManager sceneManager = this.getSceneManager();
        return sceneManager == null || sceneManager.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyComponentActivate(@NotNull NlComponent component) {
        VirtualFile virtualFile;
        PsiFile file;
        PsiClass psiClass;
        String className;
        String id;
        if (component == null) {
            NavDesignSurface.$$$reportNull$$$0(19);
        }
        if (this.myCurrentNavigation == component) {
            return;
        }
        String tagName = component.getTagName();
        if (this.getSceneManager().getSchema().getDestinationType(tagName) == NavigationSchema.DestinationType.NAVIGATION) {
            if (!tagName.equals("include")) {
                this.setCurrentNavigation(component);
                return;
            }
            id = component.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
            if (id == null) {
                return;
            }
        } else {
            id = component.getAttribute("http://schemas.android.com/tools", "layout");
        }
        if (id != null) {
            VirtualFile virtualFile2;
            File file2;
            String fileName;
            Configuration configuration = this.getConfiguration();
            ResourceResolver resolver = configuration != null ? configuration.getResourceResolver() : null;
            ResourceValue value = resolver != null ? resolver.findResValue(id, false) : null;
            String string = fileName = value != null ? value.getValue() : null;
            if (fileName != null && (file2 = new File(fileName)).exists() && (virtualFile2 = VfsUtil.findFileByIoFile((File)file2, (boolean)false)) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
                return;
            }
        }
        if ((className = component.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file = psiClass.getContainingFile()) != null && (virtualFile = file.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile, true);
            return;
        }
        super.notifyComponentActivate(component);
    }

    @Override
    @Nullable
    public Interaction doCreateInteractionOnClick(int mouseX, int mouseY, @NotNull SceneView view) {
        if (view == null) {
            NavDesignSurface.$$$reportNull$$$0(20);
        }
        return new SceneInteraction(view);
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(@NotNull SceneComponent draggedSceneComponent, @Nullable SceneComponent primary) {
        if (draggedSceneComponent == null) {
            NavDesignSurface.$$$reportNull$$$0(21);
        }
        return null;
    }

    @Override
    public void zoom(@NotNull ZoomType type, int x, int y) {
        if (type == null) {
            NavDesignSurface.$$$reportNull$$$0(22);
        }
        super.zoom(type, x, y);
        if (type == ZoomType.FIT || type == ZoomType.FIT_INTO) {
            JViewport viewport = this.getScrollPane().getViewport();
            Rectangle bounds = viewport.getViewRect();
            Dimension size = viewport.getViewSize();
            viewport.setViewPosition(new Point((size.width - bounds.width) / 2, (size.height - bounds.height) / 2));
        }
    }

    @NotNull
    public Dimension getExtentSize() {
        Dimension dimension2 = this.getScrollPane().getViewport().getExtentSize();
        if (dimension2 == null) {
            NavDesignSurface.$$$reportNull$$$0(23);
        }
        return dimension2;
    }

    public void scrollToCenter(@NotNull List<NlComponent> list) {
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(24);
        }
        Scene scene = this.getScene();
        SceneView view = this.getCurrentSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle selectionBounds = NavSceneManager.getBoundingBox(list.stream().map(nlComponent -> scene.getSceneComponent((NlComponent)nlComponent)).filter(sceneComponent -> sceneComponent != null).collect(Collectors.toList()));
        Dimension swingViewportSize = this.getScrollPane().getViewport().getExtentSize();
        int swingStartCenterXInViewport = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX()) - this.getScrollPosition().x;
        int swingStartCenterYInViewport = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY()) - this.getScrollPosition().y;
        LerpValue xLerp = new LerpValue(swingStartCenterXInViewport, swingViewportSize.width / 2, this.getScrollDurationMs());
        LerpValue yLerp = new LerpValue(swingStartCenterYInViewport, swingViewportSize.height / 2, this.getScrollDurationMs());
        LerpValue zoomLerp = new LerpValue((int)(view.getScale() * 100.0), (int)(this.getFitScale(selectionBounds.getSize(), true) * 100.0), this.getScrollDurationMs());
        if (this.getScheduleRef().get() != null) {
            this.getScheduleRef().get().cancel(false);
        }
        Runnable action2 = () -> UIUtil.invokeAndWaitIfNeeded(() -> {
            long time2 = System.currentTimeMillis();
            int xSwingValue = xLerp.getValue(time2);
            int ySwingValue = yLerp.getValue(time2);
            int targetSwingX = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX());
            int targetSwingY = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY());
            this.setScrollPosition(targetSwingX - xSwingValue, targetSwingY - ySwingValue);
            this.setScale((double)zoomLerp.getValue(time2) / 100.0, targetSwingX, targetSwingY);
            if (xSwingValue == xLerp.getEnd() && ySwingValue == yLerp.getEnd()) {
                this.getScheduleRef().get().cancel(false);
                this.getScheduleRef().set(null);
            }
        });
        this.getScheduleRef().set(AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(action2, 0L, 10L, TimeUnit.MILLISECONDS));
    }

    @NotNull
    AtomicReference<Future<?>> getScheduleRef() {
        AtomicReference<Future<?>> atomicReference = this.myScheduleRef;
        if (atomicReference == null) {
            NavDesignSurface.$$$reportNull$$$0(25);
        }
        return atomicReference;
    }

    int getScrollDurationMs() {
        return 300;
    }

    public void refreshRoot() {
        NlModel model = this.getModel();
        if (model == null) {
            return;
        }
        NlComponent match = (NlComponent)model.getComponents().get(0);
        if (this.myCurrentNavigation != null) {
            boolean includingParent = false;
            TagSnapshot currentSnapshot = this.myCurrentNavigation.getSnapshot();
            NlComponent currentParent = this.myCurrentNavigation.getParent();
            for (NlComponent component : model.flattenComponents()::iterator) {
                if (!NavComponentHelperKt.isNavigation(component)) continue;
                if (component == this.myCurrentNavigation) {
                    return;
                }
                TagSnapshot componentSnapshot = component.getSnapshot();
                if (currentSnapshot != null && currentSnapshot == componentSnapshot) {
                    match = component;
                    break;
                }
                if (includingParent || !Objects.equals(component.getId(), this.myCurrentNavigation.getId())) continue;
                match = component;
                NlComponent componentParent = component.getParent();
                if (componentParent == null != (currentParent == null) || componentParent != null && !Objects.equals(componentParent.getId(), currentParent.getId())) continue;
                includingParent = true;
            }
        }
        this.myCurrentNavigation = match;
        this.zoomToFit();
    }

    @Override
    @NotNull
    protected DesignSurfaceActionHandler createActionHandler() {
        NavDesignSurfaceActionHandler navDesignSurfaceActionHandler = new NavDesignSurfaceActionHandler(this);
        if (navDesignSurfaceActionHandler == null) {
            NavDesignSurface.$$$reportNull$$$0(26);
        }
        return navDesignSurfaceActionHandler;
    }

    @Override
    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(27);
        }
        SoftReference<ConfigurationManager> ref = ourConfigurationManagers.get((Object)facet);
        ConfigurationManager result2 = null;
        if (ref != null) {
            result2 = (ConfigurationManager)ref.get();
        }
        if (result2 == null) {
            result2 = new ConfigurationManager(facet.getModule()){

                @Override
                public ConfigurationStateManager getStateManager() {
                    return new ConfigurationStateManager();
                }
            };
            ourConfigurationManagers.put(facet, (SoftReference<ConfigurationManager>)new SoftReference((Object)result2));
        }
        ConfigurationManager configurationManager = result2;
        if (configurationManager == null) {
            NavDesignSurface.$$$reportNull$$$0(28);
        }
        return configurationManager;
    }

    @Override
    protected boolean getSupportPinchAndZoom() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 11: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentNavigation";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedSceneComponent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSceneManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNavigation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtentSize";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getScheduleRef";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionHandler";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showFailToAddMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestAddDependency";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreateSchema";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentNavigation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCreateInteractionOnClick";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createInteractionOnDrag";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCenter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryToCreateSchema$3";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestAddDependency$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

