/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildScriptNode
extends PsiFileNode {
    static final String MODULE_PREFIX = "Module: ";
    static final String PROJECT_PREFIX = "Project: ";
    @Nullable
    private final String myQualifier;

    public AndroidBuildScriptNode(@NotNull Project project, @NotNull PsiFile value, @NotNull ViewSettings settings, @Nullable String qualifier) {
        if (project == null) {
            AndroidBuildScriptNode.$$$reportNull$$$0(0);
        }
        if (value == null) {
            AndroidBuildScriptNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidBuildScriptNode.$$$reportNull$$$0(2);
        }
        super(project, value, settings);
        this.myQualifier = qualifier;
    }

    public void update(@NotNull PresentationData data) {
        if (data == null) {
            AndroidBuildScriptNode.$$$reportNull$$$0(3);
        }
        super.update(data);
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile != null && psiFile.isValid()) {
            String fileName = psiFile.getName();
            data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.setPresentableText(fileName);
            if (this.myQualifier != null) {
                data.addText(" (" + this.myQualifier + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
    }

    @Nullable
    public Comparable getSortKey() {
        String priority;
        if (this.myQualifier != null) {
            priority = this.myQualifier.startsWith(PROJECT_PREFIX) ? "1-" : (this.myQualifier.startsWith(MODULE_PREFIX) ? "2-" : "3-");
            priority = priority + this.myQualifier + "-";
        } else {
            priority = "4-";
        }
        PsiFile file = (PsiFile)this.getValue();
        return file != null ? priority + file.getName() : priority;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile value = (PsiFile)this.getValue();
        String fileName = value != null ? value.getName() : "";
        return fileName + (this.myQualifier == null ? "" : " (" + this.myQualifier + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidBuildScriptNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

