/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkSourceFolderNode;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJniFolderNode
extends ProjectViewNode<NdkModuleModel>
implements FolderGroupNode {
    AndroidJniFolderNode(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull ViewSettings settings) {
        if (project == null) {
            AndroidJniFolderNode.$$$reportNull$$$0(0);
        }
        if (ndkModuleModel == null) {
            AndroidJniFolderNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidJniFolderNode.$$$reportNull$$$0(2);
        }
        super(project, (Object)ndkModuleModel, settings);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        AbstractTreeNode sourceNode;
        assert (this.myProject != null);
        Collection<AbstractTreeNode> nativeSourceNodes = NdkModuleNode.getNativeSourceNodes(this.myProject, this.getNdkModel(), this.getSettings());
        if (nativeSourceNodes.size() == 1 && (sourceNode = (AbstractTreeNode)Iterables.getOnlyElement(nativeSourceNodes)) instanceof NdkSourceFolderNode) {
            Collection collection = ((NdkSourceFolderNode)sourceNode).getChildren();
            if (collection == null) {
                AndroidJniFolderNode.$$$reportNull$$$0(3);
            }
            return collection;
        }
        Collection<AbstractTreeNode> collection = nativeSourceNodes;
        if (collection == null) {
            AndroidJniFolderNode.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        Collection<File> sourceFolderPaths = this.getNdkModel().getSelectedVariant().getSourceFolders();
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(sourceFolderPaths.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (File sourceFolderPath : sourceFolderPaths) {
            PsiDirectory psiSourceFolder;
            VirtualFile sourceFolder = fileSystem.findFileByIoFile(sourceFolderPath);
            if (sourceFolder == null || (psiSourceFolder = psiManager.findDirectory(sourceFolder)) == null) continue;
            folders.add(psiSourceFolder);
        }
        PsiDirectory[] psiDirectoryArray = folders.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            AndroidJniFolderNode.$$$reportNull$$$0(5);
        }
        return psiDirectoryArray;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidJniFolderNode.$$$reportNull$$$0(6);
        }
        Collection<File> sourceFolders = this.getNdkModel().getSelectedVariant().getSourceFolders();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File folder : sourceFolders) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(folder);
            if (virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        if (((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue()) {
            NdkModuleModel moduleModel = (NdkModuleModel)this.getValue();
            if (moduleModel == null) {
                return false;
            }
            return NdkModuleNode.containedInIncludeFolders(moduleModel, file);
        }
        return false;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(AndroidSourceType.CPP.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = AndroidSourceType.CPP.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(AndroidSourceType.CPP.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return AndroidSourceType.CPP.getName();
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.CPP;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.CPP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidJniFolderNode that = (AndroidJniFolderNode)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        int result2 = super.hashCode();
        return 31 * result2 + this.getNdkModel().hashCode();
    }

    @NotNull
    private NdkModuleModel getNdkModel() {
        NdkModuleModel value = (NdkModuleModel)this.getValue();
        assert (value != null);
        NdkModuleModel ndkModuleModel = value;
        if (ndkModuleModel == null) {
            AndroidJniFolderNode.$$$reportNull$$$0(7);
        }
        return ndkModuleModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidJniFolderNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidJniFolderNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNdkModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

