/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderTypeNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.android.tools.idea.resourceExplorer.editor.ResourceExplorerFile;
import com.google.common.collect.HashMultimap;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;

public class AndroidResFolderNode
extends AndroidSourceTypeNode {
    AndroidResFolderNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull Set<VirtualFile> sourceRoots, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidResFolderNode.$$$reportNull$$$0(0);
        }
        if (androidFacet == null) {
            AndroidResFolderNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidResFolderNode.$$$reportNull$$$0(2);
        }
        if (sourceRoots == null) {
            AndroidResFolderNode.$$$reportNull$$$0(3);
        }
        if (projectViewPane == null) {
            AndroidResFolderNode.$$$reportNull$$$0(4);
        }
        super(project, androidFacet, settings, AndroidSourceType.RES, sourceRoots, projectViewPane);
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<PsiDirectory> resFolders = new ArrayList<PsiDirectory>();
        for (PsiDirectory psiDirectory : this.getSourceFolders()) {
            resFolders.addAll(Arrays.asList(psiDirectory.getSubdirectories()));
        }
        HashMultimap foldersByResourceType = HashMultimap.create();
        for (PsiDirectory resFolder : resFolders) {
            ResourceFolderType type = ResourceFolderType.getFolderType((String)resFolder.getName());
            if (type == null) continue;
            foldersByResourceType.put((Object)type, (Object)resFolder);
        }
        AndroidProjectTreeBuilder androidProjectTreeBuilder = (AndroidProjectTreeBuilder)this.myProjectViewPane.getTreeBuilder();
        ArrayList<AndroidResFolderTypeNode> children = new ArrayList<AndroidResFolderTypeNode>(foldersByResourceType.size());
        for (ResourceFolderType type : foldersByResourceType.keySet()) {
            Set folders = foldersByResourceType.get((Object)type);
            assert (this.myProject != null);
            AndroidResFolderTypeNode node = new AndroidResFolderTypeNode(this.myProject, this.getAndroidFacet(), new ArrayList<PsiDirectory>(folders), this.getSettings(), type);
            children.add(node);
            for (PsiDirectory folder : folders) {
                androidProjectTreeBuilder.createMapping(folder.getVirtualFile(), (AbstractTreeNode)node);
            }
        }
        ArrayList<AndroidResFolderTypeNode> arrayList = children;
        if (arrayList == null) {
            AndroidResFolderNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private AndroidFacet getAndroidFacet() {
        AndroidFacet facet = (AndroidFacet)((Object)this.getValue());
        assert (facet != null);
        AndroidFacet androidFacet = facet;
        if (androidFacet == null) {
            AndroidResFolderNode.$$$reportNull$$$0(6);
        }
        return androidFacet;
    }

    public boolean expandOnDoubleClick() {
        return (Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get() != false ? false : super.expandOnDoubleClick();
    }

    public boolean canNavigate() {
        return (Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get();
    }

    public void navigate(boolean requestFocus) {
        if (this.myProject != null) {
            new OpenFileDescriptor(this.myProject, (VirtualFile)ResourceExplorerFile.getResourceEditorFile(this.myProject, this.getAndroidFacet())).navigate(requestFocus);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidResFolderNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidResFolderNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

