/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.navigator.nodes.FileGroupNode;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResComparator;
import com.android.tools.idea.navigator.nodes.android.AndroidResFileNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResGroupNode
extends ProjectViewNode<List<PsiFile>>
implements FolderGroupNode,
FileGroupNode,
Comparable {
    @NotNull
    private final String myResName;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final List<PsiFile> myFiles;

    AndroidResGroupNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull List<PsiFile> files2, @NotNull String resName, @NotNull ViewSettings settings) {
        if (project == null) {
            AndroidResGroupNode.$$$reportNull$$$0(0);
        }
        if (androidFacet == null) {
            AndroidResGroupNode.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            AndroidResGroupNode.$$$reportNull$$$0(2);
        }
        if (resName == null) {
            AndroidResGroupNode.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AndroidResGroupNode.$$$reportNull$$$0(4);
        }
        super(project, files2, settings);
        this.myResName = resName;
        this.myFacet = androidFacet;
        this.myFiles = files2;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        List<PsiFile> resFiles = this.getResFiles();
        PsiDirectory[] folders = new PsiDirectory[resFiles.size()];
        for (int i = 0; i < resFiles.size(); ++i) {
            folders[i] = resFiles.get(i).getParent();
        }
        if (folders == null) {
            AndroidResGroupNode.$$$reportNull$$$0(5);
        }
        return folders;
    }

    @Override
    @NotNull
    public PsiFile[] getFiles() {
        PsiFile[] psiFileArray = this.getResFiles().toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            AndroidResGroupNode.$$$reportNull$$$0(6);
        }
        return psiFileArray;
    }

    @NotNull
    private List<PsiFile> getResFiles() {
        List files2 = (List)this.getValue();
        assert (files2 != null);
        List list = files2;
        if (list == null) {
            AndroidResGroupNode.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidResGroupNode.$$$reportNull$$$0(8);
        }
        for (PsiFile psiFile : this.myFiles) {
            if (!psiFile.getVirtualFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AndroidResFileNode> children = new ArrayList<AndroidResFileNode>(this.myFiles.size());
        assert (this.myProject != null);
        for (PsiFile file : this.myFiles) {
            children.add(new AndroidResFileNode(this.myProject, file, this.getSettings(), this.myFacet));
        }
        ArrayList<AndroidResFileNode> arrayList = children;
        if (arrayList == null) {
            AndroidResGroupNode.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public int getWeight() {
        return 20;
    }

    @Nullable
    public Comparable getSortKey() {
        return this;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this;
    }

    public int compareTo(@NotNull Object obj) {
        if (obj == null) {
            AndroidResGroupNode.$$$reportNull$$$0(10);
        }
        return AndroidResComparator.INSTANCE.compare(this, obj);
    }

    @NotNull
    public String getResName() {
        String string = this.myResName;
        if (string == null) {
            AndroidResGroupNode.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        PsiFile fileToOpen;
        if (!this.myFiles.isEmpty() && (fileToOpen = AndroidResGroupNode.findFileToOpen(this.myFiles)) != null) {
            assert (this.myProject != null);
            new OpenFileDescriptor(this.myProject, fileToOpen.getVirtualFile()).navigate(requestFocus);
        }
    }

    @Nullable
    private static PsiFile findFileToOpen(@NotNull List<PsiFile> files2) {
        if (files2 == null) {
            AndroidResGroupNode.$$$reportNull$$$0(12);
        }
        PsiFile bestFile = null;
        FolderConfiguration bestConfig = null;
        for (PsiFile file : files2) {
            PsiDirectory qualifiedDirectory = file.getParent();
            assert (qualifiedDirectory != null) : "Resource file's parent directory cannot be null";
            FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)qualifiedDirectory.getName());
            if (bestConfig != null && config != null && config.compareTo(bestConfig) >= 0) continue;
            bestConfig = config;
            bestFile = file;
        }
        return bestFile;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidResGroupNode.$$$reportNull$$$0(13);
        }
        presentation.setPresentableText(this.myResName);
        presentation.addText(this.myResName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myFiles.size() > 1) {
            presentation.addText(String.format(" (%1$d)", this.myFiles.size()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myResName + " (" + this.myFiles.size() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidResGroupNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidResGroupNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileToOpen";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

