/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValues;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.ShadowingIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.IncludeSet;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNodes;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.NativeIncludes;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.SimpleIncludeViewNode;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.VirtualFiles;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CppHeadersViewEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludesViewNode
extends ProjectViewNode<NativeIncludes>
implements FolderGroupNode {
    @NotNull
    private final NativeIncludes myDependencyInfo;

    public IncludesViewNode(@Nullable Project project, @NotNull NativeIncludes dependencyInfo, @NotNull ViewSettings settings) {
        if (dependencyInfo == null) {
            IncludesViewNode.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            IncludesViewNode.$$$reportNull$$$0(1);
        }
        super(project, (Object)dependencyInfo, settings);
        this.myDependencyInfo = dependencyInfo;
    }

    @NotNull
    private static IncludeSet distinctIncludes(@NotNull NativeIncludes nativeIncludes) {
        if (nativeIncludes == null) {
            IncludesViewNode.$$$reportNull$$$0(2);
        }
        IncludeSet set = new IncludeSet();
        HashSet<String> settingsSeen = new HashSet<String>();
        for (NativeArtifact artifact : nativeIncludes.myArtifacts) {
            for (NativeFile sourceFile : artifact.getSourceFiles()) {
                File workingDirectory = sourceFile.getWorkingDirectory();
                String settingsName = sourceFile.getSettingsName();
                if (settingsSeen.contains(settingsName)) continue;
                settingsSeen.add(settingsName);
                NativeSettings settings = nativeIncludes.findExpectedSettings(settingsName);
                set.addIncludesFromCompilerFlags(settings.getCompilerFlags(), workingDirectory);
            }
        }
        IncludeSet includeSet = set;
        if (includeSet == null) {
            IncludesViewNode.$$$reportNull$$$0(3);
        }
        return includeSet;
    }

    public static boolean containedInIncludeFolders(@NotNull NativeIncludes includes, @NotNull VirtualFile file) {
        if (includes == null) {
            IncludesViewNode.$$$reportNull$$$0(4);
        }
        if (file == null) {
            IncludesViewNode.$$$reportNull$$$0(5);
        }
        if (!LexicalIncludePaths.hasHeaderExtension(file.getName())) {
            return false;
        }
        IncludeSet includeSet = IncludesViewNode.distinctIncludes(includes);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File include : includeSet.getIncludesInOrder()) {
            VirtualFile ancestor = fileSystem.findFileByIoFile(include);
            if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            IncludesViewNode.$$$reportNull$$$0(6);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Long startTime = System.currentTimeMillis();
        Collection<? extends AbstractTreeNode> collection = this.getChildrenImpl();
        Collection<? extends AbstractTreeNode> collection2 = collection;
        if (collection2 == null) {
            IncludesViewNode.$$$reportNull$$$0(7);
        }
        return collection2;
        finally {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CPP_HEADERS_VIEW_EVENT).setCppHeadersViewEvent(CppHeadersViewEvent.newBuilder().setEventDurationMs(System.currentTimeMillis() - startTime).setType(CppHeadersViewEvent.CppHeadersViewEventType.OPEN_TOP_INCLUDES_NODE)));
        }
    }

    @NotNull
    private Collection<? extends AbstractTreeNode> getChildrenImpl() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        Project project = this.getProject();
        if (project == null) {
            ArrayList<Object> arrayList = result2;
            if (arrayList == null) {
                IncludesViewNode.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        IncludeSet includeSet = IncludesViewNode.distinctIncludes(this.myDependencyInfo);
        ArrayList<SimpleIncludeValue> simpleIncludes = new ArrayList<SimpleIncludeValue>();
        for (File includeFolder : includeSet.getIncludesInOrder()) {
            simpleIncludes.add(IncludeResolver.getGlobalResolver(IdeSdks.getInstance().getAndroidNdkPath()).resolve(includeFolder));
        }
        List<IncludeValue> includes = IncludeValues.organize(simpleIncludes);
        for (IncludeValue include : includes) {
            if (include instanceof ShadowingIncludeValue) {
                ShadowingIncludeValue concrete = (ShadowingIncludeValue)include;
                result2.addAll(IncludeViewNodes.getIncludeFolderNodesWithShadowing(concrete.getIncludePathsInOrder(), VirtualFiles.convertToVirtualFile(concrete.myExcludes), false, project, this.getSettings()));
                continue;
            }
            if (include instanceof SimpleIncludeValue) {
                result2.add(new SimpleIncludeViewNode((SimpleIncludeValue)include, includeSet, true, this.getProject(), this.getSettings()));
                continue;
            }
            if (!(include instanceof ClassifiedIncludeValue)) continue;
            ClassifiedIncludeValue classifiedIncludeValue = (ClassifiedIncludeValue)include;
            result2.add(IncludeViewNode.createIncludeView(classifiedIncludeValue, includeSet, true, this.getProject(), this.getSettings()));
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            IncludesViewNode.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            IncludesViewNode.$$$reportNull$$$0(10);
        }
        return IncludesViewNode.containedInIncludeFolders(this.myDependencyInfo, file);
    }

    public int getTypeSortWeight(boolean sortByType) {
        return -100;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            IncludesViewNode.$$$reportNull$$$0(11);
        }
        presentation.addText("includes", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(AllIcons.Nodes.WebFolder);
    }

    @NotNull
    public String toString() {
        if ("includes" == null) {
            IncludesViewNode.$$$reportNull$$$0(12);
        }
        return "includes";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeIncludes";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/IncludesViewNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/IncludesViewNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "distinctIncludes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "distinctIncludes";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containedInIncludeFolders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

