/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.IncludeSet;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PsiIncludeDirectoryView;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleIncludeViewNode
extends IncludeViewNode<SimpleIncludeValue> {
    protected SimpleIncludeViewNode(@NotNull SimpleIncludeValue thisInclude, @NotNull IncludeSet allIncludes, boolean showPackageType, @Nullable Project project, @NotNull ViewSettings viewSettings) {
        if (thisInclude == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(0);
        }
        if (allIncludes == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(2);
        }
        super(thisInclude, allIncludes, showPackageType, project, viewSettings);
    }

    @NotNull
    private SimpleIncludeValue getSimpleIncludeValue() {
        SimpleIncludeValue value = (SimpleIncludeValue)this.getValue();
        assert (value != null);
        SimpleIncludeValue simpleIncludeValue = value;
        if (simpleIncludeValue == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(3);
        }
        return simpleIncludeValue;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Project project = this.getProject();
        if (project == null) {
            List list = Collections.EMPTY_LIST;
            if (list == null) {
                SimpleIncludeViewNode.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        SimpleIncludeValue value = this.getSimpleIncludeValue();
        VirtualFile virtualFile = fileSystem.findFileByIoFile(value.myIncludeFolder);
        if (virtualFile == null) {
            List list = Collections.EMPTY_LIST;
            if (list == null) {
                SimpleIncludeViewNode.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiDirectory directory = psiManager.findDirectory(virtualFile);
        if (directory == null) {
            List list = Collections.EMPTY_LIST;
            if (list == null) {
                SimpleIncludeViewNode.$$$reportNull$$$0(6);
            }
            return list;
        }
        Collection collection = new PsiIncludeDirectoryView(this.getProject(), (ImmutableList<VirtualFile>)ImmutableList.of(), false, directory, this.getSettings()).getChildren();
        if (collection == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(7);
        }
        return collection;
    }

    protected void update(@NotNull PresentationData presentation) {
        SimpleIncludeValue concrete;
        if (presentation == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(8);
        }
        if ((concrete = this.getSimpleIncludeValue()).getPackageType() == PackageType.IncludeFolder) {
            presentation.setIcon(AllIcons.Nodes.Folder);
        } else {
            presentation.setIcon(AllIcons.Nodes.JavaModuleRoot);
        }
        presentation.addText(concrete.mySimplePackageName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowPackageType && concrete.getPackageType() != PackageType.IncludeFolder) {
            presentation.addText(String.format(" (%s, ", concrete.getPackageType().myDescription), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (concrete.getPackageType() == PackageType.IncludeFolder) {
            String path = FileUtil.getLocationRelativeToUserHome((String)concrete.myIncludeFolder.getPath());
            path = LexicalIncludePaths.trimPathSeparators(path);
            path = FilenameUtils.separatorsToSystem((String)path);
            presentation.addText(String.format("%s)", path), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            String path = concrete.myRelativeIncludeSubFolder;
            path = LexicalIncludePaths.trimPathSeparators(path);
            path = FilenameUtils.separatorsToSystem((String)path);
            presentation.addText(String.format("%s)", path), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(9);
        }
        if (!LexicalIncludePaths.hasHeaderExtension(file.getName())) {
            return false;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        SimpleIncludeValue value = this.getSimpleIncludeValue();
        VirtualFile ancestor = fileSystem.findFileByIoFile(value.myIncludeFolder);
        return ancestor != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false);
    }

    @Override
    @NotNull
    public Comparable getSortKey() {
        SimpleIncludeValue value = this.getSimpleIncludeValue();
        if (value.getPackageType() != PackageType.IncludeFolder) {
            String string = "[icon-f]" + value.getSortKey();
            if (string == null) {
                SimpleIncludeViewNode.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = "[icon-m]" + value.getSortKey();
        if (string == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = ((SimpleIncludeValue)this.getValue()).toString();
        if (string == null) {
            SimpleIncludeViewNode.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisInclude";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allIncludes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/SimpleIncludeViewNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/SimpleIncludeViewNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleIncludeValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortKey";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

