/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public class ActionBarIconGenerator
extends IconGenerator {
    public static final Theme DEFAULT_THEME = Theme.HOLO_LIGHT;
    public static final Color DEFAULT_COLOR = new Color(51, 181, 229);
    private final ObjectProperty<Theme> myTheme = new ObjectValueProperty<Theme>(DEFAULT_THEME);
    private final ObjectProperty<Color> myCustomColor = new ObjectValueProperty<Color>(DEFAULT_COLOR);

    public ActionBarIconGenerator(int minSdkVersion2) {
        super(minSdkVersion2);
    }

    @NotNull
    public ObjectProperty<Theme> theme() {
        ObjectProperty<Theme> objectProperty = this.myTheme;
        if (objectProperty == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(0);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<Color> customColor() {
        ObjectProperty<Color> objectProperty = this.myCustomColor;
        if (objectProperty == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(1);
        }
        return objectProperty;
    }

    @Override
    @NotNull
    public ActionBarOptions createOptions(boolean forPreview) {
        ActionBarOptions options = new ActionBarOptions();
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            options.sourceImageFuture = asset.toImage();
            options.isTrimmed = (Boolean)asset.trimmed().get();
            options.paddingPercent = (Integer)asset.paddingPercent().get();
        }
        options.theme = (Theme)((Object)this.myTheme.get());
        if (options.theme == Theme.CUSTOM) {
            options.customThemeColor = ((Color)this.myCustomColor.get()).getRGB();
        }
        options.sourceIsClipart = asset instanceof VectorAsset;
        ActionBarOptions actionBarOptions = options;
        if (actionBarOptions == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(2);
        }
        return actionBarOptions;
    }

    @Override
    @NotNull
    public BufferedImage generate(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        if (context == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(3);
        }
        if (options == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(4);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                ActionBarIconGenerator.$$$reportNull$$$0(5);
            }
            return bufferedImage;
        }
        BufferedImage sourceImage = ActionBarIconGenerator.getTrimmedAndPaddedImage(options);
        if (sourceImage == null) {
            sourceImage = AssetStudioUtils.createDummyImage();
        }
        ActionBarOptions actionBarOptions = (ActionBarOptions)options;
        Rectangle iconSizeMdpi = new Rectangle(0, 0, 24, 24);
        Rectangle targetRectMdpi = new Rectangle(0, 0, 24, 24);
        double scaleFactor = ActionBarIconGenerator.getMdpiScaleFactor(options.density);
        Rectangle imageRect = AssetStudioUtils.scaleRectangle(iconSizeMdpi, scaleFactor);
        Rectangle targetRect = AssetStudioUtils.scaleRectangle(targetRectMdpi, scaleFactor);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)sourceImage, (Rectangle)targetRect);
        if (actionBarOptions.theme == Theme.CUSTOM) {
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(actionBarOptions.customThemeColor), 0.8)});
        } else if (actionBarOptions.theme == DEFAULT_THEME) {
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(0x333333), 0.6)});
        } else {
            assert (actionBarOptions.theme == Theme.HOLO_DARK);
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(0xFFFFFF), 0.8)});
        }
        g.dispose();
        g2.dispose();
        BufferedImage bufferedImage = outImage;
        if (bufferedImage == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(6);
        }
        return bufferedImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ActionBarIconGenerator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "theme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "customColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ActionBarIconGenerator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Theme {
        HOLO_DARK,
        HOLO_LIGHT,
        CUSTOM;

    }

    public static class ActionBarOptions
    extends IconGenerator.Options {
        public Theme theme = DEFAULT_THEME;
        public boolean sourceIsClipart = false;
        public int customThemeColor = 0;
    }
}

