/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.IconPickerDialog;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.BindingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VectorIconButton
extends JButton
implements AssetComponent<VectorAsset>,
Disposable,
PersistentStateComponent<PersistentState> {
    private static final String URL_PROPERTY = "url";
    private final VectorAsset myXmlAsset = new VectorAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myAssetListeners = new ArrayList<ActionListener>(1);
    @Nullable
    private VdIcon myIcon;

    public VectorIconButton() {
        this.addActionListener(actionEvent -> {
            IconPickerDialog iconPicker = new IconPickerDialog(this.myIcon);
            if (iconPicker.showAndGet()) {
                VdIcon selectedIcon = iconPicker.getSelectedIcon();
                assert (selectedIcon != null);
                this.updateIcon(selectedIcon);
            }
        });
        this.myXmlAsset.path().addListener(sender -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myAssetListeners) {
                listener2.actionPerformed(e);
            }
        });
        this.updateIcon(VectorIconButton.createIcon(MaterialDesignIcons.getDefaultIcon()));
    }

    private void updateIcon(@Nullable VdIcon selectedIcon) {
        this.myIcon = null;
        this.setIcon(null);
        if (selectedIcon != null) {
            try {
                File iconFile = new File(FileUtil.getTempDirectory(), selectedIcon.getName());
                InputStream iconStream = selectedIcon.getURL().openStream();
                FileOutputStream outputStream = new FileOutputStream(iconFile);
                FileUtil.copy((InputStream)iconStream, (OutputStream)outputStream);
                this.myXmlAsset.path().set(iconFile);
                int h = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
                VectorAsset.ParseResult result2 = this.myXmlAsset.parse(h, false);
                BufferedImage image = result2.getImage();
                if (image != null) {
                    image = VdIcon.adjustIconColor((Component)this, (BufferedImage)image);
                    this.setIcon(new ImageIcon(image));
                }
                this.myIcon = selectedIcon;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @NotNull
    public VectorAsset getAsset() {
        VectorAsset vectorAsset = this.myXmlAsset;
        if (vectorAsset == null) {
            VectorIconButton.$$$reportNull$$$0(0);
        }
        return vectorAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            VectorIconButton.$$$reportNull$$$0(1);
        }
        this.myAssetListeners.add(listener2);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myAssetListeners.clear();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        URL defaultIconUrl = MaterialDesignIcons.getDefaultIcon();
        URL iconUrl = this.myIcon == null ? defaultIconUrl : this.myIcon.getURL();
        state.set(URL_PROPERTY, iconUrl.toString(), defaultIconUrl.toString());
        PersistentState persistentState = state;
        if (persistentState == null) {
            VectorIconButton.$$$reportNull$$$0(2);
        }
        return persistentState;
    }

    public void loadState(@NotNull PersistentState state) {
        URL iconUrl;
        if (state == null) {
            VectorIconButton.$$$reportNull$$$0(3);
        }
        URL defaultIconUrl = MaterialDesignIcons.getDefaultIcon();
        try {
            iconUrl = new URL(state.get(URL_PROPERTY, defaultIconUrl.toString()));
        }
        catch (MalformedURLException e) {
            iconUrl = defaultIconUrl;
        }
        this.updateIcon(VectorIconButton.createIcon(iconUrl));
        if (this.myIcon == null && iconUrl.equals(defaultIconUrl)) {
            this.updateIcon(VectorIconButton.createIcon(defaultIconUrl));
        }
    }

    @Nullable
    private static VdIcon createIcon(@NotNull URL url) {
        if (url == null) {
            VectorIconButton.$$$reportNull$$$0(4);
        }
        try {
            return new VdIcon(url);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ui/VectorIconButton";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_PROPERTY;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsset";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ui/VectorIconButton";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAssetListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

