/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconGenerationProcessor {
    @NotNull
    private final List<Request> myImageRequests = new ArrayList<Request>();
    @Nullable
    private Request myRunningRequest;

    public void enqueue(@NotNull AndroidIconType iconType, @NotNull IconGenerator iconGenerator, @NotNull Consumer<IconGeneratorResult> onDone) {
        if (iconType == null) {
            IconGenerationProcessor.$$$reportNull$$$0(0);
        }
        if (iconGenerator == null) {
            IconGenerationProcessor.$$$reportNull$$$0(1);
        }
        if (onDone == null) {
            IconGenerationProcessor.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myImageRequests.stream().anyMatch(x -> {
            if (iconType == null) {
                IconGenerationProcessor.$$$reportNull$$$0(4);
            }
            return Objects.equals((Object)x.getIconType(), (Object)iconType);
        })) {
            return;
        }
        if (((Optional)iconGenerator.sourceAsset().get()).isPresent()) {
            IconGenerator.Options options = iconGenerator.createOptions(true);
            Request request = new Request(iconType, iconGenerator, options, onDone);
            this.myImageRequests.add(request);
        }
        this.processNextRequest();
    }

    private void processNextRequest() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myRunningRequest != null) {
            return;
        }
        if (this.myImageRequests.isEmpty()) {
            return;
        }
        this.myRunningRequest = this.myImageRequests.remove(0);
        Worker worker = new Worker(this.myRunningRequest, () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myRunningRequest = null;
            this.processNextRequest();
        });
        worker.execute();
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(IconGenerationProcessor.class);
        if (logger == null) {
            IconGenerationProcessor.$$$reportNull$$$0(3);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$enqueue$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Worker
    extends SwingWorker<Void, Void> {
        @NotNull
        private final Request myRequest;
        @NotNull
        private final Runnable myOnDone;

        public Worker(@NotNull Request request, @NotNull Runnable onDone) {
            if (request == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (onDone == null) {
                Worker.$$$reportNull$$$0(1);
            }
            this.myRequest = request;
            this.myOnDone = onDone;
        }

        @Override
        protected Void doInBackground() throws Exception {
            long nanoStart = System.nanoTime();
            this.myRequest.run();
            long nanoEnd = System.nanoTime();
            IconGenerationProcessor.getLog().info(String.format("Icons generated in %,d ms", (nanoEnd - nanoStart) / 1000000L));
            return null;
        }

        @Override
        protected void done() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                this.myRequest.done();
            }
            finally {
                ApplicationManager.getApplication().invokeLater(this.myOnDone, ModalityState.any());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "onDone";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor$Worker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Request {
        @NotNull
        private final AndroidIconType myType;
        @NotNull
        private final IconGenerator myIconGenerator;
        @NotNull
        private final Consumer<IconGeneratorResult> myOnDone;
        @NotNull
        private final IconGenerator.Options myOptions;
        @Nullable
        private IconGeneratorResult myGeneratorResult;

        public Request(@NotNull AndroidIconType iconType, @NotNull IconGenerator iconGenerator, @NotNull IconGenerator.Options options, @NotNull Consumer<IconGeneratorResult> onDone) {
            if (iconType == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (iconGenerator == null) {
                Request.$$$reportNull$$$0(1);
            }
            if (options == null) {
                Request.$$$reportNull$$$0(2);
            }
            if (onDone == null) {
                Request.$$$reportNull$$$0(3);
            }
            this.myType = iconType;
            this.myIconGenerator = iconGenerator;
            this.myOptions = options;
            this.myOnDone = onDone;
        }

        public void run() {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            this.myGeneratorResult = this.myIconGenerator.generateIcons(this.myOptions);
        }

        public void done() {
            this.myOnDone.accept(this.myGeneratorResult);
        }

        @NotNull
        public AndroidIconType getIconType() {
            AndroidIconType androidIconType = this.myType;
            if (androidIconType == null) {
                Request.$$$reportNull$$$0(4);
            }
            return androidIconType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconGenerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onDone";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor$Request";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIconType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

