/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.dynamicapp.ConfigureDynamicDeliveryStep;
import com.android.tools.idea.npw.dynamicapp.DynamicFeatureModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.FormFactorSdkControls;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.npw.validator.ModuleValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureDynamicModuleStep
extends SkippableWizardStep<DynamicFeatureModel> {
    private final JBScrollPane myRootPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private JPanel myPanel;
    private JTextField myModuleName;
    private JTextField myPackageName;
    private JComboBox<Module> myBaseApplication;
    private JLabel myTemplateIconTitle;
    private JLabel myTemplateIconDetail;
    private JPanel myFormFactorSdkControlsPanel;
    private FormFactorSdkControls myFormFactorSdkControls;

    public ConfigureDynamicModuleStep(final @NotNull DynamicFeatureModel model, final @NotNull String basePackage) {
        if (model == null) {
            ConfigureDynamicModuleStep.$$$reportNull$$$0(0);
        }
        if (basePackage == null) {
            ConfigureDynamicModuleStep.$$$reportNull$$$0(1);
        }
        super(model, AndroidBundle.message("android.wizard.module.config.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        Expression<String> computedPackageName = new Expression<String>(new ObservableValue[]{model.moduleName()}){

            @Override
            @NotNull
            public String get() {
                String string = String.format("%s.%s", basePackage, NewProjectModel.toPackagePart((String)model.moduleName().get()));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/dynamicapp/ConfigureDynamicModuleStep$1", "get"));
            }
        };
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model.packageName(), packageNameText);
        this.myListeners.receive(packageNameText, value -> isPackageNameSynced.set(value.equals(computedPackageName.get())));
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myRootPanel = StudioWizardStepPanel.wrappedWithVScroll((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        List<ConfigureDynamicDeliveryStep> list = Collections.singletonList(new ConfigureDynamicDeliveryStep((DynamicFeatureModel)this.getModel()));
        if (list == null) {
            ConfigureDynamicModuleStep.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfigureDynamicModuleStep.$$$reportNull$$$0(3);
        }
        StringProperty modelName = ((DynamicFeatureModel)this.getModel()).moduleName();
        Project project = ((DynamicFeatureModel)this.getModel()).getProject();
        this.myBindings.bindTwoWay(new TextProperty(this.myModuleName), modelName);
        StringValueProperty companyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(false));
        String basePackage = new DomainToPackageExpression(companyDomain, new StringValueProperty("")).get();
        Expression<String> computedPackageName = modelName.transform(appName -> String.format("%s.%s", basePackage, NewProjectModel.toPackagePart(appName)));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(((DynamicFeatureModel)this.getModel()).packageName(), packageNameText);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myListeners.receive(packageNameText, value -> isPackageNameSynced.set(value.equals(computedPackageName.get())));
        OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo = ((DynamicFeatureModel)this.getModel()).androidSdkInfo();
        this.myFormFactorSdkControls.init(androidSdkInfo, this);
        AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(0).stream().filter(module -> AndroidModuleModel.get(module) != null).forEach(module -> this.myBaseApplication.addItem((Module)module));
        OptionalProperty<Module> baseApplication = ((DynamicFeatureModel)this.getModel()).baseApplication();
        this.myBindings.bind(baseApplication, new SelectedItemProperty(this.myBaseApplication));
        this.myValidatorPanel.registerValidator((ObservableValue)modelName, value -> value.isEmpty() ? new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.module.name", new Object[0])) : Validator.Result.OK);
        this.myValidatorPanel.registerValidator((ObservableValue)((DynamicFeatureModel)this.getModel()).packageName(), value -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value)));
        this.myValidatorPanel.registerValidator(androidSdkInfo, value -> value.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("select.target.dialog.text", new Object[0])));
        this.myValidatorPanel.registerValidator(baseApplication, value -> value.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.new.dynamic.select.base", new Object[0])));
        ModuleValidator moduleValidator = new ModuleValidator(project);
        modelName.set(WizardUtils.getUniqueName((String)modelName.get(), moduleValidator));
        this.myValidatorPanel.registerValidator((ObservableValue)modelName, (Validator)new ModuleValidator(project));
    }

    @Override
    protected void onEntering() {
        FormFactor formFactor = FormFactor.MOBILE;
        TemplateHandle templateHandle = ((DynamicFeatureModel)this.getModel()).getTemplateHandle();
        this.myFormFactorSdkControls.startDataLoading(formFactor, templateHandle.getMetadata().getMinSdk());
        this.setTemplateThumbnail(templateHandle);
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myRootPanel;
        if (jBScrollPane == null) {
            ConfigureDynamicModuleStep.$$$reportNull$$$0(4);
        }
        return jBScrollPane;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myModuleName;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfigureDynamicModuleStep.$$$reportNull$$$0(5);
        }
        return observableBool;
    }

    private void setTemplateThumbnail(@Nullable TemplateHandle templateHandle) {
        Image image = ActivityGallery.getTemplateImage(templateHandle, false);
        if (image != null) {
            this.myTemplateIconTitle.setIcon(new ImageIcon(image.getScaledInstance(256, 256, 4)));
        }
        this.myTemplateIconTitle.setText(ActivityGallery.getTemplateImageLabel(templateHandle, false));
        this.myTemplateIconDetail.setText("<html><center>" + ActivityGallery.getTemplateDescription(templateHandle, false) + "</center></html>");
    }

    private void createUIComponents() {
        this.myBaseApplication = new ComboBox(new DefaultComboBoxModel());
        this.myBaseApplication.setRenderer((ListCellRenderer<Module>)new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module module, int index, boolean selected, boolean hasFocus) {
                if (module == null) {
                    this.setText(AndroidBundle.message("android.wizard.module.config.new.base.missing", new Object[0]));
                } else {
                    this.setIcon(ModuleType.get((Module)module).getIcon());
                    this.setText(module.getName());
                }
            }
        });
        this.myFormFactorSdkControls = new FormFactorSdkControls();
        this.myFormFactorSdkControls.showStatsPanel(false);
        this.myFormFactorSdkControlsPanel = this.myFormFactorSdkControls.getRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePackage";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/dynamicapp/ConfigureDynamicModuleStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/dynamicapp/ConfigureDynamicModuleStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        Font font = this.$$$getFont$$$(null, 0, -1, jLabel3.getFont());
        if (font != null) {
            jLabel3.setFont(font);
        }
        jLabel3.setText("Package name");
        jLabel3.setDisplayedMnemonic('P');
        jLabel3.setDisplayedMnemonicIndex(0);
        jLabel3.setVerticalAlignment(0);
        jPanel.add((Component)jLabel3, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleName = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The name that will be shown in the Android launcher for this application");
        jPanel.add((Component)jTextField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(8, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 10, 1, 1, 1, 3, 3, null, new Dimension(250, -1), new Dimension(250, -1)));
        this.myTemplateIconTitle = jLabel2 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, -1, 18, jLabel2.getFont());
        if (font2 != null) {
            jLabel2.setFont(font2);
        }
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setHorizontalTextPosition(0);
        jLabel2.setText("Template Label");
        jLabel2.setVerticalTextPosition(3);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 6, 6, null, null, null));
        this.myTemplateIconDetail = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setText("Detail");
        jLabel.setVerticalAlignment(1);
        jLabel.setVerticalTextPosition(1);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 1, 0, 7, 7, null, new Dimension(220, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(9, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel3 = this.myFormFactorSdkControlsPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(10, 1, 1, 1, 1, 1, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setFocusable(true);
        Font font3 = this.$$$getFont$$$(null, 0, -1, jLabel4.getFont());
        if (font3 != null) {
            jLabel4.setFont(font3);
        }
        jLabel4.setText("Base application module");
        jLabel4.setDisplayedMnemonic('B');
        jLabel4.setDisplayedMnemonicIndex(0);
        jLabel4.setVerticalAlignment(0);
        jPanel.add((Component)jLabel4, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<Module> jComboBox = this.myBaseApplication;
        jComboBox.setName("baseComboBox");
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        Font font4 = this.$$$getFont$$$(null, 0, -1, jLabel5.getFont());
        if (font4 != null) {
            jLabel5.setFont(font4);
        }
        jLabel5.setText("Module name");
        jLabel5.setDisplayedMnemonic('M');
        jLabel5.setDisplayedMnemonicIndex(0);
        jLabel5.setVerticalAlignment(0);
        jPanel.add((Component)jLabel5, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 0, 1, 2, 0, 2, 1, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(11, 0, 1, 2, 0, 2, 1, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel5.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

