/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.project.IndexingSuspender;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiTemplateRenderer {
    private static final Topic<TemplateRendererListener> TEMPLATE_RENDERER_TOPIC = new Topic("Template rendering", TemplateRendererListener.class);
    @Nullable
    private Project myProject;
    private final List<TemplateRenderer> myTemplateRenderers = new ArrayList<TemplateRenderer>();
    private int myRequestCount = 1;

    public MultiTemplateRenderer(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull TemplateRendererListener listener2) {
        if (project == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(1);
        }
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(TEMPLATE_RENDERER_TOPIC, (Object)listener2);
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(2);
        }
        return messageBusConnection;
    }

    public static void multiRenderingStarted(@NotNull Project project) {
        if (project == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(3);
        }
        ((TemplateRendererListener)project.getMessageBus().syncPublisher(TEMPLATE_RENDERER_TOPIC)).multiRenderingStarted();
    }

    public static void multiRenderingFinished(@NotNull Project project) {
        if (project == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(4);
        }
        ((TemplateRendererListener)project.getMessageBus().syncPublisher(TEMPLATE_RENDERER_TOPIC)).multiRenderingFinished();
    }

    public void setProject(@NotNull Project project) {
        if (project == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(5);
        }
        this.myProject = project;
    }

    public void incrementRenders() {
        ++this.myRequestCount;
    }

    public void requestRender(@NotNull TemplateRenderer templateRenderer) {
        if (templateRenderer == null) {
            MultiTemplateRenderer.$$$reportNull$$$0(6);
        }
        this.myTemplateRenderers.add(templateRenderer);
        this.countDown();
    }

    public void skipRender() {
        this.countDown();
    }

    private void countDown() {
        if (this.myRequestCount == 0) {
            throw new IllegalStateException("Invalid extra call to MultiTemplateRenderer#countDown");
        }
        --this.myRequestCount;
        if (this.myRequestCount == 0 && !this.myTemplateRenderers.isEmpty()) {
            assert (this.myProject != null) : "Project instance is always expected to be not null at this point.";
            IndexingSuspender.ensureInitialised(this.myProject);
            MultiTemplateRenderer.multiRenderingStarted(this.myProject);
            try {
                for (TemplateRenderer renderer : this.myTemplateRenderers) {
                    renderer.init();
                }
                for (TemplateRenderer renderer : this.myTemplateRenderers) {
                    if (renderer.doDryRun()) continue;
                    return;
                }
                for (TemplateRenderer renderer : this.myTemplateRenderers) {
                    renderer.render();
                }
                ProjectSystemUtil.getProjectSystem(this.myProject).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
            }
            finally {
                MultiTemplateRenderer.multiRenderingFinished(this.myProject);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/model/MultiTemplateRenderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/model/MultiTemplateRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "multiRenderingStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "multiRenderingFinished";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestRender";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TemplateRenderer {
        default public void init() {
        }

        public boolean doDryRun();

        public void render();
    }

    public static interface TemplateRendererListener {
        default public void multiRenderingStarted() {
        }

        default public void multiRenderingFinished() {
        }
    }
}

