/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.gradle.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.ParameterValueResolver;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class NewProjectModuleModel
extends WizardModel {
    public static final String EMPTY_ACTIVITY = "Empty Activity";
    public static final String ANDROID_MODULE = "Android Module";
    @NotNull
    private final NewProjectModel myProjectModel;
    @NotNull
    private final NewModuleModel myNewModuleModel;
    @NotNull
    private final RenderTemplateModel myExtraRenderTemplateModel;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo;
    @NotNull
    private final ObjectProperty<FormFactor> myFormFactor;
    @NotNull
    private final OptionalProperty<TemplateHandle> myRenderTemplateHandle;
    @NotNull
    private final BoolProperty myHasCompanionApp;

    public NewProjectModuleModel(@NotNull NewProjectModel projectModel) {
        if (projectModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(0);
        }
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myFormFactor = new ObjectValueProperty<FormFactor>(FormFactor.MOBILE);
        this.myRenderTemplateHandle = new OptionalValueProperty<TemplateHandle>();
        this.myHasCompanionApp = new BoolValueProperty();
        this.myProjectModel = projectModel;
        this.myNewModuleModel = new NewModuleModel(this.myProjectModel, new File(""));
        this.myExtraRenderTemplateModel = new RenderTemplateModel(this.myNewModuleModel, null, GradleAndroidModuleTemplate.createDummyTemplate(), AndroidBundle.message("android.wizard.config.activity.title", new Object[0]));
    }

    @NotNull
    public BoolProperty instantApp() {
        BoolProperty boolProperty = this.myNewModuleModel.instantApp();
        if (boolProperty == null) {
            NewProjectModuleModel.$$$reportNull$$$0(1);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty includeNavController() {
        BoolProperty boolProperty = this.myNewModuleModel.includeNavController();
        if (boolProperty == null) {
            NewProjectModuleModel.$$$reportNull$$$0(2);
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        OptionalProperty<AndroidVersionsInfo.VersionItem> optionalProperty = this.myAndroidSdkInfo;
        if (optionalProperty == null) {
            NewProjectModuleModel.$$$reportNull$$$0(3);
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<File> moduleTemplateFile() {
        OptionalProperty<File> optionalProperty = this.myNewModuleModel.templateFile();
        if (optionalProperty == null) {
            NewProjectModuleModel.$$$reportNull$$$0(4);
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<TemplateHandle> renderTemplateHandle() {
        OptionalProperty<TemplateHandle> optionalProperty = this.myRenderTemplateHandle;
        if (optionalProperty == null) {
            NewProjectModuleModel.$$$reportNull$$$0(5);
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty hasCompanionApp() {
        BoolProperty boolProperty = this.myHasCompanionApp;
        if (boolProperty == null) {
            NewProjectModuleModel.$$$reportNull$$$0(6);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<FormFactor> formFactor() {
        ObjectProperty<FormFactor> objectProperty = this.myFormFactor;
        if (objectProperty == null) {
            NewProjectModuleModel.$$$reportNull$$$0(7);
        }
        return objectProperty;
    }

    @NotNull
    public RenderTemplateModel getExtraRenderTemplateModel() {
        RenderTemplateModel renderTemplateModel = this.myExtraRenderTemplateModel;
        if (renderTemplateModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(8);
        }
        return renderTemplateModel;
    }

    @Override
    protected void handleFinished() {
        boolean noActivitySelected;
        this.myProjectModel.getNewModuleModels().clear();
        Project project = this.myNewModuleModel.getProject().getValueOrNull();
        String projectLocation = (String)this.myProjectModel.projectLocation().get();
        boolean hasCompanionApp = (Boolean)this.myHasCompanionApp.get();
        this.initMainModule();
        Map<String, Object> projectTemplateValues = this.myProjectModel.getTemplateValues();
        NewProjectModuleModel.addModuleToProject(this.myNewModuleModel, (FormFactor)((Object)this.myFormFactor.get()), this.myProjectModel, projectTemplateValues);
        int formFactorsCount = 1;
        if (hasCompanionApp) {
            ++formFactorsCount;
            NewModuleModel companionModuleModel = NewProjectModuleModel.createCompanionModuleModel(this.myProjectModel);
            RenderTemplateModel companionRenderModel = NewProjectModuleModel.createCompanionRenderModel(projectLocation, companionModuleModel);
            NewProjectModuleModel.addModuleToProject(companionModuleModel, FormFactor.MOBILE, this.myProjectModel, projectTemplateValues);
            companionRenderModel.androidSdkInfo().setValue(this.androidSdkInfo().getValue());
            companionModuleModel.getRenderTemplateValues().setValue(companionRenderModel.getTemplateValues());
            companionModuleModel.handleFinished();
            companionRenderModel.handleFinished();
        }
        projectTemplateValues.put("NumberOfEnabledFormFactors", formFactorsCount);
        RenderTemplateModel newRenderTemplateModel = this.createMainRenderModel(projectLocation);
        this.myNewModuleModel.getRenderTemplateValues().setValue(newRenderTemplateModel.getTemplateValues());
        boolean bl = noActivitySelected = newRenderTemplateModel.getTemplateHandle() == null;
        if (noActivitySelected) {
            this.myNewModuleModel.setDefaultRenderTemplateValues(newRenderTemplateModel, project);
        } else if (newRenderTemplateModel != this.myExtraRenderTemplateModel) {
            NewProjectModuleModel.addRenderDefaultTemplateValues(newRenderTemplateModel);
        }
        new TemplateValueInjector(this.myNewModuleModel.getTemplateValues()).setProjectDefaults(project, (String)this.myNewModuleModel.applicationName().get(), (Boolean)this.myNewModuleModel.instantApp().get());
        this.myNewModuleModel.handleFinished();
        if (newRenderTemplateModel != this.myExtraRenderTemplateModel) {
            if (noActivitySelected) {
                newRenderTemplateModel.handleSkipped();
            } else {
                newRenderTemplateModel.handleFinished();
            }
        }
    }

    private void initMainModule() {
        String moduleName;
        if (((Boolean)this.myHasCompanionApp.get()).booleanValue()) {
            moduleName = NewProjectModuleModel.getModuleName((FormFactor)((Object)this.myFormFactor.get()));
        } else if (((Boolean)this.myNewModuleModel.instantApp().get()).booleanValue()) {
            moduleName = (String)this.myNewModuleModel.splitName().get();
            this.myNewModuleModel.packageName().set(this.myNewModuleModel.computedFeatureModulePackageName().get());
        } else {
            moduleName = "app";
        }
        this.myNewModuleModel.moduleName().set(moduleName);
    }

    @NotNull
    private RenderTemplateModel createMainRenderModel(String projectLocation) {
        RenderTemplateModel newRenderTemplateModel;
        File moduleRoot = new File(projectLocation, (String)this.myNewModuleModel.moduleName().get());
        if (((Boolean)this.myProjectModel.enableCppSupport().get()).booleanValue()) {
            newRenderTemplateModel = NewProjectModuleModel.createCompanionRenderModel(projectLocation, this.myNewModuleModel);
        } else if (this.myExtraRenderTemplateModel.getTemplateHandle() == null) {
            newRenderTemplateModel = new RenderTemplateModel(this.myNewModuleModel, null, GradleAndroidModuleTemplate.createDefaultTemplateAt(moduleRoot), "");
            newRenderTemplateModel.setTemplateHandle(this.renderTemplateHandle().getValueOrNull());
        } else {
            newRenderTemplateModel = this.myExtraRenderTemplateModel;
            this.myExtraRenderTemplateModel.getTemplate().set(GradleAndroidModuleTemplate.createDefaultTemplateAt(moduleRoot));
        }
        newRenderTemplateModel.androidSdkInfo().setValue(this.androidSdkInfo().getValue());
        RenderTemplateModel renderTemplateModel = newRenderTemplateModel;
        if (renderTemplateModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(9);
        }
        return renderTemplateModel;
    }

    private static void addModuleToProject(@NotNull NewModuleModel moduleModel, @NotNull FormFactor formFactor, @NotNull NewProjectModel projectModel, @NotNull Map<String, Object> projectTemplateValues) {
        if (moduleModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(10);
        }
        if (formFactor == null) {
            NewProjectModuleModel.$$$reportNull$$$0(11);
        }
        if (projectModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(12);
        }
        if (projectTemplateValues == null) {
            NewProjectModuleModel.$$$reportNull$$$0(13);
        }
        projectTemplateValues.put(formFactor.id + "included", true);
        projectTemplateValues.put(formFactor.id + "projectName", moduleModel.moduleName().get());
        projectModel.getNewModuleModels().add(moduleModel);
    }

    @NotNull
    private static NewModuleModel createCompanionModuleModel(@NotNull NewProjectModel projectModel) {
        if (projectModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(14);
        }
        File moduleTemplateFile = TemplateManager.getInstance().getTemplateFile("Application", ANDROID_MODULE);
        NewModuleModel companionModuleModel = new NewModuleModel(projectModel, moduleTemplateFile);
        companionModuleModel.moduleName().set(NewProjectModuleModel.getModuleName(FormFactor.MOBILE));
        new TemplateValueInjector(companionModuleModel.getTemplateValues()).setProjectDefaults(projectModel.project().getValueOrNull(), (String)companionModuleModel.applicationName().get(), false);
        NewModuleModel newModuleModel = companionModuleModel;
        if (newModuleModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(15);
        }
        return newModuleModel;
    }

    @NotNull
    private static RenderTemplateModel createCompanionRenderModel(@NotNull String projectLocation, @NotNull NewModuleModel moduleModel) {
        if (projectLocation == null) {
            NewProjectModuleModel.$$$reportNull$$$0(16);
        }
        if (moduleModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(17);
        }
        File mobileModuleRoot = new File(projectLocation, (String)moduleModel.moduleName().get());
        NamedModuleTemplate namedModuleTemplate = GradleAndroidModuleTemplate.createDefaultTemplateAt(mobileModuleRoot);
        File renderTemplateFile = TemplateManager.getInstance().getTemplateFile("Activity", EMPTY_ACTIVITY);
        TemplateHandle renderTemplateHandle = new TemplateHandle(renderTemplateFile);
        RenderTemplateModel companionRenderModel = new RenderTemplateModel(moduleModel, renderTemplateHandle, namedModuleTemplate, "");
        NewProjectModuleModel.addRenderDefaultTemplateValues(companionRenderModel);
        RenderTemplateModel renderTemplateModel = companionRenderModel;
        if (renderTemplateModel == null) {
            NewProjectModuleModel.$$$reportNull$$$0(18);
        }
        return renderTemplateModel;
    }

    @NotNull
    private static String getModuleName(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            NewProjectModuleModel.$$$reportNull$$$0(19);
        }
        if (formFactor.baseFormFactor != null) {
            formFactor = formFactor.baseFormFactor;
        }
        String string = formFactor.id.replaceAll("\\s", "_").toLowerCase(Locale.US);
        if (string == null) {
            NewProjectModuleModel.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static void addRenderDefaultTemplateValues(RenderTemplateModel renderTemplateModel) {
        Map<String, Object> templateValues = renderTemplateModel.getTemplateValues();
        TemplateMetadata templateMetadata = renderTemplateModel.getTemplateHandle().getMetadata();
        HashMap userValues = Maps.newHashMap();
        HashMap additionalValues = Maps.newHashMap();
        String packageName = (String)renderTemplateModel.packageName().get();
        boolean isInstantApp = (Boolean)renderTemplateModel.instantApp().get();
        new TemplateValueInjector(additionalValues).addTemplateAdditionalValues(packageName, isInstantApp, renderTemplateModel.getTemplate());
        additionalValues.put("packageName", renderTemplateModel.packageName().get());
        try {
            Collection<Parameter> renderParameters = templateMetadata.getParameters();
            Map<Parameter, Object> parameterValues = ParameterValueResolver.resolve(renderParameters, userValues, additionalValues);
            parameterValues.forEach((parameter, value) -> templateValues.put(parameter.id, value));
        }
        catch (CircularParameterDependencyException e) {
            NewProjectModuleModel.getLog().error("Circular dependency between parameters in template %1$s", (Throwable)e, new String[]{templateMetadata.getTitle()});
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(NewProjectModuleModel.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/model/NewProjectModuleModel";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTemplateValues";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/model/NewProjectModuleModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "instantApp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "includeNavController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "androidSdkInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleTemplateFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "renderTemplateHandle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "hasCompanionApp";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formFactor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraRenderTemplateModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainRenderModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompanionModuleModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompanionRenderModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addModuleToProject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCompanionModuleModel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCompanionRenderModel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

