/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.npw.project.GradleBuildSettings;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.npw.model.JavaToKotlinHandler;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.template.ConvertJavaToKotlinProvider;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.GuiTestingService;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public final class TemplateValueInjector {
    private final Map<String, Object> myTemplateValues;

    public TemplateValueInjector(@NotNull Map<String, Object> templateValues) {
        if (templateValues == null) {
            TemplateValueInjector.$$$reportNull$$$0(0);
        }
        this.myTemplateValues = templateValues;
    }

    public TemplateValueInjector setFacet(@NotNull AndroidFacet facet) {
        if (facet == null) {
            TemplateValueInjector.$$$reportNull$$$0(1);
        }
        TemplateValueInjector.addDebugKeyStore(this.myTemplateValues, facet);
        this.myTemplateValues.put("isNewProject", false);
        this.myTemplateValues.put("isLibraryProject", ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject());
        String appTheme = MergedManifest.get(facet).getManifestTheme();
        this.myTemplateValues.put("hasApplicationTheme", appTheme != null);
        Module module = facet.getModule();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            IAndroidTarget target = platform.getTarget();
            this.myTemplateValues.put("buildApi", target.getVersion().getFeatureLevel());
            this.myTemplateValues.put("buildApiString", TemplateMetadata.getBuildApiString(target.getVersion()));
            this.myTemplateValues.put("buildApiRevision", target.getVersion().isPreview() ? target.getRevision() : 0);
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        AndroidVersion minSdkVersion2 = moduleInfo.getMinSdkVersion();
        String minSdkName = minSdkVersion2.getApiString();
        this.myTemplateValues.put("minApi", minSdkName);
        this.myTemplateValues.put("targetApi", moduleInfo.getTargetSdkVersion().getApiLevel());
        this.myTemplateValues.put("minApiLevel", minSdkVersion2.getFeatureLevel());
        Project project = module.getProject();
        this.addGradleVersions(project);
        this.addKotlinVersion();
        int projectType = ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType();
        if (projectType == 5) {
            this.setInstantAppSupport(true, project, module.getName());
        } else if (projectType == 6) {
            this.setDynamicFeatureSupport(module);
        }
        return this;
    }

    public TemplateValueInjector setBuildVersion(@NotNull AndroidVersionsInfo.VersionItem buildVersion, @Nullable Project project) {
        BuildToolInfo info;
        if (buildVersion == null) {
            TemplateValueInjector.$$$reportNull$$$0(2);
        }
        TemplateValueInjector.addDebugKeyStore(this.myTemplateValues, null);
        this.myTemplateValues.put("isNewProject", true);
        this.myTemplateValues.put("themeExists", true);
        this.myTemplateValues.put("minApiLevel", buildVersion.getMinApiLevel());
        this.myTemplateValues.put("minApi", buildVersion.getMinApiLevelStr());
        this.myTemplateValues.put("buildApi", buildVersion.getBuildApiLevel());
        this.myTemplateValues.put("buildApiString", buildVersion.getBuildApiLevelStr());
        this.myTemplateValues.put("targetApi", buildVersion.getTargetApiLevel());
        this.myTemplateValues.put("targetApiString", buildVersion.getTargetApiLevelStr());
        IAndroidTarget target = buildVersion.getAndroidTarget();
        this.myTemplateValues.put("buildApiRevision", target == null ? 0 : target.getRevision());
        if (target != null && (info = target.getBuildToolInfo()) != null) {
            this.myTemplateValues.put("buildToolsVersion", info.getRevision().toString());
        }
        this.addGradleVersions(project);
        this.addKotlinVersion();
        return this;
    }

    public TemplateValueInjector setJavaVersion(Project project) {
        LanguageLevel min = (LanguageLevel)ApplicationManager.getApplication().runReadAction(() -> {
            LanguageLevel minResult = null;
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                LanguageLevel moduleLevel;
                LanguageLevelModuleExtensionImpl moduleLevelExt = LanguageLevelModuleExtensionImpl.getInstance((Module)module);
                if (moduleLevelExt == null || (moduleLevel = moduleLevelExt.getLanguageLevel()) == null || minResult != null && moduleLevel.compareTo((Enum)minResult) >= 0) continue;
                minResult = moduleLevel;
            }
            return minResult == null ? LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel() : minResult;
        });
        this.myTemplateValues.put("javaVersion", JpsJavaSdkType.complianceOption((JavaVersion)min.toJavaVersion()));
        return this;
    }

    public TemplateValueInjector setModuleRoots(@NotNull AndroidModuleTemplate paths, @NotNull String packageName) {
        File aidlDir;
        File manifestDir;
        File resDir;
        File testDir;
        if (paths == null) {
            TemplateValueInjector.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            TemplateValueInjector.$$$reportNull$$$0(4);
        }
        File moduleRoot = paths.getModuleRoot();
        assert (moduleRoot != null);
        this.myTemplateValues.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        File srcDir = paths.getSrcDirectory(packageName);
        if (srcDir != null) {
            this.myTemplateValues.put("srcDir", TemplateValueInjector.getRelativePath(moduleRoot, srcDir));
            this.myTemplateValues.put("srcOut", FileUtil.toSystemIndependentName((String)srcDir.getAbsolutePath()));
        }
        if ((testDir = paths.getTestDirectory(packageName)) != null) {
            this.myTemplateValues.put("testDir", TemplateValueInjector.getRelativePath(moduleRoot, testDir));
            this.myTemplateValues.put("testOut", FileUtil.toSystemIndependentName((String)testDir.getAbsolutePath()));
        }
        if ((resDir = paths.getResDirectory()) != null) {
            this.myTemplateValues.put("resDir", TemplateValueInjector.getRelativePath(moduleRoot, resDir));
            this.myTemplateValues.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = paths.getManifestDirectory()) != null) {
            this.myTemplateValues.put("manifestDir", TemplateValueInjector.getRelativePath(moduleRoot, manifestDir));
            this.myTemplateValues.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = paths.getAidlDirectory(packageName)) != null) {
            this.myTemplateValues.put("aidlDir", TemplateValueInjector.getRelativePath(moduleRoot, aidlDir));
            this.myTemplateValues.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        this.myTemplateValues.put("projectLocation", moduleRoot.getParent());
        this.myTemplateValues.put("projectName", moduleRoot.getName());
        this.myTemplateValues.put("packageName", packageName);
        return this;
    }

    public TemplateValueInjector setProjectDefaults(@Nullable Project project, @NotNull String moduleTitle, boolean isInstantApp) {
        if (moduleTitle == null) {
            TemplateValueInjector.$$$reportNull$$$0(5);
        }
        this.myTemplateValues.put("appTitle", moduleTitle);
        this.myTemplateValues.put("isLowMemory", SystemInfo.is32Bit);
        this.addGradleVersions(project);
        this.addKotlinVersion();
        this.myTemplateValues.put("isGradle", true);
        this.myTemplateValues.put("target.files", new HashSet());
        this.myTemplateValues.put("files.to.open", new ArrayList());
        this.myTemplateValues.put("createActivity", false);
        if (project != null) {
            this.myTemplateValues.put("topOut", project.getBasePath());
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ConfigureAndroidModuleStep.class);
        Revision buildToolRevision = GradleBuildSettings.getRecommendedBuildToolsRevision(sdkHandler, (ProgressIndicator)progress, isInstantApp);
        this.myTemplateValues.put("buildToolsVersion", buildToolRevision.toString());
        File sdkLocation = sdkHandler.getLocation();
        if (sdkLocation != null) {
            this.myTemplateValues.put("sdkDir", sdkLocation.getPath());
            String espressoVersion = RepositoryUrlManager.get().getLibraryRevision(GoogleMavenArtifactId.ESPRESSO_CORE.getMavenGroupId(), GoogleMavenArtifactId.ESPRESSO_CORE.getMavenArtifactId(), null, false, sdkLocation, FileOpUtils.create());
            if (espressoVersion == null) {
                espressoVersion = RepositoryUrlManager.get().getLibraryRevision(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE.getMavenGroupId(), GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE.getMavenArtifactId(), null, false, sdkLocation, FileOpUtils.create());
            }
            if (espressoVersion != null) {
                this.myTemplateValues.put("espressoVersion", espressoVersion);
            }
        }
        return this;
    }

    public TemplateValueInjector setInstantAppSupport(boolean isExistingProject, @NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            TemplateValueInjector.$$$reportNull$$$0(6);
        }
        if (moduleName == null) {
            TemplateValueInjector.$$$reportNull$$$0(7);
        }
        this.myTemplateValues.put("isInstantApp", true);
        this.myTemplateValues.put("instantAppApiMinVersion", InstantApps.getCompatApiMinVersion());
        this.myTemplateValues.put("isLibraryProject", true);
        String projectPath = project.getBasePath();
        assert (projectPath != null);
        String defaultResourceSuffix = FileUtil.join((String[])new String[]{"src", "main", "res"});
        File projectRoot = new File(projectPath);
        File baseModuleRoot = new File(projectRoot, "base");
        File baseModuleResourceRoot = new File(baseModuleRoot, defaultResourceSuffix);
        Module baseFeature = null;
        if (isExistingProject && (baseFeature = InstantApps.findBaseFeature(project)) == null) {
            baseModuleRoot = new File(projectRoot, moduleName);
            baseModuleResourceRoot = new File(baseModuleRoot, defaultResourceSuffix);
            this.myTemplateValues.put("isBaseFeature", true);
            String monolithicModuleName = InstantApps.findMonolithicModuleName(project);
            if (monolithicModuleName != null) {
                this.myTemplateValues.put("monolithicModuleName", monolithicModuleName);
            }
        }
        if (baseFeature == null) {
            this.myTemplateValues.put("baseFeatureName", baseModuleRoot.getName());
            this.myTemplateValues.put("baseFeatureDir", baseModuleRoot.getPath());
            this.myTemplateValues.put("baseFeatureResDir", baseModuleResourceRoot.getPath());
        } else {
            this.setBaseFeature(baseFeature);
        }
        return this;
    }

    public TemplateValueInjector setDynamicFeatureSupport(@NotNull Module module) {
        if (module == null) {
            TemplateValueInjector.$$$reportNull$$$0(8);
        }
        this.myTemplateValues.put("isDynamicFeature", true);
        Module baseFeature = DynamicAppUtils.getBaseFeature(module);
        if (baseFeature == null) {
            throw new RuntimeException("Dynamic Feature Module '" + module.getName() + "' has no Base Module");
        }
        return this.setBaseFeature(baseFeature);
    }

    public TemplateValueInjector setBaseFeature(@NotNull Module baseFeature) {
        if (baseFeature == null) {
            TemplateValueInjector.$$$reportNull$$$0(9);
        }
        AndroidModuleModel moduleModel = AndroidModuleModel.get(baseFeature);
        assert (moduleModel != null);
        File baseModuleRoot = moduleModel.getRootDirPath();
        Collection resDirectories = moduleModel.getDefaultSourceProvider().getResDirectories();
        assert (!resDirectories.isEmpty());
        File baseModuleResourceRoot = (File)resDirectories.iterator().next();
        this.myTemplateValues.put("baseFeatureName", baseModuleRoot.getName());
        this.myTemplateValues.put("baseFeatureDir", baseModuleRoot.getPath());
        this.myTemplateValues.put("baseFeatureResDir", baseModuleResourceRoot.getPath());
        return this;
    }

    public void addGradleVersions(@Nullable Project project) {
        this.myTemplateValues.put("gradlePluginVersion", TemplateValueInjector.determineGradlePluginVersion(project));
        this.myTemplateValues.put("gradleVersion", "4.6");
    }

    public TemplateValueInjector addTemplateAdditionalValues(@NotNull String packageName, boolean isInstantApp, @NotNull ObjectProperty<NamedModuleTemplate> template) {
        if (packageName == null) {
            TemplateValueInjector.$$$reportNull$$$0(10);
        }
        if (template == null) {
            TemplateValueInjector.$$$reportNull$$$0(11);
        }
        this.myTemplateValues.put("packageName", packageName);
        this.myTemplateValues.put("sourceProviderName", ((NamedModuleTemplate)template.get()).getName());
        this.myTemplateValues.put("isInstantApp", isInstantApp);
        this.myTemplateValues.put("companyDomain", NewProjectModel.getInitialDomain(false));
        return this;
    }

    private void addKotlinVersion() {
        assert (PluginManager.getPlugin((PluginId)PluginId.findId((String[])new String[]{"org.jetbrains.kotlin"})) != null || !GuiTestingService.getInstance().isGuiTestingMode()) : "Run Test Configuration missing. You should set -Dplugin.path=../../../../prebuilts/tools/common/kotlin-plugin/Kotlin";
        ConvertJavaToKotlinProvider provider = JavaToKotlinHandler.getJavaToKotlinConversionProvider();
        this.myTemplateValues.put("kotlinVersion", provider.getKotlinVersion());
    }

    private static void addDebugKeyStore(@NotNull Map<String, Object> templateValues, @Nullable AndroidFacet facet) {
        if (templateValues == null) {
            TemplateValueInjector.$$$reportNull$$$0(12);
        }
        try {
            File sha1File = facet == null ? KeystoreUtils.getOrCreateDefaultDebugKeystore() : KeystoreUtils.getDebugKeystore(facet);
            templateValues.put("debugKeystoreSha1", KeystoreUtils.sha1(sha1File));
        }
        catch (Exception e) {
            TemplateValueInjector.getLog().info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
            templateValues.put("debugKeystoreSha1", "");
        }
    }

    @Nullable
    private static String getRelativePath(@NotNull File base, @NotNull File file) {
        if (base == null) {
            TemplateValueInjector.$$$reportNull$$$0(13);
        }
        if (file == null) {
            TemplateValueInjector.$$$reportNull$$$0(14);
        }
        return FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)base.getPath()), (String)FileUtil.toSystemIndependentName((String)file.getPath()), (char)'/');
    }

    @NotNull
    private static String determineGradlePluginVersion(@Nullable Project project) {
        String defaultGradleVersion = AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion();
        if (project == null) {
            String string = defaultGradleVersion;
            if (string == null) {
                TemplateValueInjector.$$$reportNull$$$0(15);
            }
            return string;
        }
        GradleVersion versionInUse = GradleUtil.getAndroidGradleModelVersionInUse(project);
        if (versionInUse != null) {
            String string = versionInUse.toString();
            if (string == null) {
                TemplateValueInjector.$$$reportNull$$$0(16);
            }
            return string;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.searchInBuildFilesOnly(project);
        GradleVersion pluginVersion = androidPluginInfo == null ? null : androidPluginInfo.getPluginVersion();
        String string = pluginVersion == null ? defaultGradleVersion : pluginVersion.toString();
        if (string == null) {
            TemplateValueInjector.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static Logger getLog() {
        return Logger.getInstance(TemplateValueInjector.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateValues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFeature";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/template/TemplateValueInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/template/TemplateValueInjector";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "determineGradlePluginVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFacet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setBuildVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setModuleRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProjectDefaults";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setInstantAppSupport";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDynamicFeatureSupport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setBaseFeature";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateAdditionalValues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDebugKeyStore";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

