/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.BatchInvoker;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BindingsManager {
    private final List<OneWayBinding<?>> myOneWayBindings;
    private final List<TwoWayBinding<?>> myTwoWayBindings;
    private final BatchInvoker myInvoker;

    public BindingsManager() {
        this.myOneWayBindings = Lists.newArrayList();
        this.myTwoWayBindings = Lists.newArrayList();
        this.myInvoker = new BatchInvoker();
    }

    public BindingsManager(@NotNull BatchInvoker.Strategy invokeStrategy) {
        if (invokeStrategy == null) {
            BindingsManager.$$$reportNull$$$0(0);
        }
        this.myOneWayBindings = Lists.newArrayList();
        this.myTwoWayBindings = Lists.newArrayList();
        this.myInvoker = new BatchInvoker(invokeStrategy);
    }

    public <T> void bind(@NotNull SettableValue<T> dest, @NotNull ObservableValue<T> src) {
        if (dest == null) {
            BindingsManager.$$$reportNull$$$0(1);
        }
        if (src == null) {
            BindingsManager.$$$reportNull$$$0(2);
        }
        this.bind(dest, src, BooleanExpression.ALWAYS_TRUE);
    }

    public <T> void bind(@NotNull SettableValue<T> dest, @NotNull ObservableValue<T> src, @NotNull ObservableValue<Boolean> enabled) {
        if (dest == null) {
            BindingsManager.$$$reportNull$$$0(3);
        }
        if (src == null) {
            BindingsManager.$$$reportNull$$$0(4);
        }
        if (enabled == null) {
            BindingsManager.$$$reportNull$$$0(5);
        }
        this.release(dest);
        this.myOneWayBindings.add(new OneWayBinding<T>(dest, src, enabled));
    }

    public <T> void bindTwoWay(@NotNull SettableValue<T> first, @NotNull SettableValue<T> second) {
        if (first == null) {
            BindingsManager.$$$reportNull$$$0(6);
        }
        if (second == null) {
            BindingsManager.$$$reportNull$$$0(7);
        }
        this.releaseTwoWay(first, second);
        this.myTwoWayBindings.add(new TwoWayBinding<T>(first, second));
    }

    public void release(@NotNull SettableValue<?> dest) {
        if (dest == null) {
            BindingsManager.$$$reportNull$$$0(8);
        }
        Iterator<OneWayBinding<?>> i = this.myOneWayBindings.iterator();
        while (i.hasNext()) {
            OneWayBinding<?> binding = i.next();
            if (((OneWayBinding)binding).myDest != dest) continue;
            binding.dispose();
            i.remove();
            return;
        }
    }

    public <T> void releaseTwoWay(@NotNull SettableValue<T> first, @NotNull SettableValue<T> second) {
        if (first == null) {
            BindingsManager.$$$reportNull$$$0(9);
        }
        if (second == null) {
            BindingsManager.$$$reportNull$$$0(10);
        }
        Iterator<TwoWayBinding<?>> i = this.myTwoWayBindings.iterator();
        while (i.hasNext()) {
            TwoWayBinding<?> binding = i.next();
            if (((TwoWayBinding)binding).myLhs != first || ((TwoWayBinding)binding).myRhs != second) continue;
            binding.dispose();
            i.remove();
            return;
        }
    }

    public <T> void releaseTwoWay(@NotNull SettableValue<T> value) {
        if (value == null) {
            BindingsManager.$$$reportNull$$$0(11);
        }
        Iterator<TwoWayBinding<?>> i = this.myTwoWayBindings.iterator();
        while (i.hasNext()) {
            TwoWayBinding<?> binding = i.next();
            if (((TwoWayBinding)binding).myLhs != value && ((TwoWayBinding)binding).myRhs != value) continue;
            binding.dispose();
            i.remove();
        }
    }

    public void releaseAll() {
        for (OneWayBinding<?> oneWayBinding : this.myOneWayBindings) {
            oneWayBinding.dispose();
        }
        this.myOneWayBindings.clear();
        for (TwoWayBinding twoWayBinding : this.myTwoWayBindings) {
            twoWayBinding.dispose();
        }
        this.myTwoWayBindings.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeStrategy";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabled";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/observable/BindingsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "bind";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bindTwoWay";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "release";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "releaseTwoWay";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DestUpdater<T>
    implements Runnable {
        private final SettableValue<T> myDest;
        private final ObservableValue<T> mySrc;

        public DestUpdater(SettableValue<T> dest, ObservableValue<T> src) {
            this.myDest = dest;
            this.mySrc = src;
        }

        @Override
        public void run() {
            this.myDest.set(this.mySrc.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DestUpdater that = (DestUpdater)o;
            return Objects.equal(this.myDest, that.myDest) && Objects.equal(this.mySrc, that.mySrc);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myDest, this.mySrc});
        }
    }

    private final class TwoWayBinding<T> {
        private final SettableValue<T> myLhs;
        private final SettableValue<T> myRhs;
        private final InvalidationListener myLeftChangedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    1.$$$reportNull$$$0(0);
                }
                BindingsManager.this.myInvoker.enqueue(new DestUpdater(TwoWayBinding.this.myRhs, TwoWayBinding.this.myLhs));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/observable/BindingsManager$TwoWayBinding$1", "onInvalidated"));
            }
        };
        private final InvalidationListener myRightChangedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    2.$$$reportNull$$$0(0);
                }
                BindingsManager.this.myInvoker.enqueue(new DestUpdater(TwoWayBinding.this.myLhs, TwoWayBinding.this.myRhs));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/observable/BindingsManager$TwoWayBinding$2", "onInvalidated"));
            }
        };

        public TwoWayBinding(SettableValue<T> lhs, SettableValue<T> rhs) {
            this.myLhs = lhs;
            this.myRhs = rhs;
            this.myLhs.addListener(this.myLeftChangedListener);
            this.myRhs.addListener(this.myRightChangedListener);
            this.myRightChangedListener.onInvalidated(rhs);
        }

        public void dispose() {
            this.myLhs.removeListener(this.myLeftChangedListener);
            this.myRhs.removeListener(this.myRightChangedListener);
        }
    }

    private final class OneWayBinding<T>
    implements InvalidationListener {
        private final SettableValue<T> myDest;
        private final ObservableValue<T> mySrc;
        private final ObservableValue<Boolean> myEnabled;

        @Override
        public void onInvalidated(@NotNull ObservableValue<?> sender) {
            if (sender == null) {
                OneWayBinding.$$$reportNull$$$0(0);
            }
            if (this.myEnabled.get().booleanValue()) {
                BindingsManager.this.myInvoker.enqueue(new DestUpdater<T>(this.myDest, this.mySrc));
            }
        }

        public OneWayBinding(SettableValue<T> dest, ObservableValue<T> src, ObservableValue<Boolean> enabled) {
            this.myDest = dest;
            this.mySrc = src;
            this.myEnabled = enabled;
            this.mySrc.addListener(this);
            this.myEnabled.addListener(this);
            this.onInvalidated(src);
        }

        public void dispose() {
            this.mySrc.removeListener(this);
            this.myEnabled.removeListener(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/observable/BindingsManager$OneWayBinding", "onInvalidated"));
        }
    }
}

