/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.ProfilerService;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.Profiler;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidProfilerLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    private static Logger getLogger() {
        return Logger.getInstance(AndroidProfilerLaunchTaskContributor.class);
    }

    @Override
    @NotNull
    public LaunchTask getTask(@NotNull Module module, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions) {
        if (module == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(0);
        }
        if (applicationId2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(1);
        }
        if (launchOptions == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(2);
        }
        AndroidProfilerToolWindowLaunchTask androidProfilerToolWindowLaunchTask = new AndroidProfilerToolWindowLaunchTask(module, launchOptions);
        if (androidProfilerToolWindowLaunchTask == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(3);
        }
        return androidProfilerToolWindowLaunchTask;
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull Module module, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions, @NotNull IDevice device) {
        long deviceId;
        if (module == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(4);
        }
        if (applicationId2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(5);
        }
        if (launchOptions == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(6);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(7);
        }
        if (!AndroidProfilerLaunchTaskContributor.isProfilerLaunch(launchOptions)) {
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(8);
            }
            return "";
        }
        Project project = module.getProject();
        ProfilerService profilerService = ProfilerService.getInstance(project);
        if (profilerService == null) {
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(9);
            }
            return "";
        }
        try {
            deviceId = AndroidProfilerLaunchTaskContributor.waitForPerfd(device, profilerService);
        }
        catch (TimeoutException | InterruptedException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(10);
            }
            return "";
        }
        String agentArgs = AndroidProfilerLaunchTaskContributor.getAttachAgentArgs(applicationId2, profilerService, device, deviceId);
        String startupProfilingResult = AndroidProfilerLaunchTaskContributor.startStartupProfiling(applicationId2, module, profilerService, device, deviceId);
        String string = String.format("%s %s", agentArgs, startupProfilingResult);
        if (string == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String getAttachAgentArgs(@NotNull String appPackageName, @NotNull ProfilerService profilerService, @NotNull IDevice device, long deviceId) {
        if (appPackageName == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(12);
        }
        if (profilerService == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(13);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(14);
        }
        if (!((Boolean)StudioFlags.PROFILER_USE_JVMTI.get()).booleanValue() || device.getVersion().getFeatureLevel() < 27) {
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(15);
            }
            return "";
        }
        Profiler.ConfigureStartupAgentResponse response = profilerService.getProfilerClient().getProfilerClient().configureStartupAgent(Profiler.ConfigureStartupAgentRequest.newBuilder().setDeviceId(deviceId).setAgentLibFileName(AndroidProfilerLaunchTaskContributor.getAbiDependentLibPerfaName(device)).setAppPackageName(appPackageName).build());
        String string = response.getAgentArgs().isEmpty() ? "" : "--attach-agent " + response.getAgentArgs();
        if (string == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String startStartupProfiling(@NotNull String appPackageName, @NotNull Module module, @NotNull ProfilerService profilerService, @NotNull IDevice device, long deviceId) {
        CpuProfiler.StartupProfilingResponse response;
        if (appPackageName == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(17);
        }
        if (module == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(18);
        }
        if (profilerService == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(19);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(20);
        }
        if (!((Boolean)StudioFlags.PROFILER_STARTUP_CPU_PROFILING.get()).booleanValue()) {
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(21);
            }
            return "";
        }
        AndroidRunConfigurationBase runConfig = AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(module.getProject());
        if (runConfig == null || !runConfig.getProfilerState().STARTUP_CPU_PROFILING_ENABLED) {
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(22);
            }
            return "";
        }
        String configName = runConfig.getProfilerState().STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(module.getProject()).getConfigByName(configName);
        if (startupConfig == null) {
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(23);
            }
            return "";
        }
        if (!AndroidProfilerLaunchTaskContributor.isAtLeastO(device)) {
            AndroidNotification.getInstance(module.getProject()).showBalloon("Startup CPU Profiling", "Starting a method trace recording on startup is only supported on devices with API levels 26 and higher.", NotificationType.WARNING);
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(24);
            }
            return "";
        }
        CpuProfiler.StartupProfilingRequest.Builder requestBuilder = CpuProfiler.StartupProfilingRequest.newBuilder().setAppPackage(appPackageName).setDeviceId(deviceId).setConfiguration(CpuProfilerConfigConverter.toProto(startupConfig));
        if (requestBuilder.getConfiguration().getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLEPERF) {
            requestBuilder.setAbiCpuArch(AndroidProfilerLaunchTaskContributor.getSimpleperfAbi(device));
        }
        if ((response = profilerService.getProfilerClient().getCpuClient().startStartupProfiling(requestBuilder.build())).getFilePath().isEmpty() || requestBuilder.getConfiguration().getProfilerType() != CpuProfiler.CpuProfilerType.ART) {
            if ("" == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(25);
            }
            return "";
        }
        StringBuilder argsBuilder = new StringBuilder("--start-profiler ").append(response.getFilePath());
        if (startupConfig.getTechnology() == CpuProfilerConfig.Technology.SAMPLED_JAVA) {
            argsBuilder.append(" --sampling ").append(startupConfig.getSamplingIntervalUs());
        }
        argsBuilder.append(" --streaming");
        String string = argsBuilder.toString();
        if (string == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static boolean isAtLeastO(@NotNull IDevice device) {
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(27);
        }
        return device.getVersion().getFeatureLevel() >= 26;
    }

    @Nullable
    private static AndroidRunConfigurationBase getSelectedRunConfiguration(@NotNull Project project) {
        RunnerAndConfigurationSettings settings;
        if (project == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(28);
        }
        if ((settings = RunManager.getInstance((Project)project).getSelectedConfiguration()) != null && settings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            return (AndroidRunConfigurationBase)settings.getConfiguration();
        }
        return null;
    }

    private static long waitForPerfd(@NotNull IDevice device, @NotNull ProfilerService profilerService) throws InterruptedException, TimeoutException {
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(29);
        }
        if (profilerService == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(30);
        }
        for (int i = 0; i < 60; ++i) {
            Common.Device profilerDevice = AndroidProfilerLaunchTaskContributor.getProfilerDevice(device, profilerService);
            if (!Common.Device.getDefaultInstance().equals((Object)profilerDevice)) {
                return profilerDevice.getDeviceId();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        throw new TimeoutException("Timeout waiting for perfd");
    }

    @NotNull
    private static Common.Device getProfilerDevice(@NotNull IDevice device, @NotNull ProfilerService profilerService) {
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(31);
        }
        if (profilerService == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(32);
        }
        Profiler.GetDevicesResponse response = profilerService.getProfilerClient().getProfilerClient().getDevices(Profiler.GetDevicesRequest.getDefaultInstance());
        for (Common.Device profilerDevice : response.getDeviceList()) {
            if (!profilerDevice.getSerial().equals(device.getSerialNumber()) || profilerDevice.getState() != Common.Device.State.ONLINE) continue;
            Common.Device device2 = profilerDevice;
            if (device2 == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(33);
            }
            return device2;
        }
        Common.Device device3 = Common.Device.getDefaultInstance();
        if (device3 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(34);
        }
        return device3;
    }

    @NotNull
    private static String getAbiDependentLibPerfaName(IDevice device) {
        String abi = AndroidProfilerLaunchTaskContributor.getBestAbi(device, "plugins/android/resources/perfa", "../../bazel-bin/tools/base/profiler/native/perfa/android", "libperfa.so");
        String string = abi.isEmpty() ? "" : String.format("libperfa_%s.so", abi);
        if (string == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static String getSimpleperfAbi(IDevice device) {
        String string = AndroidProfilerLaunchTaskContributor.getBestAbi(device, "plugins/android/resources/simpleperf", "../../prebuilts/tools/common/simpleperf", "simpleperf");
        if (string == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static String getBestAbi(@NotNull IDevice device, @NotNull String releaseDir, @NotNull String devDir, @NotNull String fileName) {
        File dir;
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(37);
        }
        if (releaseDir == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(38);
        }
        if (devDir == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(39);
        }
        if (fileName == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(40);
        }
        if (!(dir = new File(PathManager.getHomePath(), releaseDir)).exists()) {
            dir = new File(PathManager.getHomePath(), devDir);
        }
        for (String abi : device.getAbis()) {
            File candidate = new File(dir, abi + "/" + fileName);
            if (!candidate.exists()) continue;
            String string = Abi.getEnum((String)abi).getCpuArch();
            if (string == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(41);
            }
            return string;
        }
        if ("" == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(42);
        }
        return "";
    }

    private static boolean isProfilerLaunch(@NotNull LaunchOptions options) {
        Object launchValue;
        if (options == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(43);
        }
        return (launchValue = options.getExtraOption("isProfiling")) instanceof Boolean && (Boolean)launchValue != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor";
                break;
            }
            case 7: 
            case 14: 
            case 20: 
            case 27: 
            case 29: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appPackageName";
                break;
            }
            case 13: 
            case 19: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerService";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDir";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devDir";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTask";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAmStartOptions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachAgentArgs";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "startStartupProfiling";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerDevice";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbiDependentLibPerfaName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleperfAbi";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestAbi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTask";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: 
            case 42: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAmStartOptions";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAttachAgentArgs";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startStartupProfiling";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeastO";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRunConfiguration";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "waitForPerfd";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getProfilerDevice";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBestAbi";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isProfilerLaunch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class AndroidProfilerToolWindowLaunchTask
    implements LaunchTask {
        @NotNull
        private final Module myModule;
        @NotNull
        private final LaunchOptions myLaunchOptions;

        public AndroidProfilerToolWindowLaunchTask(@NotNull Module module, @NotNull LaunchOptions launchOptions) {
            if (module == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(0);
            }
            if (launchOptions == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(1);
            }
            this.myModule = module;
            this.myLaunchOptions = launchOptions;
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Launching the Profiler Tool Window" == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(2);
            }
            return "Launching the Profiler Tool Window";
        }

        @Override
        public int getDuration() {
            return 2;
        }

        @Override
        public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
            if (device == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(3);
            }
            if (launchStatus == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(4);
            }
            if (printer == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(5);
            }
            long currentDeviceTimeNs = this.getCurrentDeviceTime(device);
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project;
                ToolWindow window;
                if (device == null) {
                    AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(7);
                }
                if ((window = ToolWindowManagerEx.getInstanceEx((Project)(project = this.myModule.getProject())).getToolWindow("Android Profiler")) != null) {
                    AndroidProfilerToolWindow profilerToolWindow;
                    window.setShowStripeButton(true);
                    String deviceName = AndroidProfilerToolWindow.getDeviceDisplayName(device);
                    String processName = AndroidProfilerToolWindow.getModuleName(this.myModule);
                    AndroidProfilerToolWindow.PreferredProcessInfo preferredProcessInfo = new AndroidProfilerToolWindow.PreferredProcessInfo(deviceName, processName, p -> p.getStartTimestampNs() >= currentDeviceTimeNs);
                    project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, (Object)preferredProcessInfo);
                    if (window.isVisible() && (profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project)) != null) {
                        profilerToolWindow.profile(preferredProcessInfo);
                    }
                }
            });
            return true;
        }

        private long getCurrentDeviceTime(@NotNull IDevice device) {
            if (device == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(6);
            }
            long startTimeNs = Long.MIN_VALUE;
            if (!AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions) && !ProfilerService.isServiceInitialized(this.myModule.getProject())) {
                return startTimeNs;
            }
            ProfilerService profilerService = ProfilerService.getInstance(this.myModule.getProject());
            if (profilerService == null) {
                return startTimeNs;
            }
            long deviceId = -1L;
            if (AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions)) {
                try {
                    deviceId = AndroidProfilerLaunchTaskContributor.waitForPerfd(device, profilerService);
                }
                catch (TimeoutException | InterruptedException e) {
                    AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
                }
            } else {
                deviceId = AndroidProfilerLaunchTaskContributor.getProfilerDevice(device, profilerService).getDeviceId();
            }
            Profiler.TimeResponse timeResponse = profilerService.getProfilerClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(deviceId).build());
            if (!Profiler.TimeResponse.getDefaultInstance().equals((Object)timeResponse)) {
                startTimeNs = timeResponse.getTimestampNs();
            }
            return startTimeNs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launchOptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor$AndroidProfilerToolWindowLaunchTask";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launchStatus";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor$AndroidProfilerToolWindowLaunchTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getCurrentDeviceTime";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$perform$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

