/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.adtui.TabularLayout;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListBoxChooserDialog<T>
extends DialogWrapper {
    @Nullable
    private final String myMessage;
    @NotNull
    private T mySelectedOption;
    @NotNull
    private final Presentation myActivePresentation;
    @NotNull
    private final T[] myOptions;
    @NotNull
    private final Function<T, String> myPresentationAdapter;

    public ListBoxChooserDialog(@NotNull String title, @Nullable String message, @NotNull T[] options, @NotNull Function<T, String> presentationAdapter) {
        if (title == null) {
            ListBoxChooserDialog.$$$reportNull$$$0(0);
        }
        if (options == null) {
            ListBoxChooserDialog.$$$reportNull$$$0(1);
        }
        if (presentationAdapter == null) {
            ListBoxChooserDialog.$$$reportNull$$$0(2);
        }
        super(false);
        this.setTitle(title);
        this.myMessage = message;
        if (!SystemInfo.isMac) {
            this.setButtonsAlignment(0);
        }
        this.myPresentationAdapter = presentationAdapter;
        this.myOptions = options;
        assert (this.myOptions.length > 0);
        this.mySelectedOption = this.myOptions[0];
        this.myActivePresentation = new Presentation();
        this.init();
    }

    private void updateActivePresentation() {
        this.myActivePresentation.setText(this.myPresentationAdapter.apply(this.mySelectedOption));
    }

    @NotNull
    public T getSelectedValue() {
        T t = this.mySelectedOption;
        if (t == null) {
            ListBoxChooserDialog.$$$reportNull$$$0(3);
        }
        return t;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,5px,*,5px"));
        if (this.myMessage != null) {
            panel.add((Component)new JLabel(this.myMessage), new TabularLayout.Constraint(0, 0));
        }
        this.updateActivePresentation();
        panel.add((Component)new OptionsSelectorComboBox().createCustomComponent(this.myActivePresentation), new TabularLayout.Constraint(2, 0));
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationAdapter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/ListBoxChooserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/ListBoxChooserDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SelectTargetAction
    extends AnAction {
        private final T myOption;

        public SelectTargetAction(T option) {
            this.myOption = option;
            String name = (String)ListBoxChooserDialog.this.myPresentationAdapter.apply(option);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
        }

        public void actionPerformed(AnActionEvent e) {
            ListBoxChooserDialog.this.mySelectedOption = this.myOption;
            ListBoxChooserDialog.this.updateActivePresentation();
        }
    }

    private class OptionsSelectorComboBox
    extends ComboBoxAction {
        NonOpaquePanel myPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());

        private OptionsSelectorComboBox() {
        }

        public JComponent createCustomComponent(Presentation presentation) {
            ComboBoxAction.ComboBoxButton button = new ComboBoxAction.ComboBoxButton(presentation){

                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = Math.max(d.width, JBUI.scale((int)75));
                    return d;
                }
            };
            this.myPanel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
            this.myPanel.add((Component)button);
            return this.myPanel;
        }

        protected int getMaxRows() {
            return 10;
        }

        protected int getMinWidth() {
            return this.myPanel.getWidth();
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup allActionsGroup = new DefaultActionGroup();
            for (Object option : ListBoxChooserDialog.this.myOptions) {
                SelectTargetAction action2 = new SelectTargetAction(option);
                allActionsGroup.add((AnAction)action2);
            }
            DefaultActionGroup defaultActionGroup = allActionsGroup;
            if (defaultActionGroup == null) {
                OptionsSelectorComboBox.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profilers/ListBoxChooserDialog$OptionsSelectorComboBox", "createPopupActionGroup"));
        }
    }
}

