/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.StudioLegacyAllocationTracker;
import com.android.tools.idea.profilers.StudioLegacyCpuTraceProfiler;
import com.android.tools.idea.profilers.perfd.CpuServiceProxy;
import com.android.tools.idea.profilers.perfd.EnergyServiceProxy;
import com.android.tools.idea.profilers.perfd.EventServiceProxy;
import com.android.tools.idea.profilers.perfd.MemoryServiceProxy;
import com.android.tools.idea.profilers.perfd.NetworkServiceProxy;
import com.android.tools.idea.profilers.perfd.PerfdProxyService;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxy;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public final class PerfdProxy {
    @NotNull
    private static final String MEMORY_PROXY_EXECUTOR_NAME = "MemoryServiceProxy";
    @NotNull
    private Server myProxyServer;
    @NotNull
    private final List<PerfdProxyService> myProxyServices;
    @NotNull
    private IDevice myDevice;

    public PerfdProxy(@NotNull IDevice device, @NotNull ManagedChannel perfdChannel, String channelName) {
        if (device == null) {
            PerfdProxy.$$$reportNull$$$0(0);
        }
        if (perfdChannel == null) {
            PerfdProxy.$$$reportNull$$$0(1);
        }
        this.myDevice = device;
        this.myProxyServices = new LinkedList<PerfdProxyService>();
        this.myProxyServices.add(new ProfilerServiceProxy(device, perfdChannel));
        this.myProxyServices.add(new EventServiceProxy(device, perfdChannel));
        this.myProxyServices.add(new CpuServiceProxy(device, perfdChannel, new StudioLegacyCpuTraceProfiler(device, CpuServiceGrpc.newBlockingStub((Channel)perfdChannel))));
        this.myProxyServices.add(new MemoryServiceProxy(device, perfdChannel, Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(MEMORY_PROXY_EXECUTOR_NAME).build()), (d, p) -> new StudioLegacyAllocationTracker((IDevice)d, (int)p)));
        this.myProxyServices.add(new NetworkServiceProxy(device, perfdChannel));
        this.myProxyServices.add(new EnergyServiceProxy(device, perfdChannel));
        InProcessServerBuilder builder = InProcessServerBuilder.forName((String)channelName);
        this.myProxyServices.forEach(arg_0 -> PerfdProxy.lambda$new$1((ServerBuilder)builder, arg_0));
        this.myProxyServer = builder.build();
    }

    public void connect() throws IOException {
        this.myProxyServer.start();
    }

    public void disconnect() {
        this.myProxyServices.forEach(PerfdProxyService::disconnect);
        this.myProxyServer.shutdownNow();
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            PerfdProxy.$$$reportNull$$$0(2);
        }
        return iDevice;
    }

    private static /* synthetic */ void lambda$new$1(ServerBuilder builder, PerfdProxyService service) {
        builder.addService(service.getServiceDefinition());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perfdChannel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/perfd/PerfdProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/perfd/PerfdProxy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

