/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilingConfigPanel {
    private static final int MIN_SAMPLING_INTERVAL_US = 100;
    private static final int MAX_SAMPLING_INTERVAL_US = 100000;
    private static final int MIN_FILE_SIZE_LIMIT_MB = 4;
    private int myMaxFileSizeLimitMb;
    private JPanel myConfigPanel;
    private JTextField myConfigName;
    private JTextField mySamplingInterval;
    private final JLabel mySamplingIntervalText = new JLabel("Sampling interval:");
    private final JLabel mySamplingIntervalUnit = new JLabel("microseconds (\u00b5s)");
    private JTextField myFileSizeLimit;
    private final JLabel myFileSizeLimitText = new JLabel("File size limit:");
    private final JLabel myFileSizeLimitUnit = new JLabel("MB");
    private JRadioButton myArtSampledButton;
    private JRadioButton myArtInstrumentedButton;
    private JRadioButton mySimpleperfButton;
    private ProfilingConfiguration myConfiguration;
    private boolean myIsDeviceAtLeastO;

    CpuProfilingConfigPanel(int deviceApiLevel) {
        this.myIsDeviceAtLeastO = deviceApiLevel >= 26;
        this.myMaxFileSizeLimitMb = 4096;
        this.createUiComponents();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilingConfigPanel.class);
    }

    private static JTextField createNumberTextField(final int min, final int max, final int defaultValue, final Consumer<Integer> callback, String tooltip) {
        final JTextField textField2 = new JTextField();
        textField2.setHorizontalAlignment(4);
        textField2.setToolTipText(tooltip);
        textField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                try {
                    int value = Integer.parseInt(textField2.getText());
                    value = Math.max(Math.min(max, value), min);
                    textField2.setText(String.valueOf(value));
                    callback.accept(value);
                }
                catch (Exception ex) {
                    textField2.setText(String.valueOf(defaultValue));
                }
            }
        });
        return textField2;
    }

    JComponent getComponent() {
        return this.myConfigPanel;
    }

    JComponent getPreferredFocusComponent() {
        return this.myConfigName;
    }

    void setConfiguration(@Nullable ProfilingConfiguration configuration, boolean isDefaultConfiguration) {
        this.myConfiguration = configuration;
        if (configuration == null) {
            this.clearFields();
        } else {
            this.myConfigName.setText(configuration.getName());
            this.myConfigName.setEnabled(true);
            this.myConfigName.selectAll();
            this.setAndEnableRadioButtons(configuration);
            this.myFileSizeLimit.setText(String.valueOf(configuration.getProfilingBufferSizeInMb()));
            this.setEnabledFileSizeLimit(!this.myIsDeviceAtLeastO);
            this.mySamplingInterval.setText(String.valueOf(configuration.getProfilingSamplingIntervalUs()));
        }
        if (isDefaultConfiguration) {
            this.disableFields();
        }
    }

    private void setAndEnableRadioButtons(@NotNull ProfilingConfiguration configuration) {
        if (configuration == null) {
            CpuProfilingConfigPanel.$$$reportNull$$$0(0);
        }
        this.myArtSampledButton.setEnabled(true);
        this.myArtInstrumentedButton.setEnabled(true);
        this.mySimpleperfButton.setEnabled(true);
        if (configuration.getProfilerType() == CpuProfiler.CpuProfilerType.ART) {
            if (configuration.getMode() == CpuProfiler.CpuProfilerConfiguration.Mode.SAMPLED) {
                this.myArtSampledButton.setSelected(true);
                this.setEnabledSamplingIntervalPanel(true);
            } else if (configuration.getMode() == CpuProfiler.CpuProfilerConfiguration.Mode.INSTRUMENTED) {
                this.myArtInstrumentedButton.setSelected(true);
                this.setEnabledSamplingIntervalPanel(false);
            } else {
                CpuProfilingConfigPanel.getLogger().warn("Invalid trace technology detected.");
            }
        } else if (configuration.getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLEPERF) {
            assert (configuration.getMode() == CpuProfiler.CpuProfilerConfiguration.Mode.SAMPLED);
            this.mySimpleperfButton.setSelected(true);
            this.setEnabledSamplingIntervalPanel(true);
        } else {
            CpuProfilingConfigPanel.getLogger().warn("Invalid trace technology detected.");
        }
    }

    private void clearFields() {
        this.myConfigName.setText("");
        this.myArtSampledButton.setSelected(false);
        this.myArtInstrumentedButton.setSelected(false);
        this.mySimpleperfButton.setSelected(false);
        this.mySamplingInterval.setText("");
        this.myFileSizeLimit.setText("");
    }

    private void disableFields() {
        this.myConfigName.setEnabled(false);
        this.myArtSampledButton.setEnabled(false);
        this.myArtInstrumentedButton.setEnabled(false);
        this.mySimpleperfButton.setEnabled(false);
        this.setEnabledSamplingIntervalPanel(false);
        this.setEnabledFileSizeLimit(false);
    }

    private void createUiComponents() {
        this.myConfigPanel = new JPanel();
        this.myConfigPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.createConfigNamePanel();
        this.addSeparator();
        this.createTraceTechnologyPanel();
        this.addSeparator();
        this.createSamplingIntervalPanel();
        this.addSeparator();
        this.createFileLimitPanel();
        this.disableFields();
    }

    private void addSeparator() {
        JPanel separatorPanel = new JPanel((LayoutManager)new TabularLayout("*", "10px"));
        separatorPanel.add((Component)new JSeparator(), new TabularLayout.Constraint(0, 0));
        this.myConfigPanel.add(separatorPanel);
    }

    private void createConfigNamePanel() {
        JPanel namePanel = new JPanel((LayoutManager)new TabularLayout("Fit-,200px", "25px"));
        JLabel nameLabel = new JLabel("Name:");
        nameLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        namePanel.add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        this.myConfigName = new JTextField();
        this.myConfigName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (CpuProfilingConfigPanel.this.myConfiguration != null) {
                    CpuProfilingConfigPanel.this.myConfiguration.setName(CpuProfilingConfigPanel.this.myConfigName.getText());
                }
            }
        });
        namePanel.add((Component)this.myConfigName, new TabularLayout.Constraint(0, 1));
        this.myConfigPanel.add(namePanel);
    }

    private void createTraceTechnologyPanel() {
        this.myConfigPanel.add(new JLabel("Trace technology"));
        ButtonGroup profilersType = new ButtonGroup();
        this.myArtSampledButton = new JRadioButton("Sampled (Java)");
        this.createRadioButtonUi(this.myArtSampledButton, "Samples Java code using Android Runtime.", TraceTechnology.ART_SAMPLED, profilersType);
        this.myArtInstrumentedButton = new JRadioButton("Instrumented (Java)");
        this.createRadioButtonUi(this.myArtInstrumentedButton, "Instruments Java code using Android Runtime.", TraceTechnology.ART_INSTRUMENTED, profilersType);
        this.mySimpleperfButton = new JRadioButton("Sampled (Native)");
        if (((Boolean)StudioFlags.PROFILER_USE_SIMPLEPERF.get()).booleanValue()) {
            this.createRadioButtonUi(this.mySimpleperfButton, "<html>Samples native code using simpleperf. Available for Android 8.0 (API level 26) and higher.</html>", TraceTechnology.SIMPLEPERF, profilersType);
        }
    }

    private void updateConfigurationProfilerAndMode(TraceTechnology technology) {
        switch (technology) {
            case ART_SAMPLED: {
                this.myConfiguration.setProfilerType(CpuProfiler.CpuProfilerType.ART);
                this.myConfiguration.setMode(CpuProfiler.CpuProfilerConfiguration.Mode.SAMPLED);
                this.setEnabledSamplingIntervalPanel(true);
                break;
            }
            case ART_INSTRUMENTED: {
                this.myConfiguration.setProfilerType(CpuProfiler.CpuProfilerType.ART);
                this.myConfiguration.setMode(CpuProfiler.CpuProfilerConfiguration.Mode.INSTRUMENTED);
                this.setEnabledSamplingIntervalPanel(false);
                break;
            }
            case SIMPLEPERF: {
                this.myConfiguration.setProfilerType(CpuProfiler.CpuProfilerType.SIMPLEPERF);
                this.myConfiguration.setMode(CpuProfiler.CpuProfilerConfiguration.Mode.SAMPLED);
                this.setEnabledSamplingIntervalPanel(true);
            }
        }
    }

    private void createRadioButtonUi(JRadioButton button, String description, TraceTechnology technology, ButtonGroup group) {
        button.addActionListener(e -> {
            JRadioButton bt;
            if (e.getSource() == button && (bt = (JRadioButton)e.getSource()).isSelected()) {
                this.updateConfigurationProfilerAndMode(technology);
            }
        });
        group.add(button);
        this.myConfigPanel.add(button);
        JLabel descriptionLabel = new JLabel(description);
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(12.0f));
        descriptionLabel.setBorder(new EmptyBorder(0, 30, 0, 0));
        this.myConfigPanel.add(descriptionLabel);
    }

    private void setEnabledSamplingIntervalPanel(boolean isEnabled) {
        this.mySamplingInterval.setEnabled(isEnabled);
        this.mySamplingIntervalText.setEnabled(isEnabled);
        this.mySamplingIntervalUnit.setEnabled(isEnabled);
    }

    private static TabularLayout getSamplingIntervalFileSizeLayout() {
        return new TabularLayout("120px,75px,Fit-,*", "25px");
    }

    private void createSamplingIntervalPanel() {
        JPanel samplingIntervalPanel = new JPanel((LayoutManager)CpuProfilingConfigPanel.getSamplingIntervalFileSizeLayout());
        samplingIntervalPanel.add((Component)this.mySamplingIntervalText, new TabularLayout.Constraint(0, 0));
        this.mySamplingInterval = CpuProfilingConfigPanel.createNumberTextField(100, 100000, 1000, value -> this.myConfiguration.setProfilingSamplingIntervalUs(value.intValue()), String.format("The sampling interval should be a value between %d and %d microseconds", 100, 100000));
        samplingIntervalPanel.add((Component)this.mySamplingInterval, new TabularLayout.Constraint(0, 1));
        this.mySamplingIntervalUnit.setBorder(new EmptyBorder(0, 5, 0, 0));
        samplingIntervalPanel.add((Component)this.mySamplingIntervalUnit, new TabularLayout.Constraint(0, 2));
        this.myConfigPanel.add(samplingIntervalPanel);
    }

    private void setEnabledFileSizeLimit(boolean isEnabled) {
        this.myFileSizeLimit.setEnabled(isEnabled);
        this.myFileSizeLimitText.setEnabled(isEnabled);
        this.myFileSizeLimitUnit.setEnabled(isEnabled);
    }

    private void createFileLimitPanel() {
        JPanel fileSizeLimitPanel = new JPanel((LayoutManager)CpuProfilingConfigPanel.getSamplingIntervalFileSizeLayout());
        fileSizeLimitPanel.add((Component)this.myFileSizeLimitText, new TabularLayout.Constraint(0, 0));
        this.myFileSizeLimit = CpuProfilingConfigPanel.createNumberTextField(4, this.myMaxFileSizeLimitMb, 8, value -> this.myConfiguration.setProfilingBufferSizeInMb(value.intValue()), String.format("The file buffer maximum size should be a value between %d and %d MB", 4, this.myMaxFileSizeLimitMb));
        fileSizeLimitPanel.add((Component)this.myFileSizeLimit, new TabularLayout.Constraint(0, 1));
        this.myFileSizeLimitUnit.setBorder(new EmptyBorder(0, 5, 0, 0));
        fileSizeLimitPanel.add((Component)this.myFileSizeLimitUnit, new TabularLayout.Constraint(0, 2));
        this.myConfigPanel.add(fileSizeLimitPanel);
        JLabel description = new JLabel("<html>Maximum size of the output file from recording. On Android 8.0 (API level 26) and higher, there is no limit on the file size and the value is ignored.</html>");
        description.setFont(description.getFont().deriveFont(12.0f));
        this.myConfigPanel.add(description);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/profilers/profilingconfig/CpuProfilingConfigPanel", "setAndEnableRadioButtons"));
    }

    private static enum TraceTechnology {
        ART_SAMPLED,
        ART_INSTRUMENTED,
        SIMPLEPERF;

    }
}

