/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.profilers.TraceSignatureConverter;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.base.Strings;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntellijCodeNavigator
extends CodeNavigator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, String> myApkSrcDirMap;

    public IntellijCodeNavigator(@NotNull Project project, @NotNull FeatureTracker featureTracker) {
        if (project == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(0);
        }
        if (featureTracker == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(1);
        }
        super(featureTracker);
        this.myProject = project;
        this.myApkSrcDirMap = this.getApkSourceDirMap();
    }

    protected void handleNavigate(@NotNull CodeLocation location) {
        Navigatable nav;
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(2);
        }
        if ((nav = this.getNavigatable(location)) != null) {
            nav.navigate(true);
        }
    }

    public boolean isNavigatable(@NotNull CodeLocation location) {
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(3);
        }
        return this.getNavigatable(location) != null;
    }

    @Nullable
    private Navigatable getNavigatable(@NotNull CodeLocation location) {
        Navigatable navigatable;
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(4);
        }
        if (!Strings.isNullOrEmpty((String)location.getFileName()) && location.getLineNumber() != -1) {
            navigatable = this.getExplicitLocationNavigable(location);
            if (navigatable != null) {
                return navigatable;
            }
            navigatable = this.getApkMappingNavigable(location);
            if (navigatable != null) {
                return navigatable;
            }
        }
        if (location.isNativeCode() && (navigatable = this.getNativeNavigatable(location)) != null) {
            return navigatable;
        }
        PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getClassName());
        if (psiClass == null && location.getLineNumber() >= 0) {
            psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getOuterClassName());
        }
        if (psiClass == null) {
            return null;
        }
        if (location.getLineNumber() >= 0) {
            return new OpenFileDescriptor(this.myProject, psiClass.getNavigationElement().getContainingFile().getVirtualFile(), location.getLineNumber(), 0);
        }
        if (location.getMethodName() != null && location.getSignature() != null) {
            PsiMethod method = IntellijCodeNavigator.findMethod(psiClass, location.getMethodName(), location.getSignature());
            return method != null ? method : psiClass;
        }
        return psiClass;
    }

    @Nullable
    private Navigatable getExplicitLocationNavigable(@NotNull CodeLocation location) {
        LocalFileSystem fileSystem;
        VirtualFile sourceFile;
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(5);
        }
        if ((sourceFile = (fileSystem = LocalFileSystem.getInstance()).findFileByPath(location.getFileName())) == null || !sourceFile.exists()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, sourceFile, location.getLineNumber(), 0);
    }

    @Nullable
    private Navigatable getApkMappingNavigable(@NotNull CodeLocation location) {
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(6);
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (Map.Entry<String, String> entry : this.myApkSrcDirMap.entrySet()) {
            if (!location.getFileName().startsWith(entry.getKey())) continue;
            String pathTailAfterPrefix = location.getFileName().substring(entry.getKey().length());
            String newFileName = Paths.get(entry.getValue(), pathTailAfterPrefix).toString();
            VirtualFile sourceFile = fileSystem.findFileByPath(newFileName);
            if (sourceFile == null || !sourceFile.exists()) continue;
            return new OpenFileDescriptor(this.myProject, sourceFile, location.getLineNumber(), 0);
        }
        return null;
    }

    @NotNull
    private Map<String, String> getApkSourceDirMap() {
        LinkedHashMap<String, String> sourceMap = new LinkedHashMap<String, String>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacet apkFacet = ApkFacet.getInstance(module);
            if (apkFacet == null) continue;
            for (Map.Entry<String, String> entry : ((ApkFacetConfiguration)apkFacet.getConfiguration()).getSymbolFolderPathMappings().entrySet()) {
                if (entry.getValue().isEmpty() || entry.getKey().equals(entry.getValue())) continue;
                sourceMap.put(entry.getKey(), entry.getValue());
            }
        }
        LinkedHashMap<String, String> linkedHashMap = sourceMap;
        if (linkedHashMap == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(7);
        }
        return linkedHashMap;
    }

    @Nullable
    private Navigatable getNativeNavigatable(@NotNull CodeLocation location) {
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(8);
        }
        Navigatable[] navigatable = new Navigatable[1];
        Processor processor = symbol -> {
            String qualifierName;
            if (location == null) {
                IntellijCodeNavigator.$$$reportNull$$$0(12);
            }
            if (!(symbol instanceof OCFunctionSymbol)) {
                return true;
            }
            OCFunctionSymbol function = (OCFunctionSymbol)symbol;
            if (!function.getName().equals(location.getMethodName())) {
                return true;
            }
            OCQualifiedName qualifier = function.getQualifiedName().getQualifier();
            String string = qualifierName = qualifier == null || qualifier.getName() == null ? "" : qualifier.getName();
            if (!qualifierName.equals(location.getClassName())) {
                return true;
            }
            List parameters = location.getMethodParameters();
            if (parameters != null) {
                List functionParams = function.getParameterSymbols();
                if (functionParams.size() != parameters.size()) {
                    return true;
                }
                boolean match = true;
                for (int i = 0; i < parameters.size(); ++i) {
                    if (((String)parameters.get(i)).equals(((OCDeclaratorSymbol)functionParams.get(i)).getType().getName())) continue;
                    match = false;
                    break;
                }
                if (!match) {
                    return true;
                }
            }
            navigatable[0] = function;
            return false;
        };
        assert (location.getMethodName() != null);
        OCGlobalProjectSymbolsCache.processByQualifiedName((Project)this.myProject, (Processor)processor, (String)location.getMethodName());
        return navigatable[0];
    }

    @Nullable
    private static PsiMethod findMethod(@NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String signature) {
        if (psiClass == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(9);
        }
        if (methodName == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(10);
        }
        if (signature == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(11);
        }
        for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
            if (!signature.equals(TraceSignatureConverter.getTraceSignature(method))) continue;
            return method;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/stacktrace/IntellijCodeNavigator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/stacktrace/IntellijCodeNavigator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkSourceDirMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleNavigate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitLocationNavigable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getApkMappingNavigable";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNativeNavigatable";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNativeNavigatable$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

