/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.ddmlib.Client;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.profiling.capture.AsyncWriterDelegate;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureService {
    public static final String FD_CAPTURES = "captures";
    private static final String TEMP_FILE_EXTENSION = ".temp";
    @NotNull
    private final Project myProject;
    @NotNull
    private Multimap<CaptureType, Capture> myCaptures;
    private List<CaptureListener> myListeners;
    @Nullable
    private AsyncWriterDelegate myAsyncWriterDelegate;
    @NotNull
    private Set<CaptureHandle> myOpenCaptureHandles;

    public CaptureService(@NotNull Project project) {
        if (project == null) {
            CaptureService.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCaptures = LinkedListMultimap.create();
        this.myListeners = new LinkedList<CaptureListener>();
        this.myOpenCaptureHandles = new HashSet<CaptureHandle>();
        this.update();
    }

    @NotNull
    public static CaptureService getInstance(@NotNull Project project) {
        if (project == null) {
            CaptureService.$$$reportNull$$$0(1);
        }
        CaptureService captureService = (CaptureService)ServiceManager.getService((Project)project, CaptureService.class);
        if (captureService == null) {
            CaptureService.$$$reportNull$$$0(2);
        }
        return captureService;
    }

    private static Set<VirtualFile> findCaptureFiles(@NotNull VirtualFile[] files2, @NotNull CaptureType type) {
        if (files2 == null) {
            CaptureService.$$$reportNull$$$0(3);
        }
        if (type == null) {
            CaptureService.$$$reportNull$$$0(4);
        }
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (VirtualFile file : files2) {
            if (!type.isValidCapture(file)) continue;
            set.add(file);
        }
        return set;
    }

    @NotNull
    public String getSuggestedName(@Nullable Client client) {
        String string = this.getSuggestedName(client, "yyyy.MM.dd_HH.mm");
        if (string == null) {
            CaptureService.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String getSuggestedName(@Nullable Client client, @NotNull String format) {
        String name;
        if (format == null) {
            CaptureService.$$$reportNull$$$0(6);
        }
        String timestamp = new SimpleDateFormat(format).format(new Date());
        String suggestedName = null;
        if (client != null && (name = client.getClientData().getClientDescription()) != null && !name.isEmpty()) {
            suggestedName = name + "_" + timestamp;
        }
        if (suggestedName == null) {
            suggestedName = this.myProject.getName() + "_" + timestamp;
        }
        return suggestedName.replaceAll("[^._A-Za-z0-9]", "");
    }

    public void update() {
        CaptureTypeService service = CaptureTypeService.getInstance();
        VirtualFile dir = this.getCapturesDirectory();
        LinkedListMultimap updated = LinkedListMultimap.create();
        if (dir != null) {
            VirtualFile[] children = VfsUtil.getChildren((VirtualFile)dir);
            for (CaptureType type : service.getCaptureTypes()) {
                Set<VirtualFile> files2 = CaptureService.findCaptureFiles(children, type);
                for (Capture capture : this.myCaptures.get((Object)type)) {
                    if (!files2.remove(capture.getFile())) continue;
                    updated.put((Object)type, (Object)capture);
                }
                for (VirtualFile newFile : files2) {
                    updated.put((Object)type, (Object)type.createCapture(newFile));
                }
            }
        }
        this.myCaptures = updated;
    }

    @NotNull
    public VirtualFile createCapturesDirectory() throws IOException {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        if (projectDir != null) {
            VirtualFile dir = projectDir.findChild(FD_CAPTURES);
            if (dir == null) {
                dir = projectDir.createChildDirectory(null, FD_CAPTURES);
            }
            VirtualFile virtualFile = dir;
            if (virtualFile == null) {
                CaptureService.$$$reportNull$$$0(7);
            }
            return virtualFile;
        }
        throw new IOException("Unable to create the captures directory: Project directory not found.");
    }

    @Nullable
    public VirtualFile getCapturesDirectory() {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        return projectDir != null ? projectDir.findChild(FD_CAPTURES) : null;
    }

    @NotNull
    public Multimap<CaptureType, Capture> getCapturesByType() {
        Multimap<CaptureType, Capture> multimap = this.myCaptures;
        if (multimap == null) {
            CaptureService.$$$reportNull$$$0(8);
        }
        return multimap;
    }

    @NotNull
    public Collection<Capture> getCaptures() {
        Collection collection = this.myCaptures.values();
        if (collection == null) {
            CaptureService.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<CaptureType> getTypes() {
        Set set = this.myCaptures.keySet();
        if (set == null) {
            CaptureService.$$$reportNull$$$0(10);
        }
        return set;
    }

    public CaptureHandle startCaptureFile(@NotNull Class<? extends CaptureType> clazz, @NotNull String name, boolean hideFileUntilFinalized) throws IOException {
        if (clazz == null) {
            CaptureService.$$$reportNull$$$0(11);
        }
        if (name == null) {
            CaptureService.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAsyncWriterDelegate == null) {
            this.myAsyncWriterDelegate = new AsyncWriterDelegate();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myAsyncWriterDelegate);
        }
        CaptureHandle handle = this.startCaptureFileSynchronous(clazz, name, hideFileUntilFinalized);
        this.myOpenCaptureHandles.add(handle);
        return handle;
    }

    public void appendDataCopy(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(13);
        }
        if (data == null) {
            CaptureService.$$$reportNull$$$0(14);
        }
        try {
            assert (this.myAsyncWriterDelegate != null);
            this.myAsyncWriterDelegate.queueWrite(captureHandle, Arrays.copyOf(data, data.length));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void appendData(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(15);
        }
        if (data == null) {
            CaptureService.$$$reportNull$$$0(16);
        }
        try {
            assert (this.myAsyncWriterDelegate != null);
            this.myAsyncWriterDelegate.queueWrite(captureHandle, data);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void cancelCaptureFile(final @NotNull CaptureHandle captureHandle) {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(17);
        }
        this.finalizeCaptureFileAsynchronous(captureHandle, new FutureCallback<Capture>(){

            public void onSuccess(@Nullable Capture result2) {
                CaptureService.this.deleteBackingFile(captureHandle, result2);
            }

            public void onFailure(@NotNull Throwable ignored) {
                if (ignored == null) {
                    1.$$$reportNull$$$0(0);
                }
                captureHandle.getFile().delete();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/android/tools/idea/profiling/capture/CaptureService$1", "onFailure"));
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    void cancelCaptureFileSynchronous(@NotNull CaptureHandle captureHandle) throws InterruptedException, IOException {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(18);
        }
        Capture capture = this.finalizeCaptureFileSynchronous(captureHandle);
        this.deleteBackingFile(captureHandle, capture);
    }

    @NotNull
    Capture finalizeCaptureFileSynchronous(@NotNull CaptureHandle captureHandle) throws InterruptedException, IOException {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(19);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        Capture capture = this.createCapture(captureHandle);
        if (capture == null) {
            CaptureService.$$$reportNull$$$0(20);
        }
        return capture;
    }

    public void finalizeCaptureFileAsynchronous(final @NotNull CaptureHandle captureHandle, @Nullable FutureCallback<Capture> onCompletion, @Nullable Executor executor) {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(21);
        }
        final ListenableFutureTask postCloseTask = ListenableFutureTask.create((Callable)new Callable<Capture>(){

            @Override
            public Capture call() throws Exception {
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (captureHandle.getWriteToTempFile()) {
                    ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Object, IOException>(){

                        public Object compute() throws IOException {
                            String tempFilePath = captureHandle.getFile().getCanonicalPath();
                            assert (tempFilePath.endsWith(CaptureService.TEMP_FILE_EXTENSION));
                            String originalFilePath = tempFilePath.substring(0, tempFilePath.length() - CaptureService.TEMP_FILE_EXTENSION.length());
                            captureHandle.move(new File(originalFilePath));
                            return null;
                        }
                    });
                }
                return CaptureService.this.createCapture(captureHandle);
            }
        });
        if (onCompletion != null) {
            assert (executor != null);
            Futures.addCallback((ListenableFuture)postCloseTask, onCompletion, (Executor)executor);
        }
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)postCloseTask);
            }
        });
    }

    public boolean captureExists(String name) throws IOException {
        VirtualFile dir = this.createCapturesDirectory();
        return dir.findChild(name) != null;
    }

    private void deleteBackingFile(@NotNull CaptureHandle captureHandle, @Nullable Capture capture) {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(22);
        }
        boolean deleted = false;
        if (capture != null) {
            deleted = (Boolean)WriteAction.compute(() -> {
                try {
                    capture.getFile().delete((Object)this);
                    return true;
                }
                catch (Exception ignored) {
                    return false;
                }
            });
        }
        if (!deleted) {
            captureHandle.getFile().delete();
        }
    }

    private void closeCaptureFileInternal(@NotNull CaptureHandle captureHandle, @NotNull Runnable postCloseTask) {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(23);
        }
        if (postCloseTask == null) {
            CaptureService.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myOpenCaptureHandles.contains(captureHandle));
        assert (captureHandle.isWritable());
        assert (this.myAsyncWriterDelegate != null);
        try {
            this.myAsyncWriterDelegate.closeFileAndRunTaskAsynchronously(captureHandle, postCloseTask);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myOpenCaptureHandles.remove(captureHandle);
        if (this.myOpenCaptureHandles.isEmpty()) {
            try {
                assert (this.myAsyncWriterDelegate != null);
                this.myAsyncWriterDelegate.queueExit();
                this.myAsyncWriterDelegate = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Capture createCapture(Class<? extends CaptureType> clazz, byte[] data, @NotNull String name) throws IOException {
        if (name == null) {
            CaptureService.$$$reportNull$$$0(25);
        }
        CaptureHandle captureHandle = this.startCaptureFileSynchronous(clazz, name, false);
        try {
            CaptureService.appendDataSynchronous(captureHandle, data);
        }
        finally {
            captureHandle.closeFileOutputStream();
        }
        Capture capture = this.createCapture(captureHandle);
        if (capture == null) {
            CaptureService.$$$reportNull$$$0(26);
        }
        return capture;
    }

    public void addListener(@NotNull CaptureListener listener2) {
        if (listener2 == null) {
            CaptureService.$$$reportNull$$$0(27);
        }
        this.myListeners.add(listener2);
    }

    public void notifyCaptureReady(@NotNull Capture capture) {
        if (capture == null) {
            CaptureService.$$$reportNull$$$0(28);
        }
        for (CaptureListener listener2 : this.myListeners) {
            listener2.onReady(capture);
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, capture.getFile());
        FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
    }

    @NotNull
    private CaptureHandle startCaptureFileSynchronous(@NotNull Class<? extends CaptureType> clazz, final @Nullable String name, final boolean writeToTempFile) throws IOException {
        if (clazz == null) {
            CaptureService.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final CaptureType type = CaptureTypeService.getInstance().getType(clazz);
        assert (type != null);
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROFILING).setKind(AndroidStudioEvent.EventKind.PROFILING_CAPTURE).setProfilerCaptureType(type.getCaptureType()));
        File file = (File)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<File, IOException>(){

            public File compute() throws IOException {
                VirtualFile dir = CaptureService.this.createCapturesDirectory();
                String captureFileName = CaptureService.this.getCaptureFileName(name, type.getCaptureExtension(), writeToTempFile);
                File captureFile = new File(dir.createChildData(null, captureFileName).getPath());
                if (writeToTempFile) {
                    captureFile.deleteOnExit();
                }
                return captureFile;
            }
        });
        CaptureHandle captureHandle = new CaptureHandle(file, type, writeToTempFile);
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(30);
        }
        return captureHandle;
    }

    @NotNull
    private String getCaptureFileName(@Nullable String name, @NotNull String extension, boolean writeToTempFile) throws IOException {
        if (extension == null) {
            CaptureService.$$$reportNull$$$0(31);
        }
        String filename = name + extension;
        int i = 1;
        while (this.captureExists(filename) || writeToTempFile && this.captureExists(filename + TEMP_FILE_EXTENSION)) {
            filename = String.format("%s-%d%s", name, i++, extension);
        }
        String string = writeToTempFile ? filename + TEMP_FILE_EXTENSION : filename;
        if (string == null) {
            CaptureService.$$$reportNull$$$0(32);
        }
        return string;
    }

    static void appendDataSynchronous(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(33);
        }
        if (data == null) {
            CaptureService.$$$reportNull$$$0(34);
        }
        CaptureService.appendDataSynchronous(captureHandle, data, 0, data.length);
    }

    public static void appendDataSynchronous(@NotNull CaptureHandle captureHandle, @NotNull byte[] data, int offset, int length) throws IOException {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(35);
        }
        if (data == null) {
            CaptureService.$$$reportNull$$$0(36);
        }
        FileOutputStream localFileOutputStream = captureHandle.getFileOutputStream();
        assert (localFileOutputStream != null);
        localFileOutputStream.write(data, offset, length);
    }

    @NotNull
    private Capture createCapture(@NotNull CaptureHandle captureHandle) throws IOException {
        if (captureHandle == null) {
            CaptureService.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!captureHandle.isWritable());
        final File file = captureHandle.getFile();
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return VfsUtil.findFileByIoFile((File)file, (boolean)true);
            }
        });
        if (vf == null) {
            throw new IOException("Cannot find virtual file for capture file \"" + file.getPath() + "\"");
        }
        CaptureType type = captureHandle.getCaptureType();
        for (Capture capture : this.myCaptures.get((Object)type)) {
            if (!vf.equals(capture.getFile())) continue;
            Capture capture2 = capture;
            if (capture2 == null) {
                CaptureService.$$$reportNull$$$0(38);
            }
            return capture2;
        }
        Capture capture = type.createCapture(vf);
        this.myCaptures.put((Object)type, (Object)capture);
        Capture capture3 = capture;
        if (capture3 == null) {
            CaptureService.$$$reportNull$$$0(39);
        }
        return capture3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profiling/capture/CaptureService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureHandle";
                break;
            }
            case 14: 
            case 16: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postCloseTask";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profiling/capture/CaptureService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCapturesDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturesByType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptures";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "finalizeCaptureFileSynchronous";
                break;
            }
            case 26: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createCapture";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "startCaptureFileSynchronous";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCaptureFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startCaptureFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendDataCopy";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cancelCaptureFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cancelCaptureFileSynchronous";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "finalizeCaptureFileSynchronous";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "finalizeCaptureFileAsynchronous";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deleteBackingFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "closeCaptureFileInternal";
                break;
            }
            case 25: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createCapture";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "notifyCaptureReady";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "startCaptureFileSynchronous";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCaptureFileName";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "appendDataSynchronous";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CaptureListener {
        public void onReady(Capture var1);
    }
}

