/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view.nodes;

import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.view.nodes.CaptureNode;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.SortedList;
import java.util.Comparator;
import java.util.List;

public class CaptureTypeNode
extends SimpleNode {
    private final CaptureType myType;
    private final List<CaptureNode> myCaptureNodes;

    public CaptureTypeNode(CaptureType type) {
        this.myType = type;
        this.myCaptureNodes = new SortedList((Comparator)new Comparator<CaptureNode>(){

            @Override
            public int compare(CaptureNode a, CaptureNode b) {
                return a.getName().compareToIgnoreCase(b.getName());
            }
        });
        this.getTemplatePresentation().addText(type.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.setIcon(AllIcons.Modules.SourceFolder);
    }

    public SimpleNode[] getChildren() {
        return this.myCaptureNodes.toArray(new SimpleNode[0]);
    }

    public void addCapture(CaptureNode captureNode) {
        this.myCaptureNodes.add(captureNode);
    }

    public void clear() {
        this.myCaptureNodes.clear();
    }
}

