/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingSuspender {
    private static final Logger LOG = Logger.getInstance(IndexingSuspender.class);
    private boolean myTestingIndexingSuspender;
    @NotNull
    private final Project myProject;
    private boolean myScheduledAfterProjectInitialisation;
    @Nullable
    private DeactivationEvent myDeactivationEvent;
    private volatile boolean myActivated;

    public static void ensureInitialised(@NotNull Project project) {
        if (project == null) {
            IndexingSuspender.$$$reportNull$$$0(0);
        }
        ServiceManager.getService((Project)project, IndexingSuspender.class);
    }

    public IndexingSuspender(@NotNull Project project) {
        if (project == null) {
            IndexingSuspender.$$$reportNull$$$0(1);
        }
        this(project, false);
    }

    IndexingSuspender(@NotNull Project project, boolean testing) {
        if (project == null) {
            IndexingSuspender.$$$reportNull$$$0(2);
        }
        this.myTestingIndexingSuspender = testing;
        this.myProject = project;
        if (!this.canActivate()) {
            return;
        }
        this.subscribeToSyncAndBuildEvents();
    }

    private void consumeActivationEvent(@NotNull ActivationEvent event) {
        if (event == null) {
            IndexingSuspender.$$$reportNull$$$0(3);
        }
        LOG.info("Consuming IndexingSuspender activation event: " + event.toString());
        switch (event) {
            case SYNC_STARTED: {
                if (!this.myProject.isInitialized()) {
                    if (this.myActivated) {
                        this.ensureDeactivated();
                    }
                    this.myScheduledAfterProjectInitialisation = true;
                    StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
                        if (this.myScheduledAfterProjectInitialisation) {
                            this.activate(ActivationEvent.SYNC_STARTED, DeactivationEvent.SYNC_FINISHED);
                            this.myScheduledAfterProjectInitialisation = false;
                        }
                    });
                    break;
                }
                if (this.myActivated) break;
                this.activate(ActivationEvent.SYNC_STARTED, DeactivationEvent.SYNC_FINISHED);
                break;
            }
            case SETUP_STARTED: {
                if (!this.myProject.isInitialized()) {
                    this.clearStateConditions();
                    IndexingSuspender.reportStateError("Project is expected to be initialised before project setup starts.");
                    break;
                }
                if (this.myActivated) break;
                this.activate(ActivationEvent.SETUP_STARTED, DeactivationEvent.SYNC_FINISHED);
                break;
            }
            case BUILD_EXECUTOR_CREATED: {
                if (this.myDeactivationEvent != DeactivationEvent.SYNC_FINISHED) break;
                this.myDeactivationEvent = DeactivationEvent.BUILD_FINISHED;
                break;
            }
            case BUILD_STARTED: {
                if (this.myActivated) break;
                this.activate(ActivationEvent.BUILD_STARTED, DeactivationEvent.BUILD_FINISHED);
                break;
            }
            case TEMPLATE_RENDERING_STARTED: {
                if (this.myActivated) break;
                this.activate(ActivationEvent.TEMPLATE_RENDERING_STARTED, DeactivationEvent.TEMPLATE_RENDERING_FINISHED);
                break;
            }
            case SYNC_TASK_CREATED: {
                if (this.myDeactivationEvent != DeactivationEvent.TEMPLATE_RENDERING_FINISHED) break;
                this.myDeactivationEvent = DeactivationEvent.SYNC_FINISHED;
            }
        }
    }

    private void consumeDeactivationEvent(@NotNull DeactivationEvent event) {
        if (event == null) {
            IndexingSuspender.$$$reportNull$$$0(4);
        }
        LOG.info("Consuming IndexingSuspender deactivation event: " + event.toString());
        this.myScheduledAfterProjectInitialisation = false;
        if (event == this.myDeactivationEvent) {
            this.ensureDeactivated();
        } else {
            LOG.info("IndexingSuspender deactivation event received and ignored: " + event.toString());
        }
    }

    private static void reportStateError(@NotNull String message) {
        Application application;
        if (message == null) {
            IndexingSuspender.$$$reportNull$$$0(5);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            throw new IllegalStateException(message);
        }
        LOG.warn(message);
    }

    private void subscribeToSyncAndBuildEvents() {
        LOG.info(String.format("Subscribing project '%1$s' to indexing suspender events (%2$s)", this.myProject.toString(), this.toString()));
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener(){

            @Override
            public void syncTaskCreated(@NotNull Project project, @NotNull GradleSyncInvoker.Request request) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (request == null) {
                    1.$$$reportNull$$$0(1);
                }
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.SYNC_TASK_CREATED);
            }

            @Override
            public void syncStarted(@NotNull Project project, boolean skipped, boolean sourceGenerationRequested) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.SYNC_STARTED);
            }

            @Override
            public void setupStarted(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.SETUP_STARTED);
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(4);
                }
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.SYNC_FINISHED);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(6);
                }
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.SYNC_FINISHED);
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(7);
                }
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.SYNC_FINISHED);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/project/IndexingSuspender$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncTaskCreated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncStarted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setupStarted";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSkipped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        GradleBuildState.subscribe(this.myProject, new GradleBuildListener(){

            @Override
            public void buildExecutorCreated(@NotNull GradleBuildInvoker.Request request) {
                if (request == null) {
                    2.$$$reportNull$$$0(0);
                }
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.BUILD_EXECUTOR_CREATED);
            }

            @Override
            public void buildStarted(@NotNull BuildContext context) {
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.BUILD_STARTED);
            }

            @Override
            public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
                if (status == null) {
                    2.$$$reportNull$$$0(2);
                }
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.BUILD_FINISHED);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "status";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/project/IndexingSuspender$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "buildExecutorCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "buildStarted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "buildFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MultiTemplateRenderer.subscribe(this.myProject, new MultiTemplateRenderer.TemplateRendererListener(){

            @Override
            public void multiRenderingStarted() {
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.TEMPLATE_RENDERING_STARTED);
            }

            @Override
            public void multiRenderingFinished() {
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.TEMPLATE_RENDERING_FINISHED);
            }
        });
    }

    private void activate(@NotNull ActivationEvent activationEvent, @NotNull DeactivationEvent deactivationEvent) {
        if (activationEvent == null) {
            IndexingSuspender.$$$reportNull$$$0(6);
        }
        if (deactivationEvent == null) {
            IndexingSuspender.$$$reportNull$$$0(7);
        }
        if (this.myActivated) {
            IndexingSuspender.reportStateError("Must not attempt to activate IndexingSuspender when it is already activated. Ignored.");
            return;
        }
        if (!this.canActivate()) {
            LOG.info(String.format("Indexing suspension not activated (context: '%1$s')", activationEvent.name()));
            return;
        }
        if (activationEvent != ActivationEvent.TEMPLATE_RENDERING_STARTED && !this.myProject.isInitialized()) {
            IndexingSuspender.reportStateError("Attempt to suspend indexing when project is not yet initialised. Ignoring.");
            return;
        }
        this.myActivated = true;
        this.myDeactivationEvent = deactivationEvent;
        this.startBatchUpdate();
    }

    private void ensureDeactivated() {
        if (!this.canActivate() || !this.myActivated) {
            return;
        }
        this.finishBatchUpdate();
        this.clearStateConditions();
        this.myActivated = false;
    }

    private boolean canActivate() {
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return false;
        }
        if (!((Boolean)StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get()).booleanValue()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        return !application.isUnitTestMode() && !application.isHeadlessEnvironment() || this.myTestingIndexingSuspender;
    }

    private void clearStateConditions() {
        this.myDeactivationEvent = null;
    }

    private void startBatchUpdate() {
        LOG.info("Starting batch update for project: " + this.myProject.toString());
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

            public void execute() {
                ((BatchUpdateListener)IndexingSuspender.this.myProject.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateStarted();
                ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeStarted(IndexingSuspender.this.myProject, "batch update");
            }
        });
    }

    private void finishBatchUpdate() {
        LOG.info("Finishing batch update for project: " + this.myProject.toString());
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

            public void execute() {
                ((BatchUpdateListener)IndexingSuspender.this.myProject.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateFinished();
                ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeCompleted(IndexingSuspender.this.myProject);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activationEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deactivationEvent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/project/IndexingSuspender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureInitialised";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeActivationEvent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeDeactivationEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportStateError";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "activate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum DeactivationEvent {
        SYNC_FINISHED,
        BUILD_FINISHED,
        TEMPLATE_RENDERING_FINISHED;

    }

    private static enum ActivationEvent {
        SYNC_TASK_CREATED,
        SYNC_STARTED,
        SETUP_STARTED,
        BUILD_EXECUTOR_CREATED,
        BUILD_STARTED,
        TEMPLATE_RENDERING_STARTED;

    }
}

