/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEventResult;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueFileEvent;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.Failure;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyncMessages
implements Disposable {
    private Project myProject;
    @NotNull
    private final ConcurrentHashMap<Object, List<NotificationData>> myCurrentNotifications;
    @NotNull
    private final ConcurrentHashMap<Object, List<Failure>> myShownFailures;
    @NotNull
    private static final String PENDING_TASK_ID = "Pending taskId";

    protected AbstractSyncMessages(@NotNull Project project) {
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(0);
        }
        this.myCurrentNotifications = new ConcurrentHashMap();
        this.myShownFailures = new ConcurrentHashMap();
        this.myProject = project;
    }

    public int getErrorCount() {
        return this.countNotifications(notification -> notification.getNotificationCategory() == NotificationCategory.ERROR);
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            AbstractSyncMessages.$$$reportNull$$$0(1);
        }
        return this.countNotifications(notification -> {
            if (groupName == null) {
                AbstractSyncMessages.$$$reportNull$$$0(21);
            }
            return notification.getTitle().equals(groupName);
        });
    }

    private int countNotifications(@NotNull Predicate<NotificationData> condition) {
        if (condition == null) {
            AbstractSyncMessages.$$$reportNull$$$0(2);
        }
        int total = 0;
        for (List<NotificationData> notificationDataList : this.myCurrentNotifications.values()) {
            for (NotificationData notificationData : notificationDataList) {
                if (!condition.test(notificationData)) continue;
                ++total;
            }
        }
        return total;
    }

    public boolean isEmpty() {
        return this.myCurrentNotifications.isEmpty();
    }

    public void removeAllMessages() {
        this.myCurrentNotifications.clear();
    }

    public void removeMessages(String ... groupNames) {
        if (groupNames == null) {
            AbstractSyncMessages.$$$reportNull$$$0(3);
        }
        HashSet<String> groupSet = new HashSet<String>(Arrays.asList(groupNames));
        LinkedList toRemove = new LinkedList();
        for (Object id : this.myCurrentNotifications.keySet()) {
            List<NotificationData> taskNotifications = this.myCurrentNotifications.get(id);
            taskNotifications.removeIf(notification -> groupSet.contains(notification.getTitle()));
            if (!taskNotifications.isEmpty()) continue;
            toRemove.add(id);
        }
        for (Object taskId : toRemove) {
            this.myCurrentNotifications.remove(taskId);
        }
    }

    public void report(@NotNull SyncMessage message) {
        if (message == null) {
            AbstractSyncMessages.$$$reportNull$$$0(4);
        }
        String title = message.getGroup();
        String text = StringUtil.join((String[])message.getText(), (String)"\n");
        NotificationCategory category = message.getType().convertToCategory();
        PositionInFile position = message.getPosition();
        NotificationData notification = this.createNotification(title, text, category, position);
        Navigatable navigatable = message.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text, quickFixes);
        }
        this.report(notification);
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        if (title == null) {
            AbstractSyncMessages.$$$reportNull$$$0(5);
        }
        if (text == null) {
            AbstractSyncMessages.$$$reportNull$$$0(6);
        }
        if (category == null) {
            AbstractSyncMessages.$$$reportNull$$$0(7);
        }
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            NotificationData notificationData = new NotificationData(title, text, category, source, filePath, position.line, position.column, false);
            if (notificationData == null) {
                AbstractSyncMessages.$$$reportNull$$$0(8);
            }
            return notificationData;
        }
        NotificationData notificationData = new NotificationData(title, text, category, source);
        if (notificationData == null) {
            AbstractSyncMessages.$$$reportNull$$$0(9);
        }
        return notificationData;
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(10);
        }
        if (text == null) {
            AbstractSyncMessages.$$$reportNull$$$0(11);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(12);
        }
        String message = text;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(quickFixes.get(i).toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message = message + '\n' + b.toString();
        }
        notification.setMessage(message);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(13);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(14);
        }
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    public void report(@NotNull NotificationData notification) {
        Object taskId;
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(15);
        }
        if ((taskId = GradleSyncState.getInstance(this.myProject).getExternalSystemTaskId()) == null) {
            taskId = PENDING_TASK_ID;
        } else {
            this.showNotification(notification, taskId);
        }
        this.myCurrentNotifications.computeIfAbsent(taskId, key -> new ArrayList()).add(notification);
    }

    @NotNull
    public List<Failure> showEvents(@NotNull ExternalSystemTaskId taskId) {
        if (taskId == null) {
            AbstractSyncMessages.$$$reportNull$$$0(16);
        }
        for (NotificationData notification : this.myCurrentNotifications.getOrDefault(PENDING_TASK_ID, Collections.emptyList())) {
            this.showNotification(notification, taskId);
        }
        this.myCurrentNotifications.remove(taskId);
        this.myCurrentNotifications.remove(PENDING_TASK_ID);
        List<Object> result2 = this.myShownFailures.remove(taskId);
        if (result2 == null) {
            result2 = Collections.emptyList();
        }
        List<Failure> list = result2;
        if (list == null) {
            AbstractSyncMessages.$$$reportNull$$$0(17);
        }
        return list;
    }

    private void showNotification(@NotNull NotificationData notification, @NotNull Object taskId) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(18);
        }
        if (taskId == null) {
            AbstractSyncMessages.$$$reportNull$$$0(19);
        }
        String title = notification.getTitle();
        String[] lines = notification.getMessage().split(SystemProperties.getLineSeparator());
        if (lines.length > 0) {
            title = lines[0];
        }
        AndroidSyncIssueEvent issueEvent = notification.getFilePath() != null ? new AndroidSyncIssueFileEvent(taskId, notification, title) : new AndroidSyncIssueEvent(taskId, notification, title);
        ((SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class)).onEvent((BuildEvent)issueEvent);
        this.myShownFailures.computeIfAbsent(taskId, key -> new ArrayList()).addAll(((AndroidSyncIssueEventResult)issueEvent.getResult()).getFailures());
    }

    @NotNull
    protected abstract ProjectSystemId getProjectSystemId();

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(20);
        }
        return project;
    }

    public void dispose() {
        this.myProject = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 8: 
            case 9: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "showEvents";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessageCount";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "countNotifications";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeMessages";
                break;
            }
            case 4: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 8: 
            case 9: 
            case 17: 
            case 20: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showEvents";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMessageCount$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

