/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem;

import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystemProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/projectsystem/ProjectSystemComponent;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedProjectSystem", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectSystem", "getProjectSystem", "()Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "detectProjectSystem", "projectClosed", "", "project-system"})
public class ProjectSystemComponent
extends AbstractProjectComponent {
    private final AtomicReference<AndroidProjectSystem> cachedProjectSystem;
    @NotNull
    private final Project project;

    @NotNull
    public AndroidProjectSystem getProjectSystem() {
        AndroidProjectSystem cache = this.cachedProjectSystem.get();
        if (cache == null) {
            cache = this.detectProjectSystem(this.project);
            this.cachedProjectSystem.compareAndSet(null, cache);
            AndroidProjectSystem androidProjectSystem = this.cachedProjectSystem.get();
            if (androidProjectSystem == null) {
                Intrinsics.throwNpe();
            }
            cache = androidProjectSystem;
        }
        return cache;
    }

    private final AndroidProjectSystem detectProjectSystem(Project project) {
        AndroidProjectSystemProvider androidProjectSystemProvider;
        Object object;
        AndroidProjectSystemProvider it;
        Object[] objectArray;
        AndroidProjectSystemProvider[] extensions;
        block4: {
            extensions = (AndroidProjectSystemProvider[])ProjectSystemUtil.getEP_NAME().getExtensions((AreaInstance)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)extensions, (String)"extensions");
            for (Object object2 : objectArray = (Object[])extensions) {
                it = (AndroidProjectSystemProvider)object2;
                if (!it.isApplicable()) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        if ((androidProjectSystemProvider = (AndroidProjectSystemProvider)object) == null) {
            Object object3;
            block5: {
                for (Object object2 : objectArray = (Object[])extensions) {
                    it = (AndroidProjectSystemProvider)object2;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"")) continue;
                    object3 = object2;
                    break block5;
                }
                object3 = null;
            }
            androidProjectSystemProvider = (AndroidProjectSystemProvider)object3;
        }
        if (androidProjectSystemProvider == null) {
            throw (Throwable)new IllegalStateException("Default AndroidProjectSystem not found for project " + project.getName());
        }
        AndroidProjectSystemProvider provider = androidProjectSystemProvider;
        return provider.getProjectSystem();
    }

    public void projectClosed() {
        super.projectClosed();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectSystemComponent(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.cachedProjectSystem = new AtomicReference();
    }
}

