/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshRenderAction
extends AnAction {
    private final EditorDesignSurface mySurface;

    public RefreshRenderAction(EditorDesignSurface surface) {
        super(AndroidBundle.message("android.layout.preview.refresh.action.text", new Object[0]), null, null);
        this.mySurface = surface;
    }

    public void actionPerformed(AnActionEvent e) {
        RefreshRenderAction.clearCache(this.mySurface.getConfiguration());
        this.mySurface.forceUserRequestedRefresh();
    }

    public static void clearCacheAndRefreshSurface(@NotNull EditorDesignSurface surface) {
        if (surface == null) {
            RefreshRenderAction.$$$reportNull$$$0(0);
        }
        RefreshRenderAction.clearCache(surface.getConfiguration());
        surface.forceUserRequestedRefresh();
    }

    public static void clearCache(@Nullable Configuration configuration) {
        ModuleClassLoader.clearCache();
        if (configuration != null) {
            IAndroidTarget target = configuration.getTarget();
            Module module = configuration.getModule();
            if (module != null) {
                AndroidTargetData targetData;
                ResourceIdManager.get(module).resetDynamicIds();
                if (target != null && (targetData = AndroidTargetData.getTargetData(target, module)) != null) {
                    targetData.clearLayoutBitmapCache(module);
                }
                AndroidFacet facet = AndroidFacet.getInstance(module);
                Stream.concat(AndroidUtils.getAllAndroidDependencies(module, true).stream(), Stream.of(facet)).filter(Objects::nonNull).forEach(f -> ResourceRepositoryManager.getOrCreateInstance(f).resetAllCaches());
            }
            configuration.updated(254);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/rendering/RefreshRenderAction", "clearCacheAndRefreshSurface"));
    }
}

