/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.augment.ResourceTypeClass;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPackageRClass
extends AndroidLightClassBase {
    private static final Logger LOG = Logger.getInstance(AndroidPackageRClass.class);
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final String myFullyQualifiedName;
    @NotNull
    private final Module myModule;
    private CachedValue<PsiClass[]> myClassCache;

    public AndroidPackageRClass(@NotNull PsiManager psiManager, @NotNull String packageName, @NotNull Module module) {
        if (psiManager == null) {
            AndroidPackageRClass.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            AndroidPackageRClass.$$$reportNull$$$0(1);
        }
        if (module == null) {
            AndroidPackageRClass.$$$reportNull$$$0(2);
        }
        super(psiManager, (Collection<String>)ImmutableSet.of((Object)"public", (Object)"final"));
        this.myModule = module;
        this.myFullyQualifiedName = packageName + ".R";
        this.myFile = PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("R.java", (FileType)JavaFileType.INSTANCE, (CharSequence)("package " + packageName + ";"));
        this.putUserData(ModuleUtilCore.KEY_MODULE, module);
        this.myFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)module);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            AndroidPackageRClass.$$$reportNull$$$0(3);
        }
        return module;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).addValue((Object)this.getQualifiedName()).toString();
    }

    @Nullable
    public String getQualifiedName() {
        return this.myFullyQualifiedName;
    }

    public String getName() {
        return "R";
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        if (this.myClassCache == null) {
            this.myClassCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.doGetInnerClasses(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        }
        PsiClass[] psiClassArray = (PsiClass[])this.myClassCache.getValue();
        if (psiClassArray == null) {
            AndroidPackageRClass.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    private PsiClass[] doGetInnerClasses() {
        if (DumbService.isDumb((Project)this.getProject())) {
            LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            return PsiClass.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        if (facet == null) {
            LOG.debug("R_CLASS_AUGMENT: empty because no facet");
            return PsiClass.EMPTY_ARRAY;
        }
        EnumSet<ResourceType> types = ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
        ArrayList<ResourceTypeClass> result2 = new ArrayList<ResourceTypeClass>();
        for (ResourceType type : types) {
            result2.add(new ResourceTypeClass(facet, type.getName(), this));
        }
        LOG.debug("R_CLASS_AUGMENT: " + result2.size() + " classes added");
        return result2.toArray(PsiClass.EMPTY_ARRAY);
    }

    @Override
    public PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
        for (PsiClass aClass : this.getInnerClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AndroidPackageRClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AndroidPackageRClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

