/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.aar.AarResourceRepositoryCache;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AppResourceRepository
extends MultiResourceRepository {
    private static final Logger LOG = Logger.getInstance(AppResourceRepository.class);
    static final Key<Boolean> TEMPORARY_RESOURCE_CACHE = Key.create((String)"TemporaryResourceCache");
    private final AndroidFacet myFacet;
    private List<AarSourceResourceRepository> myLibraries;
    private long myIdsModificationCount;
    private Set<String> myIds;
    private final Object RESOURCE_MAP_LOCK;
    @Nullable
    private Multimap<String, VirtualFile> myResourceDirMap;

    @NotNull
    static AppResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(0);
        }
        List<AarSourceResourceRepository> libraries = AppResourceRepository.computeLibraries(facet);
        AppResourceRepository repository = new AppResourceRepository(facet, AppResourceRepository.computeRepositories(facet, libraries), libraries);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        AppResourceRepository appResourceRepository = repository;
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(1);
        }
        return appResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Multimap<String, VirtualFile> getAllResourceDirs() {
        Object object = this.RESOURCE_MAP_LOCK;
        // MONITORENTER : object
        if (this.myResourceDirMap == null) {
            this.myResourceDirMap = HashMultimap.create();
            for (LocalResourceRepository resourceRepository : this.getChildren()) {
                this.myResourceDirMap.putAll((Object)resourceRepository.getLibraryName(), resourceRepository.getResourceDirs());
            }
        }
        Multimap<String, VirtualFile> multimap = this.myResourceDirMap;
        // MONITOREXIT : object
        if (multimap != null) return multimap;
        AppResourceRepository.$$$reportNull$$$0(2);
        return multimap;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet, List<AarSourceResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(3);
        }
        ArrayList<LocalResourceRepository> repositories = new ArrayList<LocalResourceRepository>(10);
        LocalResourceRepository resources = ResourceRepositoryManager.getProjectResources(facet);
        repositories.addAll(libraries);
        repositories.add(resources);
        repositories.add(SampleDataResourceRepository.getInstance(facet));
        return repositories;
    }

    private static List<AarSourceResourceRepository> computeLibraries(@NotNull AndroidFacet facet) {
        List<AndroidFacet> dependentFacets;
        TreeMap<File, String> aarDirs;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(4);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("computeLibraries");
        }
        if ((aarDirs = new TreeMap<File, String>(ResourceRepositoryManager.findAarLibraries(facet, dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)))).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  No AARs");
            }
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            for (String libraryName : aarDirs.values()) {
                LOG.debug("  Dependency: " + LogAnonymizerUtil.anonymizeClassName((String)libraryName));
            }
        }
        AaptOptions.Namespacing namespacing = ResourceRepositoryManager.getOrCreateInstance(facet).getNamespacing();
        ArrayList<AarSourceResourceRepository> resources = new ArrayList<AarSourceResourceRepository>(aarDirs.size());
        for (Map.Entry entry : aarDirs.entrySet()) {
            File directory = (File)entry.getKey();
            String libraryName = (String)entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Dependency: " + LogAnonymizerUtil.anonymizeClassName((String)libraryName));
            }
            resources.add(AarResourceRepositoryCache.getInstance().get(directory, namespacing, libraryName));
        }
        return resources;
    }

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull List<AarSourceResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(5);
        }
        if (delegates == null) {
            AppResourceRepository.$$$reportNull$$$0(6);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(7);
        }
        super(facet.getModule().getName() + " with modules and libraries");
        this.RESOURCE_MAP_LOCK = new Object();
        this.myFacet = facet;
        this.myLibraries = libraries;
        this.setChildren(delegates);
    }

    @NotNull
    List<AarSourceResourceRepository> getLibraries() {
        List<AarSourceResourceRepository> list = this.myLibraries;
        if (list == null) {
            AppResourceRepository.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private Set<String> getAllIds() {
        long currentModCount = this.getModificationCount();
        if (this.myIdsModificationCount < currentModCount) {
            this.myIdsModificationCount = currentModCount;
            if (this.myIds == null) {
                int size = 0;
                for (AarSourceResourceRepository library : this.myLibraries) {
                    if (library.getAllDeclaredIds() == null) continue;
                    size += library.getAllDeclaredIds().size();
                }
                this.myIds = Sets.newHashSetWithExpectedSize((int)size);
            } else {
                this.myIds.clear();
            }
            for (AarSourceResourceRepository library : this.myLibraries) {
                if (library.getAllDeclaredIds() == null) continue;
                this.myIds.addAll(library.getAllDeclaredIds().keySet());
            }
            this.myIds.addAll(super.getItemsOfType(ResourceNamespace.TODO(), ResourceType.ID));
        }
        Set<String> set = this.myIds;
        if (set == null) {
            AppResourceRepository.$$$reportNull$$$0(9);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<String> getItemsOfType(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            AppResourceRepository.$$$reportNull$$$0(10);
        }
        if (type == null) {
            AppResourceRepository.$$$reportNull$$$0(11);
        }
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        Set<String> set = type == ResourceType.ID && namespace == ResourceNamespace.RES_AUTO ? this.getAllIds() : super.getItemsOfType(namespace, type);
        // MONITOREXIT : object
        if (set != null) return set;
        AppResourceRepository.$$$reportNull$$$0(12);
        return set;
    }

    void updateRoots() {
        List<AarSourceResourceRepository> libraries = AppResourceRepository.computeLibraries(this.myFacet);
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoots(@NotNull List<LocalResourceRepository> resources, @NotNull List<AarSourceResourceRepository> libraries) {
        if (resources == null) {
            AppResourceRepository.$$$reportNull$$$0(13);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(14);
        }
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            this.myResourceDirMap = null;
        }
        this.invalidateResourceDirs();
        if (resources.equals(this.getChildren())) {
            return;
        }
        this.myLibraries = libraries;
        this.setChildren(resources);
        ResourceIdManager.get(this.myFacet.getModule()).resetDynamicIds();
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules, @NotNull List<AarSourceResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(15);
        }
        if (modules == null) {
            AppResourceRepository.$$$reportNull$$$0(16);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(17);
        }
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        AppResourceRepository appResourceRepository = new AppResourceRepository(facet, modules, libraries);
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(18);
        }
        return appResourceRepository;
    }

    @Nullable
    AarSourceResourceRepository findRepositoryFor(@NotNull File aarDirectory) {
        if (aarDirectory == null) {
            AppResourceRepository.$$$reportNull$$$0(19);
        }
        String aarPath = aarDirectory.getPath();
        for (LocalResourceRepository localResourceRepository : this.myLibraries) {
            if (localResourceRepository instanceof AarSourceResourceRepository) {
                AarSourceResourceRepository repository = (AarSourceResourceRepository)localResourceRepository;
                if (!repository.getResourceDirectory().getPath().startsWith(aarPath)) continue;
                return repository;
            }
            assert (false) : ((Object)((Object)localResourceRepository)).getClass();
        }
        int exploded = aarPath.indexOf("exploded-aar");
        if (exploded != -1) {
            String string = aarPath.substring(exploded) + File.separator + "res";
            for (LocalResourceRepository localResourceRepository : this.myLibraries) {
                if (localResourceRepository instanceof AarSourceResourceRepository) {
                    AarSourceResourceRepository repository = (AarSourceResourceRepository)localResourceRepository;
                    String path = repository.getResourceDirectory().getPath();
                    if (!path.endsWith(string)) continue;
                    return repository;
                }
                assert (false) : ((Object)((Object)localResourceRepository)).getClass();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 7: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsOfType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeRepositories";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeLibraries";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getItemsOfType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateRoots";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findRepositoryFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

