/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.level2.Library;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.FileResourceOpener;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository
implements Disposable {
    private static File myFrameworkResDir;
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
        Disposer.register((Disposable)this.myFacet, (Disposable)this);
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(@NotNull String path, int mode) throws IOException {
        if (path == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(1);
        }
        assert (this.myFacet != null);
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getAssetsDirectories, Library::getAssetsFolder).map(assetDir -> {
            if (path == null) {
                AssetRepositoryImpl.$$$reportNull$$$0(10);
            }
            return assetDir.findFileByRelativePath(path);
        }).map(assetDir -> {
            if (assetDir == null) {
                return null;
            }
            try {
                return assetDir.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean isCachedFontFile(@NotNull VirtualFile file) {
        File fontCachePathFile;
        if (file == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(2);
        }
        if ((fontCachePathFile = DownloadableFontCacheService.getInstance().getFontPath()) == null) {
            return false;
        }
        VirtualFile fontCachePath = VirtualFileManager.getInstance().findFileByUrl("file://" + fontCachePathFile.getAbsolutePath());
        if (fontCachePath == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)fontCachePath, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path, int mode) throws IOException {
        String url;
        if (path == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(3);
        }
        assert (this.myFacet != null);
        if (path.startsWith("apk:")) {
            return FileResourceOpener.open(path);
        }
        if (path.startsWith("file://")) {
            url = path;
        } else {
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            url = "file://" + path;
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            return null;
        }
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getResDirectories, Library::getResFolder).filter(resDir -> VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file, (boolean)true)).map(resDir -> {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).findAny().orElseGet(() -> {
            if (AssetRepositoryImpl.isCachedFontFile(file)) {
                try {
                    return file.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    public boolean isFileResource(@NotNull String path) {
        if (path == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(4);
        }
        return ResourceHelper.isFileResource(path);
    }

    @NotNull
    private static Stream<VirtualFile> getDirectories(@NotNull AndroidFacet facet, @NotNull Function<IdeaSourceProvider, Collection<VirtualFile>> sourceMapper, @NotNull Function<Library, String> aarMapper) {
        if (facet == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(5);
        }
        if (sourceMapper == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(6);
        }
        if (aarMapper == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(7);
        }
        Stream dirsFromSources = Stream.concat(Stream.of(facet), AndroidUtils.getAllAndroidDependencies(facet.getModule(), true).stream()).flatMap(f -> IdeaSourceProvider.getAllIdeaSourceProviders(f).stream()).distinct().map(sourceMapper).flatMap(Collection::stream);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Stream<VirtualFile> dirsFromAars = ResourceRepositoryManager.findAarLibraries(facet).stream().map(aarMapper).map(path -> manager.findFileByUrl("file://" + path)).filter(Objects::nonNull);
        Stream<VirtualFile> frameworkDirs = Stream.of(AssetRepositoryImpl.getSdkResFolder(facet)).filter(Objects::nonNull).map(path -> manager.findFileByUrl("file://" + path)).filter(Objects::nonNull);
        Stream<VirtualFile> sampleDataDirs = Stream.of(ResourceContent.getSampleDataBaseDir()).filter(Objects::nonNull).map(dir -> manager.findFileByUrl("file://" + dir.getAbsolutePath())).filter(Objects::nonNull);
        Stream<VirtualFile> stream2 = Stream.of(dirsFromSources, dirsFromAars, frameworkDirs, sampleDataDirs).flatMap(stream -> stream);
        if (stream2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(8);
        }
        return stream2;
    }

    @Nullable
    private static File getSdkResFolder(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(9);
        }
        if (myFrameworkResDir == null) {
            ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(facet);
            IAndroidTarget target = manager.getHighestApiTarget();
            if (target == null) {
                return null;
            }
            CompatibilityRenderTarget compatibilityTarget = StudioEmbeddedRenderTarget.getCompatibilityTarget(target);
            String sdkPlatformPath = Files.simplifyPath((String)compatibilityTarget.getLocation());
            myFrameworkResDir = new File(sdkPlatformPath + "/data/res");
        }
        return myFrameworkResDir;
    }

    public void dispose() {
        this.myFacet = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AssetRepositoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AssetRepositoryImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openAsset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCachedFontFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openNonAsset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileResource";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSdkResFolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openAsset$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

